/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.client.HttpClientConnection;
import org.xlightweb.client.TransactionMonitor;
import org.xsocket.ILifeCycle;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpClientConnectionPool
implements IConnectionPool {
    private static final Logger LOG = Logger.getLogger(HttpClientConnectionPool.class.getName());
    public static final int DEFAULT_PERSISTENT_CONNECTION_TIMEOUT = 10000;
    private final NonBlockingConnectionPool pool;
    private final AtomicLong responseTimeoutMillis = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong bodyDataReceiveTimeoutMillis = new AtomicLong(Long.MAX_VALUE);
    private final AtomicBoolean isAutoCloseAfterResponse = new AtomicBoolean(true);
    private TransactionMonitor transactionMonitor = null;

    public HttpClientConnectionPool() {
        this(null);
    }

    public HttpClientConnectionPool(SSLContext sslContext) {
        if (sslContext == null) {
            try {
                Method m = SSLContext.class.getMethod("getDefault", new Class[0]);
                sslContext = (SSLContext)m.invoke(SSLContext.class, new Object[0]);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("default SSLContext -> SSLContext.getDefault() is loaded automatically");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pool = new NonBlockingConnectionPool(sslContext);
        this.pool.setPooledMaxIdleTimeMillis(10000);
    }

    NonBlockingConnectionPool getUnderlyingConnectionPool() {
        return this.pool;
    }

    public boolean isOpen() {
        return this.pool.isOpen();
    }

    public HttpClientConnection getHttpClientConnection(IHttpRequestHeader header) throws IOException, SocketTimeoutException {
        URL url = header.getRequestUrl();
        String host = url.getHost();
        int port = url.getPort();
        boolean isSSL = url.getProtocol().equalsIgnoreCase("HTTPS");
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(host, this.normalizePort(port, isSSL), 60000, isSSL));
    }

    public HttpClientConnection getHttpClientConnection(IHttpRequestHeader header, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        URL url = header.getRequestUrl();
        String host = url.getHost();
        int port = url.getPort();
        boolean isSSL = url.getProtocol().equalsIgnoreCase("HTTPS");
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(host, this.normalizePort(port, isSSL), connectTimeoutMillis, isSSL));
    }

    public HttpClientConnection getHttpClientConnection(String host, int port) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(host, this.normalizePort(port, false), 60000, false));
    }

    public HttpClientConnection getHttpClientConnection(String host, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(host, this.normalizePort(port, isSSL), 60000, isSSL));
    }

    public HttpClientConnection getHttpClientConnection(String host, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(host, this.normalizePort(port, false), connectTimeoutMillis, false));
    }

    public HttpClientConnection getHttpClientConnection(String host, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(host, this.normalizePort(port, isSSL), connectTimeoutMillis, isSSL));
    }

    public HttpClientConnection getHttpClientConnection(InetAddress address, int port) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(address, this.normalizePort(port, false), 60000, false));
    }

    public HttpClientConnection getHttpClientConnection(InetAddress address, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(address, this.normalizePort(port, isSSL), 60000, isSSL));
    }

    public HttpClientConnection getHttpClientConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(address, this.normalizePort(port, false), connectTimeoutMillis, false));
    }

    public HttpClientConnection getHttpClientConnection(InetAddress address, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.newHttpClientConnection(this.pool.getNonBlockingConnection(address, this.normalizePort(port, isSSL), connectTimeoutMillis, isSSL));
    }

    private int normalizePort(int port, boolean isSecured) {
        if (port == -1) {
            if (isSecured) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    private HttpClientConnection newHttpClientConnection(INonBlockingConnection con) throws IOException {
        HttpClientConnection httpConnection = new HttpClientConnection(con);
        httpConnection.setResponseTimeoutMillis(this.responseTimeoutMillis.get());
        httpConnection.setBodyDataReceiveTimeoutMillis(this.bodyDataReceiveTimeoutMillis.get());
        httpConnection.setAutocloseAfterResponse(this.isAutoCloseAfterResponse.get());
        if (this.transactionMonitor != null) {
            httpConnection.setTransactionMonitor(this.transactionMonitor);
        }
        return httpConnection;
    }

    void setTranactionMonitor(TransactionMonitor transactionMonitor) {
        this.transactionMonitor = transactionMonitor;
    }

    void setWorkerpool(Executor workerpool) {
        this.pool.setWorkerpool(workerpool);
    }

    Executor getWorkerpool() {
        return this.pool.getWorkerpool();
    }

    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        if (responseTimeoutMillis < 0L) {
            LOG.warning("try to set response timeout with " + responseTimeoutMillis + ". This will be ignored");
            return;
        }
        this.responseTimeoutMillis.set(responseTimeoutMillis);
    }

    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis.get();
    }

    public void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        if (this.responseTimeoutMillis.get() < 0L) {
            LOG.warning("try to set bodydata receive timeout with " + this.responseTimeoutMillis + ". This will be ignored");
            return;
        }
        this.bodyDataReceiveTimeoutMillis.set(bodyDataReceiveTimeoutMillis);
    }

    public long getBodyDataReceiveTimeoutMillis() {
        return this.bodyDataReceiveTimeoutMillis.get();
    }

    public void setAutocloseAfterResponse(boolean isAutoCloseAfterResponse) {
        this.isAutoCloseAfterResponse.set(isAutoCloseAfterResponse);
    }

    public boolean isAutoCloseAfterResponse() {
        return this.isAutoCloseAfterResponse.get();
    }

    public void addListener(ILifeCycle listener) {
        this.pool.addListener(listener);
    }

    public boolean removeListener(ILifeCycle listener) {
        return this.pool.removeListener(listener);
    }

    public int getPooledMaxIdleTimeMillis() {
        return this.pool.getPooledMaxIdleTimeMillis();
    }

    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.pool.setPooledMaxIdleTimeMillis(idleTimeoutMillis);
    }

    public int getPooledMaxLifeTimeMillis() {
        return this.pool.getPooledMaxLifeTimeMillis();
    }

    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.pool.setPooledMaxLifeTimeMillis(lifeTimeoutMillis);
    }

    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public int getMaxActivePerServer() {
        return this.pool.getMaxActivePerServer();
    }

    public void setMaxActivePerServer(int maxActivePerServer) {
        this.pool.setMaxActivePerServer(maxActivePerServer);
    }

    public int getMaxWaiting() {
        return 0;
    }

    public boolean isPooled() {
        return false;
    }

    public void setPooled(boolean isPooled) {
        if (!isPooled) {
            LOG.warning("isPooled is deprecated and will be ignored");
        }
    }

    public void setMaxWaiting(int maxWaiting) {
        LOG.warning("maxWaiting is deprecated and will be ignored");
    }

    public long getCreationMaxWaitMillis() {
        return 0L;
    }

    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        LOG.warning("creationMaxWaitMillis is deprecated and will be ignored");
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    public List<String> getActiveConnectionInfos() {
        return this.pool.getActiveConnectionInfos();
    }

    public List<String> getIdleConnectionInfos() {
        return this.pool.getIdleConnectionInfos();
    }

    public int getNumCreated() {
        return this.pool.getNumCreated();
    }

    public int getNumCreationError() {
        return this.pool.getNumCreationError();
    }

    public int getNumDestroyed() {
        return this.pool.getNumDestroyed();
    }

    public int getNumTimeoutPooledMaxIdleTime() {
        return this.pool.getNumTimeoutPooledMaxIdleTime();
    }

    public int getNumTimeoutPooledMaxLifeTime() {
        return this.pool.getNumTimeoutPooledMaxLifeTime();
    }

    public int getNumPendingGet() {
        return this.pool.getNumPendingGet();
    }

    public void close() {
        this.pool.close();
    }

    public void destroy(HttpClientConnection httpConnection) throws IOException {
        NonBlockingConnectionPool.destroy((INonBlockingConnection)httpConnection.getUnderlyingTcpConnection());
    }

    public String toString() {
        return this.pool.toString();
    }
}

