/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.Supports100Continue;
import org.xlightweb.client.CookieManager;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;

@Supports100Continue
final class CookieHandler
implements IHttpRequestHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(CookieHandler.class.getName());
    static final String COOKIE_WARNING_KEY = "org.xlightweb.client.cookieHandler.cookieWarning";
    private CookieManager cookieManager = null;

    CookieHandler() {
    }

    public void onInit() {
        this.cookieManager = new CookieManager();
    }

    public void onDestroy() throws IOException {
        this.cookieManager.close();
    }

    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request;
        block5: {
            request = exchange.getRequest();
            try {
                Map<String, List<String>> cookieHeaders = this.cookieManager.get(this.getRequestURI(exchange));
                for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    StringBuilder sb = new StringBuilder();
                    List<String> cookies = entry.getValue();
                    for (int i = 0; i < cookies.size(); ++i) {
                        sb.append(cookies.get(i));
                        if (i + 1 >= cookies.size()) continue;
                        sb.append("; ");
                    }
                    if (request.getHeader("Cookie") != null && this.isCookieWarning(request)) {
                        LOG.warning("cookie is set manually and auto handle cookie is activated (hint: deactivate auto handling cookie by calling <httpClient>.setAutoHandleCookies(false) or suppress this message by setting system property 'org.xlightweb.client.cookieHandler.cookieWarning=false')");
                    }
                    request.addHeader(entry.getKey(), sb.toString());
                }
            }
            catch (URISyntaxException ue) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("invcalid URI. ignore handling cookies " + ue.toString());
            }
        }
        exchange.forward(request, (IHttpResponseHandler)new ResponseHandler(exchange));
    }

    private boolean isCookieWarning(IHttpRequest request) {
        if (request.getAttribute(COOKIE_WARNING_KEY) != null) {
            return ((Boolean)request.getAttribute(COOKIE_WARNING_KEY)).equals(Boolean.TRUE);
        }
        return Boolean.parseBoolean(System.getProperty(COOKIE_WARNING_KEY, "true"));
    }

    private URI getRequestURI(IHttpExchange exchange) throws URISyntaxException {
        return exchange.getRequest().getRequestUrl().toURI();
    }

    @Supports100Continue
    private final class ResponseHandler
    implements IHttpResponseHandler {
        private final IHttpExchange exchange;

        public ResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        @Execution(value=0)
        public void onResponse(IHttpResponse response) throws IOException {
            block4: {
                if (response.getStatus() > 100) {
                    HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                    for (String headername : response.getHeaderNameSet()) {
                        responseHeaders.put(headername, response.getHeaderList(headername));
                    }
                    try {
                        CookieHandler.this.cookieManager.put(CookieHandler.this.getRequestURI(this.exchange), responseHeaders);
                    }
                    catch (URISyntaxException ue) {
                        if (!LOG.isLoggable(Level.FINE)) break block4;
                        LOG.fine("invcalid URI. ignore handling cookies " + ue.toString());
                    }
                }
            }
            this.exchange.send(response);
        }

        @Execution(value=0)
        public void onException(IOException ioe) throws IOException {
            this.exchange.sendError(ioe);
        }
    }
}

