/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSink;
import org.xlightweb.IHttpMessageHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IWriteCompletionHandler;

final class SimpleMessageBodyDataSink
extends AbstractNetworkBodyDataSink {
    private static final Logger LOG = Logger.getLogger(SimpleMessageBodyDataSink.class.getName());
    private boolean isHeaderWritten = false;

    public SimpleMessageBodyDataSink(AbstractHttpConnection httpConnection, IHttpMessageHeader header) throws IOException {
        super(header, httpConnection);
    }

    int onWriteNetworkData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        int bodyWritten = 0;
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            try {
                int dataWritten = 0;
                if (!this.isHeaderWritten) {
                    this.isHeaderWritten = true;
                    dataWritten = con.write(this.getHeader().toString() + "\r\n");
                    bodyWritten = this.writeBody(con, dataToWrite, completionHandler);
                    dataWritten += bodyWritten;
                    con.incCountMessageSent();
                } else {
                    bodyWritten = this.writeBody(con, dataToWrite, completionHandler);
                    dataWritten += bodyWritten;
                }
                if (dataWritten > 0) {
                    con.flush();
                }
            }
            catch (IOException ioe) {
                if (this.isIgnoreWriteError()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] error occured by flushing simple body data sink. Ignoring error (ignoreWriteError=true) " + DataConverter.toString((Throwable)ioe));
                    }
                    if (completionHandler != null) {
                        completionHandler.onWritten(dataToWrite.length);
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing simple body data sink. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
        }
        return bodyWritten;
    }

    protected int writeBody(AbstractHttpConnection con, ByteBuffer[] bodyData, IWriteCompletionHandler completionHandler) throws IOException {
        if (bodyData != null) {
            return (int)con.write(bodyData, completionHandler);
        }
        if (completionHandler != null) {
            completionHandler.onWritten(0);
        }
        return 0;
    }

    void performClose() throws IOException {
        this.writeData(null, null);
    }

    void performDestroy() throws IOException {
    }
}

