/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xlightweb.AbstractParser;
import org.xlightweb.Header;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IHeader;
import org.xlightweb.IPart;
import org.xlightweb.IPartHandler;
import org.xlightweb.InMemoryBodyDataSource;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.Part;
import org.xsocket.Execution;

@Execution(value=0)
final class PartParser
extends AbstractParser
implements IBodyDataHandler {
    private static final int READING_BEGIN_BOUNDARY = 0;
    private static final int READING_HEADER = 5;
    private static final int READING_CONTENT = 9;
    private static final int IS_COMPLETE = 15;
    private int state = 0;
    private final List<IPart> parts = new ArrayList<IPart>();
    private final NonBlockingBodyDataSource dataSource;
    private final byte[] endBoundary;
    private IPartHandler partHandler;
    private final AtomicBoolean isTotalComplete = new AtomicBoolean(false);
    private ByteBuffer rawData = null;
    private IPart part = null;

    public PartParser(IPartHandler partHandler, NonBlockingBodyDataSource dataSource, String dashBoundaryString, ByteBuffer[] rawData) {
        this.endBoundary = (dashBoundaryString + "--").getBytes();
        this.dataSource = dataSource;
        this.rawData = HttpUtils.merge(rawData);
        this.partHandler = partHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPartHandler(IPartHandler partHandler) throws IOException {
        List<IPart> list = this.parts;
        synchronized (list) {
            this.partHandler = partHandler;
            for (int i = 0; i < this.parts.size(); ++i) {
                partHandler.onPart(this.dataSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPart readPart() throws ClosedChannelException {
        List<IPart> list = this.parts;
        synchronized (list) {
            if (this.parts.isEmpty()) {
                if (this.isTotalComplete.get()) {
                    throw new ClosedChannelException();
                }
                throw new BufferUnderflowException();
            }
            return this.parts.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int availableParts() {
        List<IPart> list = this.parts;
        synchronized (list) {
            return this.parts.size();
        }
    }

    public boolean onData(NonBlockingBodyDataSource bodyDataSource) {
        try {
            int previousSize;
            int currentSize;
            int available = bodyDataSource.available();
            if (available > 0) {
                this.rawData = HttpUtils.merge(this.rawData, bodyDataSource.readByteBufferByLength(available));
            }
            do {
                previousSize = this.rawData.remaining();
                this.parse(this.rawData);
            } while ((currentSize = this.rawData.remaining()) != 0 && currentSize != previousSize);
            if (available == -1 && !this.isTotalComplete.get()) {
                throw new IOException("incomplete multpart received");
            }
            return true;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(ByteBuffer rawData) throws IOException {
        switch (this.state) {
            case 0: {
                boolean found = this.parseBoundary(rawData);
                if (!found) break;
                this.state = 5;
                break;
            }
            case 5: {
                Header header = this.parseHeader(rawData);
                if (header == null) break;
                InMemoryBodyDataSource body = new InMemoryBodyDataSource(header);
                this.part = new Part((IHeader)header, body);
                this.state = 9;
                break;
            }
            case 9: {
                int result = this.readContent(rawData);
                if (result <= 0) break;
                this.part.getNonBlockingBody().setComplete();
                List<IPart> list = this.parts;
                synchronized (list) {
                    this.parts.add(this.part);
                    if (result == 2) {
                        this.state = 15;
                        this.isTotalComplete.set(true);
                    } else {
                        this.state = 5;
                    }
                    if (this.partHandler != null) {
                        this.partHandler.onPart(this.dataSource);
                        if (this.isTotalComplete.get()) {
                            this.partHandler.onPart(this.dataSource);
                        }
                    }
                }
                this.part = null;
                break;
            }
        }
    }

    public boolean parseBoundary(ByteBuffer rawData) throws IOException {
        int savePosition = rawData.position();
        int idx = 0;
        boolean crFound = false;
        try {
            while (true) {
                byte b;
                if ((b = rawData.get()) == 10) {
                    if (idx == this.endBoundary.length - 2) {
                        return true;
                    }
                    idx = 0;
                    crFound = false;
                    continue;
                }
                if (b == 13) {
                    if (crFound) {
                        idx = 0;
                        crFound = false;
                        continue;
                    }
                    crFound = true;
                    continue;
                }
                if (b == this.endBoundary[idx]) {
                    ++idx;
                    continue;
                }
                crFound = false;
                idx = 0;
            }
        }
        catch (BufferUnderflowException bue) {
            rawData.position(savePosition);
            return false;
        }
    }

    public Header parseHeader(ByteBuffer rawData) throws IOException {
        int savePosition = rawData.position();
        Header header = new Header();
        try {
            PartParser.parseHeaderLines(rawData, header);
            return header;
        }
        catch (BufferUnderflowException bue) {
            rawData.position(savePosition);
            return null;
        }
    }

    public int readContent(ByteBuffer rawData) throws IOException {
        int savePosition = rawData.position();
        int idx = 0;
        int startPos = 0;
        boolean crFound = false;
        try {
            while (true) {
                byte b;
                if ((b = rawData.get()) == 10) {
                    boolean isEndBoundary;
                    boolean isDashBoundary = idx == this.endBoundary.length - 2;
                    boolean bl = isEndBoundary = idx == this.endBoundary.length;
                    if (isEndBoundary || isDashBoundary) {
                        int pos = rawData.position();
                        PartParser.consumeStringWithoutTailingCR(savePosition, rawData.position() - savePosition, rawData);
                        ByteBuffer buf = rawData.duplicate();
                        buf.position(savePosition);
                        buf.limit(startPos);
                        PartParser.removeTailingCRLF(buf);
                        ((InMemoryBodyDataSource)this.part.getNonBlockingBody()).append(buf);
                        rawData.position(pos);
                        if (isEndBoundary) {
                            return 2;
                        }
                        return 1;
                    }
                    idx = 0;
                    crFound = false;
                    startPos = rawData.position();
                    continue;
                }
                if (b == 13) {
                    if (crFound) {
                        idx = 0;
                        startPos = rawData.position();
                        crFound = false;
                        continue;
                    }
                    crFound = true;
                    continue;
                }
                if (b == this.endBoundary[idx]) {
                    ++idx;
                    continue;
                }
                idx = 0;
                crFound = false;
                startPos = rawData.position();
            }
        }
        catch (BufferUnderflowException bue) {
            if (idx != 0) {
                rawData.position(savePosition);
            } else {
                rawData.position(savePosition);
                ((InMemoryBodyDataSource)this.part.getNonBlockingBody()).append(rawData.duplicate());
                rawData.position(rawData.limit());
            }
            return 0;
        }
    }
}

