/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSource;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;

final class MultipartByteRangeMessageBodyDataSource
extends AbstractNetworkBodyDataSource {
    private static final Logger LOG = Logger.getLogger(MultipartByteRangeMessageBodyDataSource.class.getName());
    private String separator;
    private String endSeparator;
    private int separatorIdx = 0;
    private boolean isRead = false;
    private final StringBuilder stringBuilder = new StringBuilder();

    public MultipartByteRangeMessageBodyDataSource(AbstractHttpConnection httpConnection, HttpMessageHeader header) throws IOException {
        super(header, httpConnection);
        String contentType = header.getContentType();
        for (String token : contentType.split(";")) {
            if (!(token = token.trim()).toLowerCase().startsWith("boundary=")) continue;
            this.separator = token.substring("boundary=".length(), token.length()).trim();
            this.endSeparator = "--" + this.separator + "--";
        }
        this.postCreate();
    }

    String getSeparator() {
        return this.separator;
    }

    void doParse(ByteBuffer[] rawData) throws IOException {
        for (ByteBuffer buffer : rawData) {
            if (buffer == null) continue;
            int remaining = buffer.remaining();
            for (int i = 0; i < remaining; ++i) {
                byte b = buffer.get();
                if (b == (byte)this.endSeparator.charAt(this.separatorIdx)) {
                    ++this.separatorIdx;
                    if (this.separatorIdx != this.endSeparator.length()) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("body read. set complete true");
                    }
                    this.stringBuilder.append(this.endSeparator);
                    this.stringBuilder.append("\r\n");
                    this.onReadNetworkData(DataConverter.toByteBuffer((String)this.stringBuilder.toString(), (String)this.getHeader().getCharacterEncoding()));
                    this.isRead = true;
                    this.setComplete();
                    return;
                }
                if (this.separatorIdx > 0) {
                    this.stringBuilder.append(this.endSeparator.substring(0, this.separatorIdx));
                    this.separatorIdx = 0;
                    continue;
                }
                this.stringBuilder.append((char)b);
            }
        }
    }

    void onClose() throws IOException {
        if (!this.isRead) {
            throw new ProtocolException("connection has been closed (by user?) while receiving body data. (MultipartByteRangeMessage)", null);
        }
    }

    void performOnDisconnect() throws ProtocolException {
        if (!this.isRead) {
            throw new ProtocolException("connection has been closed (by peer?) while receiving body data. (MultipartByteRangeMessage)", null);
        }
    }
}

