/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpMessage;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSource;
import org.xlightweb.FileDataSource;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.MultipartByteRangeFileDataSource;
import org.xlightweb.MultivalueMap;
import org.xlightweb.NameValuePair;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse
extends AbstractHttpMessage
implements IHttpResponse {
    private static final Logger LOG = Logger.getLogger(HttpResponse.class.getName());
    private final boolean isSimpleResponse;

    public HttpResponse(IHttpResponseHeader responseHeader) {
        super(responseHeader);
        this.isSimpleResponse = false;
    }

    public HttpResponse(int status) {
        this(new HttpResponseHeader(status));
    }

    HttpResponse(Exception exception) throws IOException {
        this(500, "text/plain", DataConverter.toString((Throwable)exception));
    }

    HttpResponse(IHttpResponseHeader responseHeader, NonBlockingBodyDataSource bodyDataSource, boolean isSimpleResponse) throws IOException {
        super(responseHeader);
        this.isSimpleResponse = isSimpleResponse;
        if (bodyDataSource != null && bodyDataSource.available() != -1) {
            this.setBody(bodyDataSource);
        } else {
            this.setContentLength(0);
        }
    }

    public HttpResponse(IHttpResponseHeader responseHeader, ByteBuffer[] body, boolean compress) throws IOException {
        this(responseHeader);
        this.setBody(responseHeader, body, compress);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, NonBlockingBodyDataSource bodyDataSource) throws IOException {
        this(responseHeader, bodyDataSource, false);
    }

    public HttpResponse(int status, String contentType, int contentLength, BodyDataSource body) throws IOException {
        this(status, contentType, contentLength, body.getUnderliyingBodyDataSource());
    }

    public HttpResponse(int status, String contentType, int contentLength, NonBlockingBodyDataSource body) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status, contentType), body);
        this.setContentLength(contentLength);
    }

    public HttpResponse(String contentType, NonBlockingBodyDataSource bodyDataSource) throws IOException {
        this((IHttpResponseHeader)HttpResponse.newResponseHeader(200, contentType, bodyDataSource), bodyDataSource);
    }

    public HttpResponse(String contentType, BodyDataSource bodyDataSource) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(200, contentType), bodyDataSource.getUnderliyingBodyDataSource());
    }

    public HttpResponse(String contentType, String body) throws IOException {
        this(200, contentType, body);
    }

    public HttpResponse(String body) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(200), body);
    }

    public HttpResponse(File file) throws IOException {
        this(200, file);
    }

    public HttpResponse(int status, File file) throws IOException {
        this(status, HttpUtils.resolveContentTypeByFileExtension(file), file);
    }

    public HttpResponse(int status, String contentType, File file) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status, contentType), file);
    }

    public HttpResponse(int status, String contentType, File file, String range) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status, contentType), file, range);
    }

    public HttpResponse(int status, NameValuePair ... nvp) throws IOException {
        this(status, "application/x-www-form-urlencoded; charset=utf-8", new MultivalueMap("utf-8", nvp).toString());
    }

    public HttpResponse(IHttpResponseHeader header, File file) throws IOException {
        this(header, file, null);
    }

    public HttpResponse(IHttpResponseHeader header, File file, String range) throws IOException {
        this(header);
        header.setHeader("Accept-Ranges", "bytes");
        String contentType = HttpUtils.resolveContentTypeByFileExtension(file);
        if (contentType != null) {
            header.setContentType(contentType);
        }
        if (range == null || range.split(",").length == 0) {
            this.setContentLength((int)file.length());
            this.setBody(new FileDataSource(header, HttpUtils.newMultimodeExecutor(), file, range));
        } else {
            if (!range.toLowerCase().startsWith("bytes=")) {
                throw new BadMessageException("invalid range header " + range);
            }
            String[] ranges = (range = range.substring("bytes=".length(), range.length())).split(",");
            if (ranges.length == 1) {
                header.setStatus(206);
                header.setReason(HttpUtils.getReason(header.getStatus()));
                int length = (int)file.length();
                int[] positions = HttpUtils.computeFromRangePosition(range, length);
                header.setHeader("Content-range", "bytes " + positions[0] + "-" + positions[1] + "/" + length);
                length = positions[1] - positions[0] + 1;
                this.setContentLength(length);
                this.setBody(new FileDataSource(header, HttpUtils.newMultimodeExecutor(), file, ranges[0]));
            } else {
                header.setStatus(206);
                header.setReason(HttpUtils.getReason(header.getStatus()));
                String boundary = UUID.randomUUID().toString();
                this.setContentType("multipart/byteranges; boundary=" + boundary);
                this.setBody(new MultipartByteRangeFileDataSource(header, HttpUtils.newMultimodeExecutor(), file, ranges, boundary));
            }
        }
    }

    public HttpResponse(int status, String contentType, String body) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status, contentType), body);
    }

    public HttpResponse(int status, String contentType, String body, boolean compress) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status, contentType), body, compress);
    }

    public HttpResponse(int status, String body) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status), new ByteBuffer[]{DataConverter.toByteBuffer((String)body, (String)"ISO-8859-1")});
    }

    public HttpResponse(String contentType, byte[] body) throws IOException {
        this(200, contentType, body);
    }

    public HttpResponse(int status, String contentType, NonBlockingBodyDataSource body) throws IOException {
        this((IHttpResponseHeader)HttpResponse.newResponseHeader(status, contentType, body), body);
    }

    private static HttpResponseHeader newResponseHeader(int status, String contentType, NonBlockingBodyDataSource body) throws IOException {
        HttpResponseHeader responseHeader;
        if (body.isComplete()) {
            responseHeader = new HttpResponseHeader(status, contentType);
            responseHeader.setContentLength(body.available());
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("body is not complete. Set transfer-enncoding header with chunked");
            }
            responseHeader = new HttpResponseHeader(status, contentType);
            responseHeader.setHeader("Transfer-encoding", "chunked");
        }
        return responseHeader;
    }

    public HttpResponse(int status, String contentType, BodyDataSource body) throws IOException {
        this(status, contentType, body.getUnderliyingBodyDataSource());
    }

    public HttpResponse(int status, String contentType, byte[] body) throws IOException {
        this(status, contentType, body, false);
    }

    public HttpResponse(int status, String contentType, byte[] body, boolean compress) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status, contentType), new ByteBuffer[]{DataConverter.toByteBuffer((byte[])body)}, compress);
    }

    public HttpResponse(String contentType, ByteBuffer[] body) throws IOException {
        this(200, contentType, body);
    }

    public HttpResponse(int status, String contentType, ByteBuffer[] body) throws IOException {
        this(status, contentType, body, HttpUtils.parseEncodingWithDefault(contentType, IHttpMessage.DEFAULT_ENCODING));
    }

    HttpResponse(int status, String contentType, ByteBuffer[] body, String encoding) throws IOException {
        this(status, contentType, body, encoding, false);
    }

    HttpResponse(int status, String contentType, ByteBuffer[] body, String encoding, boolean compress) throws IOException {
        this((IHttpResponseHeader)HttpResponse.newResponseHeader(status, contentType, encoding), body, compress);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, String body) throws IOException {
        this(responseHeader, body, false);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, String body, boolean compress) throws IOException {
        this(responseHeader, HttpResponse.convert(responseHeader, body), compress);
    }

    private static ByteBuffer[] convert(IHttpResponseHeader responseHeader, String body) {
        if (responseHeader.getContentType() != null && HttpUtils.isTextMimeType(responseHeader.getContentType()) && HttpUtils.parseEncoding(responseHeader.getContentType()) == null) {
            responseHeader.setContentType(responseHeader.getContentType() + "; charset=utf-8");
        }
        return new ByteBuffer[]{DataConverter.toByteBuffer((String)body, (String)responseHeader.getCharacterEncoding())};
    }

    public HttpResponse(IHttpResponseHeader responseHeader, byte[] body) throws IOException {
        this(responseHeader, body, false);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, byte[] body, boolean compress) throws IOException {
        this(responseHeader, new ByteBuffer[]{DataConverter.toByteBuffer((byte[])body)}, compress);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, List<ByteBuffer> body) throws IOException {
        this(responseHeader, body, false);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, List<ByteBuffer> body, boolean compress) throws IOException {
        this(responseHeader, HttpResponse.toArray(body), compress);
    }

    public HttpResponse(IHttpResponseHeader responseHeader, ByteBuffer[] body) throws IOException {
        this(responseHeader, body, false);
    }

    private static HttpResponseHeader newResponseHeader(int status, String contentType, String encoding) {
        if (HttpUtils.parseEncoding(contentType) == null && HttpUtils.isContentTypeSupportsCharset(contentType)) {
            contentType = contentType + "; charset=" + encoding;
        }
        return new HttpResponseHeader(status, contentType);
    }

    private static ByteBuffer[] toArray(List<ByteBuffer> buffers) {
        if (buffers == null) {
            return null;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    @Override
    public final int getStatus() {
        return this.getResponseHeader().getStatus();
    }

    @Override
    public final void setStatus(int status) {
        this.getResponseHeader().setStatus(status);
    }

    @Override
    public String getServer() {
        return this.getResponseHeader().getServer();
    }

    @Override
    public void setServer(String server) {
        this.getResponseHeader().setServer(server);
    }

    @Override
    public void setDate(String date) {
        this.getResponseHeader().setDate(date);
    }

    @Override
    public String getDate() {
        return this.getResponseHeader().getDate();
    }

    @Override
    public final String getReason() {
        return this.getResponseHeader().getReason();
    }

    @Override
    public void setReason(String reason) {
        this.getResponseHeader().setReason(reason);
    }

    @Override
    public String getProtocol() {
        return this.getResponseHeader().getProtocol();
    }

    @Override
    public String getProtocolVersion() {
        return this.getResponseHeader().getProtocolVersion();
    }

    public void setDate(long timeMillis) {
        this.setDate(DataConverter.toFormatedRFC822Date((long)timeMillis));
    }

    public void setExpireHeaders(int expireSec) {
        HttpUtils.setExpireHeaders(this.getResponseHeader(), expireSec);
    }

    public void setLastModifiedHeader(long timeMillis) {
        HttpUtils.setLastModifiedHeader(this.getResponseHeader(), timeMillis);
    }

    @Override
    public final void setProtocol(String protocol) {
        this.getResponseHeader().setProtocol(protocol);
    }

    @Override
    public final IHttpResponseHeader getResponseHeader() {
        return (IHttpResponseHeader)this.getPartHeader();
    }

    @Override
    public String toString() {
        if (this.isSimpleResponse) {
            try {
                return this.getNonBlockingBody().toString();
            }
            catch (IOException ioe) {
                return "[body can not be printed: " + ioe.toString() + "]";
            }
        }
        return super.toString();
    }
}

