/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractHttpMessage;
import org.xlightweb.BadMessageException;
import org.xlightweb.ContentType;
import org.xlightweb.FileDataSource;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.InMemoryBodyDataSource;
import org.xlightweb.MultivalueMap;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends AbstractHttpMessage
implements IHttpRequest {
    private static final Logger LOG = Logger.getLogger(HttpRequest.class.getName());

    public HttpRequest(IHttpRequestHeader requestHeader) {
        super(requestHeader);
        if (!HttpRequest.isBodylessRequestMethod(requestHeader.getMethod())) {
            requestHeader.setContentLength(0);
        }
    }

    public HttpRequest(IHttpRequestHeader requestHeader, NonBlockingBodyDataSource bodyDataSource) throws IOException {
        super(requestHeader);
        if (bodyDataSource == null || bodyDataSource.availableSilence() == -1) {
            if (!HttpRequest.isBodylessRequestMethod(requestHeader.getMethod())) {
                this.setContentLength(0);
            }
            this.removeHeader("Content-Type");
            this.removeHeader("Transfer-Encoding");
        } else {
            this.setBody(bodyDataSource);
        }
    }

    public HttpRequest(IHttpRequestHeader requestHeader, ByteBuffer[] bodyData, boolean compress) throws IOException {
        this(requestHeader);
        this.setBody(requestHeader, bodyData, compress);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, InputStream is) throws IOException {
        super(requestHeader);
        if (!HttpRequest.isBodylessRequestMethod(requestHeader.getMethod()) && (requestHeader.getMethod().equalsIgnoreCase("PUT") || requestHeader.getMethod().equalsIgnoreCase("POST"))) {
            if (is == null || is.available() == -1) {
                requestHeader.setContentLength(0);
            } else {
                requestHeader.removeHeader("Content-Length");
                requestHeader.setHeader("Transfer-Encoding", "chunked");
                InMemoryBodyDataSource dataSource = new InMemoryBodyDataSource(requestHeader);
                this.setBody(dataSource);
                if (requestHeader.getContentType() != null && requestHeader.getContentType().startsWith("application/x-www-form-urlencoded")) {
                    HttpRequest.forwardInputStream(dataSource, is);
                } else {
                    AbstractHttpConnection.IMultimodeExecutor executor = HttpUtils.newMultimodeExecutor();
                    executor.processMultithreaded(new ForwardTask(dataSource, is));
                }
            }
        }
    }

    private static final void forwardInputStream(NonBlockingBodyDataSource dataSource, InputStream is) throws IOException {
        int read;
        do {
            byte[] transferBuffer;
            if ((read = is.read(transferBuffer = new byte[4096])) == -1) continue;
            dataSource.append(ByteBuffer.wrap(transferBuffer, 0, read));
        } while (read != -1);
        dataSource.setComplete();
        is.close();
    }

    public HttpRequest(String method, String url, String contentType, ByteBuffer[] body, boolean compress) throws IOException {
        this((IHttpRequestHeader)new HttpRequestHeader(method, url, contentType), body, compress);
    }

    public HttpRequest(String method, String url, String contentType, byte[] body, boolean compress) throws IOException {
        this((IHttpRequestHeader)new HttpRequestHeader(method, url, contentType), new ByteBuffer[]{DataConverter.toByteBuffer((byte[])body)}, compress);
    }

    public HttpRequest(String method, String url, String contentType, String encoding, String body, boolean compress) throws IOException {
        this((IHttpRequestHeader)HttpRequest.newRequestHeader(method, url, contentType, encoding), body, compress);
    }

    public HttpRequest(String method, String url, String contentType, String body, boolean compress) throws IOException {
        this((IHttpRequestHeader)new HttpRequestHeader(method, url, contentType), body, compress);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, String body, boolean compress) throws IOException {
        this(requestHeader, HttpRequest.convert(requestHeader, body), compress);
    }

    private static ByteBuffer[] convert(IHttpRequestHeader requestHeader, String body) {
        if (requestHeader.getContentType() != null && HttpUtils.isTextMimeType(requestHeader.getContentType()) && HttpUtils.parseEncoding(requestHeader.getContentType()) == null) {
            requestHeader.setContentType(requestHeader.getContentType() + "; charset=utf-8");
        }
        return new ByteBuffer[]{DataConverter.toByteBuffer((String)body, (String)requestHeader.getCharacterEncoding())};
    }

    public HttpRequest(IHttpRequestHeader requestHeader, String body) throws IOException {
        this(requestHeader, body, false);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, ByteBuffer[] bodyData) throws IOException {
        this(requestHeader, bodyData, false);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, byte[] bodyData) throws IOException {
        this(requestHeader, new ByteBuffer[]{DataConverter.toByteBuffer((byte[])bodyData)}, false);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, List<ByteBuffer> bodyData) throws IOException {
        this(requestHeader, bodyData, false);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, List<ByteBuffer> bodyData, boolean compress) throws IOException {
        this(requestHeader, HttpRequest.toArray(bodyData), compress);
    }

    HttpRequest(IHttpRequestHeader requestHeader, File bodyData) throws IOException {
        this(requestHeader, (NonBlockingBodyDataSource)new FileDataSource((IHeader)requestHeader, HttpUtils.newMultimodeExecutor(), bodyData));
        this.setContentLength((int)bodyData.length());
    }

    public HttpRequest(String method, String url, String contentType, String body) throws IOException {
        this(method, url, contentType, body, false);
    }

    public HttpRequest(String method, String url, String contentType, String encoding, String body) throws IOException {
        this(method, url, contentType, encoding, body, false);
    }

    public HttpRequest(String method, String url, String contentType, byte[] body) throws IOException {
        this(method, url, contentType, body, false);
    }

    public HttpRequest(String method, String url, String contentType, ByteBuffer[] body) throws IOException {
        this(method, url, contentType, body, false);
    }

    public HttpRequest(String method, String url) {
        this(new HttpRequestHeader(method, url));
    }

    private static HttpRequestHeader newRequestHeader(String method, String url, String contentType, String encoding) {
        if (HttpUtils.parseEncoding(contentType) == null && HttpUtils.parseMediaType(contentType).startsWith("text/")) {
            contentType = contentType + "; charset=" + encoding;
        }
        return new HttpRequestHeader(method, url, contentType);
    }

    private static ByteBuffer[] toArray(List<ByteBuffer> buffers) {
        if (buffers == null) {
            return null;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    @Override
    public IHttpRequestHeader getRequestHeader() {
        return (IHttpRequestHeader)this.getPartHeader();
    }

    @Override
    public String getRequestHandlerPath() {
        return this.getRequestHeader().getRequestHandlerPath();
    }

    @Override
    public void setRequestHandlerPath(String requestHandlerPath) {
        this.getRequestHeader().setRequestHandlerPath(requestHandlerPath);
    }

    @Override
    public String getContextPath() {
        return this.getRequestHeader().getContextPath();
    }

    @Override
    public void setContextPath(String contextPath) {
        this.getRequestHeader().setContextPath(contextPath);
    }

    @Override
    public void setMethod(String method) {
        this.getRequestHeader().setMethod(method);
    }

    @Override
    public String getMethod() {
        return this.getRequestHeader().getMethod();
    }

    @Override
    public List<ContentType> getAccept() {
        return this.getRequestHeader().getAccept();
    }

    @Override
    public String getScheme() {
        return this.getRequestHeader().getScheme();
    }

    @Override
    public void setHost(String host) {
        this.getRequestHeader().setHost(host);
    }

    @Override
    public String getServerName() {
        return this.getRequestHeader().getServerName();
    }

    @Override
    public int getServerPort() {
        return this.getRequestHeader().getServerPort();
    }

    @Override
    public String getProtocol() {
        return this.getRequestHeader().getProtocol();
    }

    @Override
    public String getProtocolVersion() {
        return this.getRequestHeader().getProtocolVersion();
    }

    @Override
    public URL getRequestUrl() {
        return this.getRequestHeader().getRequestUrl();
    }

    @Override
    public void setRequestUrl(URL url) {
        this.getRequestHeader().setRequestUrl(url);
    }

    @Override
    public String getRemoteHost() {
        return this.getRequestHeader().getRemoteHost();
    }

    @Override
    public String getRemoteAddr() {
        return this.getRequestHeader().getRemoteAddr();
    }

    @Override
    public int getRemotePort() {
        return this.getRequestHeader().getRemotePort();
    }

    @Override
    public String getRequestURI() {
        return this.getRequestHeader().getRequestURI();
    }

    @Override
    public void setRequestURI(String requestUri) {
        this.getRequestHeader().setRequestURI(requestUri);
    }

    @Override
    public String getPathInfo() {
        return this.getRequestHeader().getPathInfo();
    }

    @Override
    public String getPathInfo(boolean removeSurroundingSlashs) {
        return this.getRequestHeader().getPathInfo(removeSurroundingSlashs);
    }

    @Override
    public String getHost() {
        return this.getRequestHeader().getHost();
    }

    @Override
    public String getUserAgent() {
        return this.getRequestHeader().getUserAgent();
    }

    @Override
    public String getKeepAlive() {
        return this.getRequestHeader().getKeepAlive();
    }

    @Override
    public void setKeepAlive(String keepAlive) {
        this.getRequestHeader().setKeepAlive(keepAlive);
    }

    @Override
    public String getUpgrade() {
        return this.getRequestHeader().getUpgrade();
    }

    @Override
    public void setUpgrade(String upgrade) {
        this.getRequestHeader().setUpgrade(upgrade);
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.getRequestHeader().setUserAgent(userAgent);
    }

    @Override
    public String getQueryString() {
        return this.getRequestHeader().getQueryString();
    }

    @Override
    public boolean isSecure() {
        return this.getRequestHeader().isSecure();
    }

    @Override
    public String getMatrixParameter(String name) {
        return this.getRequestHeader().getMatrixParameter(name);
    }

    @Override
    public Set<String> getMatrixParameterNameSet() {
        return this.getRequestHeader().getMatrixParameterNameSet();
    }

    @Override
    public String[] getMatrixParameterValues(String name) {
        return this.getRequestHeader().getMatrixParameterValues(name);
    }

    @Override
    public void setMatrixParameter(String parameterName, String parameterValue) {
        this.getRequestHeader().setMatrixParameter(parameterName, parameterValue);
    }

    @Override
    public void addMatrixParameter(String parameterName, String parameterValue) {
        this.getRequestHeader().addMatrixParameter(parameterName, parameterValue);
    }

    @Override
    public void removeMatrixParameter(String parameterName) {
        this.getRequestHeader().removeMatrixParameter(parameterName);
    }

    @Override
    public Enumeration getParameterNames() {
        return this.getRequestHeader().getParameterNames();
    }

    @Override
    public Set<String> getParameterNameSet() {
        return this.getRequestHeader().getParameterNameSet();
    }

    @Override
    public String getParameter(String name) {
        return this.getRequestHeader().getParameter(name);
    }

    @Override
    public String getParameter(String name, String defaultVal) {
        return this.getRequestHeader().getParameter(name, defaultVal);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getRequestHeader().getParameterValues(name);
    }

    @Override
    public String getRequiredStringParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredStringParameter(name);
    }

    @Override
    public Integer getIntParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getIntParameter(name);
    }

    @Override
    public int getRequiredIntParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredIntParameter(name);
    }

    @Override
    public int getIntParameter(String name, int defaultVal) {
        return this.getRequestHeader().getIntParameter(name, defaultVal);
    }

    @Override
    public Long getLongParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getLongParameter(name);
    }

    @Override
    public long getRequiredLongParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredLongParameter(name);
    }

    @Override
    public long getLongParameter(String name, long defaultVal) {
        return this.getRequestHeader().getLongParameter(name, defaultVal);
    }

    @Override
    public Double getDoubleParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getDoubleParameter(name);
    }

    @Override
    public double getRequiredDoubleParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredDoubleParameter(name);
    }

    @Override
    public double getDoubleParameter(String name, double defaultVal) {
        return this.getRequestHeader().getDoubleParameter(name, defaultVal);
    }

    @Override
    public Float getFloatParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getFloatParameter(name);
    }

    @Override
    public float getRequiredFloatParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredFloatParameter(name);
    }

    @Override
    public float getFloatParameter(String name, float defaultVal) {
        return this.getRequestHeader().getFloatParameter(name, defaultVal);
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        return this.getRequestHeader().getBooleanParameter(name);
    }

    @Override
    public boolean getRequiredBooleanParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredBooleanParameter(name);
    }

    @Override
    public boolean getBooleanParameter(String name, boolean defaultVal) {
        return this.getRequestHeader().getBooleanParameter(name, defaultVal);
    }

    @Override
    public void setParameter(String parameterName, String parameterValue) {
        try {
            if (this.getContentType() != null && this.getContentType().startsWith("application/x-www-form-urlencoded") && this.getNonBlockingBody().isComplete()) {
                MultivalueMap body = new MultivalueMap(this.getBlockingBody());
                body.removeParameter(parameterName);
                body.setParameter(parameterName, parameterValue);
                this.removeHeader("Content-Length");
                this.setBody(this.getMessageHeader(), new ByteBuffer[]{DataConverter.toByteBuffer((String)body.toString(), (String)this.getCharacterEncoding())}, false);
            } else {
                this.getRequestHeader().setParameter(parameterName, parameterValue);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void removeParameter(String parameterName) {
        try {
            if (this.getContentType() != null && this.getContentType().startsWith("application/x-www-form-urlencoded") && this.getNonBlockingBody().isComplete()) {
                MultivalueMap body = new MultivalueMap(this.getBlockingBody());
                body.removeParameter(parameterName);
                body.removeParameter(parameterName);
                this.removeHeader("Content-Length");
                this.setBody(this.getMessageHeader(), new ByteBuffer[]{DataConverter.toByteBuffer((String)body.toString(), (String)this.getCharacterEncoding())}, false);
            } else {
                this.getRequestHeader().removeParameter(parameterName);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void addParameter(String parameterName, String parameterValue) {
        try {
            if (this.getContentType() != null && this.getContentType().startsWith("application/x-www-form-urlencoded") && this.getNonBlockingBody().isComplete()) {
                MultivalueMap body = new MultivalueMap(this.getBlockingBody());
                body.addParameter(parameterName, parameterValue);
                this.removeHeader("Content-Length");
                this.setBody(this.getMessageHeader(), new ByteBuffer[]{DataConverter.toByteBuffer((String)body.toString(), (String)this.getCharacterEncoding())}, false);
            } else {
                this.getRequestHeader().addParameter(parameterName, parameterValue);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static boolean isBodylessRequestMethod(String method) {
        if (method.equals("GET")) {
            return true;
        }
        if (method.equals("POST")) {
            return false;
        }
        return method.equals("CONNECT") || method.equals("HEAD") || method.equals("TRACE") || method.equals("DELETE") || method.equals("OPTIONS");
    }

    private static final class ForwardTask
    implements Runnable {
        private final InputStream is;
        private final NonBlockingBodyDataSource dataSource;

        public ForwardTask(NonBlockingBodyDataSource dataSource, InputStream is) {
            this.is = is;
            this.dataSource = dataSource;
        }

        public void run() {
            try {
                HttpRequest.forwardInputStream(this.dataSource, this.is);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by reading input stream " + e.toString());
                }
                this.dataSource.destroy("error occured by reading input stream " + e.toString());
            }
        }
    }
}

