/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSource;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.ProtocolException;

final class FullMessageChunkedBodyDataSource
extends AbstractNetworkBodyDataSource {
    private static final char[] ISO_8859_1_ARRAY = HttpUtils.getISO_8859_1_Array();
    private static final int STATE_READ_LENGTH_FIELD = 0;
    private static final int STATE_READ_CONTENT = 1;
    private static final int STATE_READ_CONTENT_CRLF = 2;
    private static final int STATE_READ_TRAILER = 3;
    private static final int STATE_COMPLETE = 999;
    private int state = 0;
    private static final int HL_READING_FIRST_CHAR_OF_LINE = 100;
    private static final int HL_READING_REMAINING_CHARS_OF_NAME = 110;
    private static final int HL_WAITING_UNTIL_VALUE_STARTS = 120;
    private static final int HL_READING_THE_VALUE = 130;
    private int trailerState = 100;
    private final StringBuilder stringBuilder = new StringBuilder(8);
    private StringBuilder hlNameBuilder = new StringBuilder(26);
    private StringBuilder hlValueBuilder = new StringBuilder();
    private int hlPosLastCharNotSpaceOrHtab;
    private boolean hlIsPreviousCharLF = true;
    private int sizeCurrentChunk;
    private int remainingCurrentChunk;
    private ArrayList<Integer> receivedChunks = new ArrayList();

    public FullMessageChunkedBodyDataSource(AbstractHttpConnection httpConnection, HttpMessageHeader header) throws IOException {
        super(header, httpConnection);
        this.postCreate();
    }

    void doParse(ByteBuffer[] rawData) throws IOException {
        while (!HttpUtils.isEmpty(rawData)) {
            switch (this.state) {
                case 0: {
                    this.readLengthField(rawData);
                    break;
                }
                case 1: {
                    this.readContent(rawData);
                    break;
                }
                case 2: {
                    this.readContentCRLF(rawData);
                    break;
                }
                case 3: {
                    boolean isComplete = this.readTrailer(rawData);
                    if (!isComplete) break;
                    return;
                }
            }
        }
    }

    private void readLengthField(ByteBuffer[] rawData) throws IOException {
        for (ByteBuffer buffer : rawData) {
            if (buffer == null) continue;
            int remaining = buffer.remaining();
            block7: for (int i = 0; i < remaining; ++i) {
                byte b = buffer.get();
                switch (b) {
                    case 13: {
                        continue block7;
                    }
                    case 32: {
                        continue block7;
                    }
                    case 9: {
                        continue block7;
                    }
                    case 10: {
                        this.remainingCurrentChunk = this.sizeCurrentChunk = this.parseLengtField(this.stringBuilder.toString());
                        this.stringBuilder.setLength(0);
                        if (this.remainingCurrentChunk > 0) {
                            this.state = 1;
                            return;
                        }
                        this.state = 3;
                        return;
                    }
                    default: {
                        this.stringBuilder.append((char)b);
                    }
                }
            }
        }
    }

    private void readContent(ByteBuffer[] rawData) throws IOException {
        this.remainingCurrentChunk = this.readByteBufferByLength(rawData, this.remainingCurrentChunk);
        if (this.remainingCurrentChunk == 0) {
            this.receivedChunks.add(this.sizeCurrentChunk);
            this.sizeCurrentChunk = 0;
            this.state = 2;
        }
    }

    private void readContentCRLF(ByteBuffer[] rawData) throws IOException {
        for (ByteBuffer buffer : rawData) {
            if (buffer == null) continue;
            int remaining = buffer.remaining();
            block5: for (int i = 0; i < remaining; ++i) {
                byte b = buffer.get();
                switch (b) {
                    case 13: {
                        continue block5;
                    }
                    case 10: {
                        this.state = 0;
                        return;
                    }
                }
            }
        }
    }

    private boolean readTrailer(ByteBuffer[] rawData) throws IOException {
        for (ByteBuffer buffer : rawData) {
            if (buffer == null) continue;
            int remaining = buffer.remaining();
            block26: for (int i = 0; i < remaining; ++i) {
                byte b = buffer.get();
                switch (this.trailerState) {
                    case 100: {
                        switch (b) {
                            case 13: {
                                continue block26;
                            }
                            case 10: {
                                if (this.hlIsPreviousCharLF) {
                                    this.addLine();
                                    this.state = 999;
                                    this.setComplete();
                                    return true;
                                }
                                this.hlIsPreviousCharLF = true;
                                continue block26;
                            }
                            case 32: {
                                this.hlValueBuilder.append(" ");
                                this.state = 120;
                                continue block26;
                            }
                            case 9: {
                                this.hlValueBuilder.append(" ");
                                this.state = 120;
                                continue block26;
                            }
                        }
                        this.hlIsPreviousCharLF = false;
                        this.addLine();
                        this.hlNameBuilder.append((char)b);
                        this.state = 110;
                        continue block26;
                    }
                    case 110: {
                        switch (b) {
                            case 13: {
                                continue block26;
                            }
                            case 10: {
                                this.state = 100;
                                this.hlIsPreviousCharLF = true;
                                continue block26;
                            }
                            case 32: {
                                this.state = 120;
                                continue block26;
                            }
                            case 9: {
                                this.state = 120;
                                continue block26;
                            }
                            case 58: {
                                this.state = 120;
                                continue block26;
                            }
                        }
                        this.hlNameBuilder.append((char)b);
                        continue block26;
                    }
                    case 120: {
                        if (b == 32 || b == 9) continue block26;
                        this.hlValueBuilder.append(this.toISO_8859_1_Char(b));
                        this.hlPosLastCharNotSpaceOrHtab = this.hlValueBuilder.length();
                        this.state = 130;
                        continue block26;
                    }
                    case 130: {
                        switch (b) {
                            case 13: {
                                continue block26;
                            }
                            case 10: {
                                this.hlIsPreviousCharLF = true;
                                this.state = 100;
                                continue block26;
                            }
                            case 32: {
                                this.hlValueBuilder.append(this.toISO_8859_1_Char(b));
                                continue block26;
                            }
                            case 9: {
                                this.hlValueBuilder.append(this.toISO_8859_1_Char(b));
                                continue block26;
                            }
                        }
                        this.hlValueBuilder.append(this.toISO_8859_1_Char(b));
                        this.hlPosLastCharNotSpaceOrHtab = this.hlValueBuilder.length();
                    }
                }
            }
        }
        return false;
    }

    private char toISO_8859_1_Char(byte b) {
        int i = b;
        return ISO_8859_1_ARRAY[i &= 0xFF];
    }

    private void addLine() {
        if (this.hlNameBuilder.length() > 0 && this.hlValueBuilder.length() > 0) {
            this.hlValueBuilder.setLength(this.hlPosLastCharNotSpaceOrHtab);
            this.getHeader().addHeader(this.hlNameBuilder.toString(), this.hlValueBuilder.toString());
            this.hlNameBuilder.setLength(0);
            this.hlValueBuilder.setLength(0);
        }
    }

    private int parseLengtField(String lengthField) throws ProtocolException {
        try {
            return Integer.parseInt(lengthField, 16);
        }
        catch (NumberFormatException nfe) {
            if (lengthField.indexOf(";") != -1) {
                String length = lengthField.substring(0, lengthField.indexOf(";"));
                return Integer.parseInt(length, 16);
            }
            throw new ProtocolException("[" + this.getId() + "] http protocol error. length field expected. " + this.chunkInfo() + " Got '" + lengthField + "'", this.getHeader());
        }
    }

    void onClose() throws IOException {
        if (this.state != 999) {
            throw new ProtocolException("connection has been closed (by user?) while receiving body data. " + this.chunkInfo() + " (FullChunkedMessage)", this.getHeader());
        }
    }

    void performOnDisconnect() throws ProtocolException {
        if (this.state != 999) {
            throw new ProtocolException("connection has been closed (by peer?) while receiving body data. " + this.chunkInfo() + " (FullChunkedMessage)", this.getHeader());
        }
    }

    private String chunkInfo() {
        try {
            StringBuilder sb = new StringBuilder("reveiced complete chunksize: [");
            for (Integer size : this.receivedChunks) {
                sb.append(size + ", ");
            }
            sb.append("] ");
            if (this.state == 1) {
                sb.append(" state=reading chunk: current chunksize=" + this.sizeCurrentChunk + " already recevied=" + (this.sizeCurrentChunk - this.remainingCurrentChunk));
            } else if (this.state == 0) {
                sb.append(" state=readLengthField");
            } else if (this.state == 3) {
                sb.append(" state=readingTrailer");
            } else if (this.state == 2) {
                sb.append(" state=readingContentCRLF");
            } else {
                sb.append(" state=complete (?)");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "no info available";
        }
    }
}

