/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSink;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.IHttpMessageHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IWriteCompletionHandler;

final class FullMessageChunkedBodyDataSink
extends AbstractNetworkBodyDataSink {
    private static final Logger LOG = Logger.getLogger(FullMessageChunkedBodyDataSink.class.getName());
    private static final byte[] DELIMITER = new byte[]{13, 10};
    private boolean isHeaderWritten = false;
    private int writtenData;
    private final ArrayList<Integer> writtenChunks = new ArrayList();

    public FullMessageChunkedBodyDataSink(AbstractHttpConnection httpConnection, IHttpMessageHeader header) throws IOException {
        super(header, httpConnection);
    }

    int onWriteNetworkData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        try {
            return this.writeChunk(dataToWrite, completionHandler);
        }
        catch (IOException ioe) {
            if (this.isIgnoreWriteError()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing chunked data sink. Ignoring error (ignoreWriteError=true) " + DataConverter.toString((Throwable)ioe));
                }
                if (completionHandler != null) {
                    completionHandler.onWritten(dataToWrite.length);
                }
            } else if (this.getConnection() != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing chunked data sink. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
            return 0;
        }
    }

    private int writeChunk(ByteBuffer[] bodyData, IWriteCompletionHandler completionHandler) throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            if (!this.isHeaderWritten) {
                this.isHeaderWritten = true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "]  sending header ");
                }
                this.written += con.write(this.getHeader().toString() + "\r\n");
                con.incCountMessageSent();
            }
            int length = 0;
            if (bodyData != null) {
                for (ByteBuffer buffer : bodyData) {
                    length += buffer.remaining();
                }
            }
            if (length > 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] writing chunk (size=" + length + ")");
                }
                this.written += con.write(Integer.toHexString(length) + "\r\n");
                this.written = (int)((long)this.written + con.write(bodyData));
                this.written += con.write(DELIMITER, completionHandler);
                this.writtenData += length;
                this.writtenChunks.add(length);
            } else if (completionHandler != null) {
                completionHandler.onWritten(0);
            }
            if (this.written > 0) {
                con.flush();
            }
            return length;
        }
        return 0;
    }

    void performClose() throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con == null) {
            return;
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] closing chunked body by writing termination chunk (body size=" + this.writtenData + ")");
            }
            if (!this.isHeaderWritten) {
                this.isHeaderWritten = true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "]  sending header ");
                }
                if (this.written == 0) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("body is empty. switch from chunkedbody to full message body (remove Transfer-Encoding and add Content-Length re-write header with content-length 0)");
                    }
                    this.getHeader().removeHeader("Transfer-Encoding");
                    ((HttpMessageHeader)this.getHeader()).setContentLength(0);
                    con.write(this.getHeader().toString() + "\r\n");
                    con.incCountMessageSent();
                    con.flush();
                    return;
                }
                con.write(this.getHeader().toString() + "\r\n");
                con.incCountMessageSent();
            }
            con.write("0\r\n\r\n");
            con.flush();
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] error occured by closing chunked data sink. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
            }
            con.destroy();
            throw ioe;
        }
    }

    void performDestroy() throws IOException {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int chunkSize : this.writtenChunks) {
            sb.append(chunkSize + ", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        return super.toString() + " (written=" + this.writtenData + " [" + sb.toString() + "])";
    }
}

