/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyForwarder;
import org.xlightweb.HttpCache;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpCache;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.InvokeOn;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.Supports100Continue;
import org.xsocket.ILifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Supports100Continue
public final class CacheHandler
implements IHttpRequestHandler,
ILifeCycle,
IUnsynchronized {
    private static final Logger LOG = Logger.getLogger(CacheHandler.class.getName());
    static final String XHEADER_NAME = "X-Cache";
    static final String SKIP_CACHE_HANDLING = "org.xlighhtweb.client.cachehandler.skipcachehandling";
    static final String CACHE_HIT = "org.xlighhtweb.client.cachehandler.chachehit";
    private final IHttpCache cache;
    private final HitStatistics statistics = new HitStatistics();
    private int countCacheHit = 0;
    private int countCacheMiss = 0;
    private long countCacheableResponse = 0L;
    private long countNonCacheableResponse = 0L;

    public CacheHandler(int maxSizeByteKB) {
        this.cache = new HttpCache();
        this.cache.setMaxSizeKB(maxSizeByteKB);
    }

    public void onInit() {
    }

    public void onDestroy() throws IOException {
        this.cache.close();
    }

    public void setSharedCache(boolean isSharedCache) {
        this.cache.setSharedCache(isSharedCache);
    }

    public boolean isSharedCache() {
        return this.cache.isSharedCache();
    }

    public void setMaxCacheSizeKB(int sizeByteKB) {
        this.cache.setMaxSizeKB(sizeByteKB);
    }

    public int getMaxCacheSizeKB() {
        return this.cache.getMaxSizeKB();
    }

    public int getCurrentCacheSizeBytes() {
        return this.cache.getCurrentSize();
    }

    public int getCountCacheHit() {
        return this.countCacheHit;
    }

    public double getCurrentHitRatio() {
        return this.statistics.getHitRate();
    }

    public int getCountCacheMiss() {
        return this.countCacheMiss;
    }

    long getCountCacheableResponse() {
        return this.countCacheableResponse;
    }

    long getNonCountCacheableResponse() {
        return this.countNonCacheableResponse;
    }

    public List<String> getCacheInfo() {
        ArrayList<String> result = new ArrayList<String>();
        for (IHttpCache.ICacheEntry entry : this.cache.getEntries()) {
            result.add(entry.toString());
        }
        return result;
    }

    @Override
    public void onRequest(final IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (request.getAttribute(SKIP_CACHE_HANDLING) != null && request.getAttribute(SKIP_CACHE_HANDLING).equals("true")) {
            exchange.forward(request);
            return;
        }
        if (!HttpCache.isCacheable(request, this.isSharedCache())) {
            exchange.forward(request);
            return;
        }
        Date minFresh = new Date();
        Date maxOld = null;
        boolean isOnlyIfCached = false;
        String cacheControl = request.getHeader("Cache-Control");
        if (cacheControl != null) {
            for (String directive : cacheControl.split(",")) {
                directive = directive.trim();
                String directiveLower = directive.toLowerCase();
                if (directive.equalsIgnoreCase("no-cache") || directive.equalsIgnoreCase("no-store")) {
                    exchange.forward(request);
                    return;
                }
                if (directiveLower.startsWith("min-fresh=")) {
                    String minRefresh = directive.substring("min-fresh=".length(), directive.length()).trim();
                    minFresh = new Date(System.currentTimeMillis() + HttpUtils.parseLong(minRefresh, 0L));
                }
                if (directiveLower.startsWith("max-stale")) {
                    if (directive.length() > "max-stale=".length()) {
                        String maxStale = directive.substring("max-stale=".length(), directive.length()).trim();
                        minFresh = new Date(System.currentTimeMillis() - 1000L * HttpUtils.parseLong(maxStale, 31536000L));
                    } else {
                        minFresh = new Date(System.currentTimeMillis() - 31536000000L);
                    }
                }
                if (directiveLower.startsWith("max-age=")) {
                    String maxAge = directive.substring("max-age=".length(), directive.length()).trim();
                    maxOld = new Date(System.currentTimeMillis() - 1000L * HttpUtils.parseLong(maxAge, 0L));
                }
                if (!directive.equalsIgnoreCase("only-if-cached")) continue;
                isOnlyIfCached = true;
            }
        }
        try {
            IHttpCache.ICacheEntry ce = this.cache.get(request, minFresh);
            if (ce != null && !ce.isAfter(maxOld)) {
                if (ce.mustRevalidate(minFresh)) {
                    if (isOnlyIfCached) {
                        ++this.countCacheMiss;
                        this.statistics.addMiss();
                        exchange.sendError(504);
                    } else {
                        HttpCache.IValidationHandler validationHdl = new HttpCache.IValidationHandler(){

                            public void onRevalidated(boolean isNotModified, HttpCache.AbstractCacheEntry ce) {
                                if (isNotModified) {
                                    try {
                                        CacheHandler.this.countCacheHit++;
                                        CacheHandler.this.statistics.addHit();
                                        IHttpResponse resp = ce.newResponse();
                                        resp.setHeader(CacheHandler.XHEADER_NAME, "HIT - revalidated (xLightweb)");
                                        resp.setAttribute(CacheHandler.CACHE_HIT, "HIT (revalidated)");
                                        exchange.send(resp);
                                    }
                                    catch (IOException ioe) {
                                        exchange.sendError(ioe);
                                    }
                                } else {
                                    try {
                                        CacheHandler.this.countCacheMiss++;
                                        CacheHandler.this.statistics.addMiss();
                                        IHttpResponse resp = ce.newResponse();
                                        exchange.send(resp);
                                    }
                                    catch (IOException ioe) {
                                        exchange.sendError(ioe);
                                    }
                                }
                            }

                            public void onException(IOException ioe) {
                                exchange.sendError(ioe);
                            }
                        };
                        ce.revalidate(exchange, validationHdl);
                    }
                } else {
                    ++this.countCacheHit;
                    this.statistics.addHit();
                    IHttpResponse resp = ce.newResponse();
                    resp.setHeader(XHEADER_NAME, "HIT  (xLightweb)");
                    resp.setAttribute(CACHE_HIT, "HIT");
                    exchange.send(resp);
                }
            } else {
                ++this.countCacheMiss;
                this.statistics.addMiss();
                if (isOnlyIfCached) {
                    exchange.sendError(504);
                } else {
                    this.forwardForCache(exchange);
                }
            }
        }
        catch (IOException ioe) {
            exchange.sendError(ioe);
        }
    }

    private void forwardForCache(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        IHttpRequestHeader headerCopy = request.getRequestHeader().copy();
        ForwarderResponseHandler forwardResponseHandler = new ForwarderResponseHandler(exchange, headerCopy);
        exchange.forward(exchange.getRequest(), (IHttpResponseHandler)forwardResponseHandler);
    }

    private static final class HitStatistics {
        private static final int WINDOWS_SIZE = 500;
        private static final int MAX_POINTER_VALUE = 498;
        private final Boolean[] measures = new Boolean[500];
        private int pointer = 0;

        private HitStatistics() {
        }

        void addHit() {
            try {
                this.measures[this.pointer] = true;
                this.incPointer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void addMiss() {
            try {
                this.measures[this.pointer] = false;
                this.incPointer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void incPointer() {
            if (this.pointer < 498) {
                ++this.pointer;
            }
        }

        double getHitRate() {
            int hits = 0;
            int misses = 0;
            for (int i = 0; i < this.measures.length; ++i) {
                Boolean b = this.measures[i];
                if (b == null) continue;
                if (b.booleanValue()) {
                    ++hits;
                    continue;
                }
                ++misses;
            }
            return this.ratio(hits, misses);
        }

        private double ratio(int hits, int misses) {
            if (misses == 0) {
                return 100.0;
            }
            if (hits == 0) {
                return 0.0;
            }
            return (double)hits / (double)misses;
        }
    }

    private final class ForwarderResponseHandler
    implements IHttpResponseHandler,
    IUnsynchronized {
        private final IHttpExchange exchange;
        private final IHttpRequest request;
        private final long startTime;

        public ForwarderResponseHandler(IHttpExchange exchange, IHttpRequestHeader headerCopy) {
            assert (HttpCache.isCacheable(exchange.getRequest(), CacheHandler.this.isSharedCache()));
            this.exchange = exchange;
            this.request = new HttpRequest(headerCopy);
            this.startTime = System.currentTimeMillis();
        }

        @InvokeOn(value=0)
        public void onResponse(IHttpResponse response) throws IOException {
            if (HttpCache.isCacheable(response, CacheHandler.this.isSharedCache())) {
                final IHttpResponseHeader responseHeaderCopy = response.getResponseHeader().copy();
                responseHeaderCopy.removeHopByHopHeaders();
                responseHeaderCopy.removeHeader("Content-Length");
                responseHeaderCopy.removeHeader("Transfer-Encoding");
                if (response.hasBody()) {
                    NonBlockingBodyDataSource dataSource = response.getNonBlockingBody();
                    BodyDataSink dataSink = this.exchange.send(response.getResponseHeader());
                    BodyForwarder bodyForwarder = new BodyForwarder(response.getMessageHeader(), dataSource, dataSink, null){
                        private final List<ByteBuffer> responseBodyCopy;
                        {
                            super(x0, x1, x2, x3);
                            this.responseBodyCopy = new ArrayList<ByteBuffer>();
                        }

                        public void onData(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) throws BufferUnderflowException, IOException {
                            int available = bodyDataSource.available();
                            if (available > 0) {
                                ByteBuffer[] data;
                                for (ByteBuffer buf : data = bodyDataSource.readByteBufferByLength(bodyDataSource.available())) {
                                    this.responseBodyCopy.add(buf.duplicate());
                                }
                                bodyDataSink.write(data);
                            }
                        }

                        public void onComplete() {
                            block2: {
                                try {
                                    HttpResponse responseCopy = new HttpResponse(responseHeaderCopy, this.responseBodyCopy);
                                    ForwarderResponseHandler.this.addToCache(responseCopy);
                                }
                                catch (IOException ioe) {
                                    if (!LOG.isLoggable(Level.FINE)) break block2;
                                    LOG.fine("error occured by creating/registering cachedResponse " + ioe.toString());
                                }
                            }
                        }
                    };
                    dataSource.setDataHandler(bodyForwarder);
                } else {
                    HttpResponse responseCopy = new HttpResponse(responseHeaderCopy);
                    this.addToCache(responseCopy);
                    this.exchange.send(response);
                }
            } else {
                CacheHandler.this.countNonCacheableResponse++;
                this.exchange.send(response);
                return;
            }
        }

        private void addToCache(IHttpResponse response) {
            block3: {
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("adding interaction " + this.request.getRequestUrl().toString() + " - " + response.getStatus() + " to cache");
                    }
                    CacheHandler.this.countCacheableResponse++;
                    CacheHandler.this.cache.register(this.request, System.currentTimeMillis() - this.startTime, response);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by adding interaction to cache " + ioe.toString());
                }
            }
        }

        public void onException(IOException ioe) throws IOException {
            this.exchange.sendError(ioe);
        }
    }
}

