/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractListeners;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyDataSource;
import org.xlightweb.DetailedClosedChannelException;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHeader;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

abstract class BodyDataSinkImplBase
extends BodyDataSink {
    private static final Logger LOG = Logger.getLogger(BodyDataSinkImplBase.class.getName());
    private static final String SUPPRESS_SYNC_FLUSH_WARNING_KEY = "org.xlightweb.bodydatasink.suppressSyncFlushWarning";
    private static final boolean IS_SUPPRESS_SYNC_FLUSH_WARNING = Boolean.parseBoolean(System.getProperty("org.xlightweb.bodydatasink.suppressSyncFlushWarning", "false"));
    private static final int TRANSFER_CHUNK_SIZE = 65536;
    private static final long DEFAULT_SEND_TIMEOUT_MILLIS = Long.valueOf(System.getProperty("org.xsocket.connection.sendFlushTimeoutMillis", Long.toString(60000L)));
    private long sendTimeoutMillis = DEFAULT_SEND_TIMEOUT_MILLIS;
    private final WriteQueue writeQueue = new WriteQueue();
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicBoolean isIgnoreWriteError = new AtomicBoolean(false);
    private final AbstractListeners.CloseListeners closeListeners = new AbstractListeners.CloseListeners();
    private final AbstractListeners.DestroyListeners destroyListeners = new AbstractListeners.DestroyListeners();
    private String encoding = null;
    private boolean isAutoflush = true;
    private IConnection.FlushMode flushMode = IConnection.FlushMode.SYNC;
    private boolean isFlushed = false;
    private Object attachment = null;
    private List<WriteCompletionHandlerCaller> writeCompletionHandlerCallers = new ArrayList<WriteCompletionHandlerCaller>();
    private final AbstractHttpConnection.IMultimodeExecutor executor;
    int written = 0;
    private final AtomicInteger numIgnoreWriteErrors = new AtomicInteger(0);

    BodyDataSinkImplBase(IHeader header, AbstractHttpConnection.IMultimodeExecutor executor) throws IOException {
        super(header);
        this.executor = executor;
        this.setEncoding(header.getCharacterEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addCloseListener(IBodyCloseListener listener) {
        AbstractListeners.CloseListeners closeListeners = this.closeListeners;
        synchronized (closeListeners) {
            this.closeListeners.addListener(listener, !this.isOpen(), this.getExecutor(), HttpUtils.getListenerExecutionMode(listener, "onClose"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean removeCloseListener(IBodyCloseListener closeListener) {
        AbstractListeners.CloseListeners closeListeners = this.closeListeners;
        synchronized (closeListeners) {
            return this.closeListeners.removeListener(closeListener);
        }
    }

    protected final void callCloseListener() {
        this.closeListeners.callAndRemoveListeners(this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDestroyListener(IBodyDestroyListener listener) {
        AbstractListeners.DestroyListeners destroyListeners = this.destroyListeners;
        synchronized (destroyListeners) {
            this.destroyListeners.addListener(listener, this.isDestroyed.get(), this.getExecutor(), HttpUtils.getListenerExecutionMode(listener, "onDestroyed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean removeDestroyListener(IBodyDestroyListener destroyListener) {
        AbstractListeners.DestroyListeners destroyListeners = this.destroyListeners;
        synchronized (destroyListeners) {
            return this.destroyListeners.removeListener(destroyListener);
        }
    }

    protected final void callDestroyListener() {
        this.destroyListeners.callAndRemoveListeners(this.getExecutor());
    }

    final AbstractHttpConnection.IMultimodeExecutor getExecutor() {
        return this.executor;
    }

    public final void setSendTimeoutMillis(long sendTimeoutMillis) {
        this.sendTimeoutMillis = sendTimeoutMillis;
    }

    final void setIgnoreWriteError() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] setIgnoreWriteError=true");
        }
        this.isIgnoreWriteError.set(true);
    }

    final boolean isIgnoreWriteError() {
        return this.isIgnoreWriteError.get();
    }

    int getSizeWritten() {
        return this.written;
    }

    int getNumIgnoreWriteErrors() {
        return this.numIgnoreWriteErrors.get();
    }

    public final void flush() throws IOException {
        this.isFlushed = true;
        if (!(this.isOpen.get() || this.isIgnoreWriteError.get() || this.writeQueue.isEmpty())) {
            throw new ClosedChannelException();
        }
        this.internalFlush();
    }

    final boolean isFlushed() {
        return this.isFlushed;
    }

    public final void internalFlush() throws IOException {
        this.removeWriteMark();
        ByteBuffer[] dataToWrite = this.writeQueue.drain();
        if (this.getFlushmode() == IConnection.FlushMode.ASYNC) {
            if (this.writeCompletionHandlerCallers.isEmpty()) {
                this.written += this.writeData(dataToWrite, null);
            } else {
                WriteCompletionHandlerAdapter completionHandlerAdapter = new WriteCompletionHandlerAdapter(this.writeCompletionHandlerCallers);
                this.writeCompletionHandlerCallers = new ArrayList<WriteCompletionHandlerCaller>();
                this.written += this.writeData(dataToWrite, completionHandlerAdapter);
            }
        } else {
            if (!IS_SUPPRESS_SYNC_FLUSH_WARNING && ConnectionUtils.isDispatcherThread()) {
                String msg = "synchronized flushing in NonThreaded mode could cause dead locks (hint: set flush mode to ASYNC). This message can be suppressed by setting system property org.xlightweb.bodydatasink.suppressSyncFlushWarning";
                LOG.warning("[" + this.getId() + "] " + msg);
            }
            if (this.writeCompletionHandlerCallers.isEmpty()) {
                SyncCaller caller = new SyncCaller(dataToWrite, null);
                caller.call();
            } else {
                WriteCompletionHandlerAdapter completionHandlerAdapter = new WriteCompletionHandlerAdapter(this.writeCompletionHandlerCallers);
                this.writeCompletionHandlerCallers = new ArrayList<WriteCompletionHandlerCaller>();
                SyncCaller caller = new SyncCaller(dataToWrite, completionHandlerAdapter);
                caller.call();
            }
        }
    }

    void doClose() throws IOException {
        if (this.isOpen.getAndSet(false)) {
            try {
                if (!this.writeQueue.isEmpty()) {
                    this.internalFlush();
                }
                this.onClose();
            }
            catch (IOException ioe) {
                if (!this.isIgnoreWriteError.get()) {
                    throw ioe;
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing BodyDataSink " + e.toString());
                }
                throw new IOException(e.toString());
            }
            finally {
                this.callCloseListener();
            }
        }
    }

    public final void closeQuitly() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] Error occured by closing connection " + ioe.toString());
            }
        }
    }

    abstract void onClose() throws IOException;

    private void ensureStreamIsOpenAndWritable() throws ClosedChannelException {
        if (!this.isOpen.get() && !this.isIgnoreWriteError.get()) {
            throw new DetailedClosedChannelException("data sink " + this.getId() + " is closed");
        }
    }

    final int writeData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        try {
            return this.onWriteData(dataToWrite, completionHandler);
        }
        catch (IOException ioe) {
            if (this.isIgnoreWriteError.get()) {
                int size = HttpUtils.computeRemaining(dataToWrite);
                this.numIgnoreWriteErrors.addAndGet(size);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("DataSink is deactivated (e.g. complete response message is received). writing " + size + " bytes to \"dev0\"");
                }
                if (completionHandler != null) {
                    completionHandler.onWritten(size);
                }
                return size;
            }
            throw ioe;
        }
    }

    abstract int onWriteData(ByteBuffer[] var1, IWriteCompletionHandler var2) throws IOException;

    public final void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        if (!HttpUtils.isEmpty(buffers)) {
            this.ensureStreamIsOpenAndWritable();
        }
        if (writeCompletionHandler == null) {
            this.write(buffers);
            return;
        }
        buffers = this.preWrite(buffers);
        this.writeCompletionHandlerCallers.add(new WriteCompletionHandlerCaller(writeCompletionHandler, buffers));
        this.write(buffers);
    }

    public final int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
        int written;
        block5: {
            if (!HttpUtils.isEmpty(buffer)) {
                this.ensureStreamIsOpenAndWritable();
            }
            written = buffer.remaining();
            try {
                ByteBuffer internalBuffer = this.preWrite(buffer);
                written = this.writeQueue.append(internalBuffer);
                if (this.isAutoflush) {
                    this.flush();
                }
                if (buffer != internalBuffer) {
                    buffer.position(buffer.position() + written);
                }
            }
            catch (IOException ioe) {
                if (this.isIgnoreWriteError.get()) break block5;
                throw ioe;
            }
        }
        return written;
    }

    public final long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
        long written;
        block4: {
            if (!HttpUtils.isEmpty(buffers)) {
                this.ensureStreamIsOpenAndWritable();
            }
            written = HttpUtils.computeRemaining(buffers);
            try {
                buffers = this.preWrite(buffers);
                written = this.writeQueue.append(buffers);
                if (this.isAutoflush) {
                    this.flush();
                }
            }
            catch (IOException ioe) {
                if (this.isIgnoreWriteError.get()) break block4;
                throw ioe;
            }
        }
        return written;
    }

    ByteBuffer[] preWrite(ByteBuffer[] buffers) throws IOException {
        return buffers;
    }

    ByteBuffer preWrite(ByteBuffer buffer) throws IOException {
        return buffer;
    }

    public final long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
        long transfered = 0L;
        int read = 0;
        do {
            ByteBuffer transferBuffer;
            if ((read = source.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
            if (transferBuffer.remaining() == 0) {
                transferBuffer.flip();
                this.write(transferBuffer);
            } else {
                transferBuffer.flip();
                this.write(transferBuffer.slice());
            }
            transfered += (long)read;
        } while (read > 0);
        return transfered;
    }

    public final long transferFrom(FileChannel fileChannel) throws IOException, BufferOverflowException {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            long written;
            long size;
            long remaining = size = fileChannel.size();
            long offset = 0L;
            long length = 0L;
            do {
                length = remaining > 65536L ? 65536L : remaining;
                MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
                written = this.write(buffer);
                offset += written;
            } while ((remaining -= written) > 0L);
            return size;
        }
        return this.transferFrom((ReadableByteChannel)fileChannel);
    }

    public final long transferFrom(NonBlockingBodyDataSource source) throws IOException {
        return source.transferTo(this);
    }

    public final long transferFrom(NonBlockingBodyDataSource source, int length) throws IOException {
        return source.transferTo(this, length);
    }

    public final long transferFrom(BodyDataSource source) throws IOException {
        return source.transferTo(this);
    }

    public final long transferFrom(BodyDataSource source, int length) throws IOException {
        return source.transferTo(this);
    }

    public final void setEncoding(String defaultEncoding) {
        this.encoding = defaultEncoding;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public final IConnection.FlushMode getFlushmode() {
        return this.flushMode;
    }

    public final void setAutoflush(boolean autoflush) {
        this.isAutoflush = autoflush;
    }

    public final boolean isAutoflush() {
        return this.isAutoflush;
    }

    public final void markWritePosition() {
        this.writeQueue.markWritePosition();
    }

    public final boolean resetToWriteMark() {
        return this.writeQueue.resetToWriteMark();
    }

    public final void removeWriteMark() {
        this.writeQueue.removeWriteMark();
    }

    public final void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnderlyingHttpConnectionClosed() {
        if (this.isOpen.get()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] underlying connection is closed. closing data source");
            }
            AbstractListeners.CloseListeners closeListeners = this.closeListeners;
            synchronized (closeListeners) {
                this.isOpen.set(false);
            }
            this.callCloseListener();
        }
    }

    public String getId() {
        return this.getClass().getSimpleName() + "#" + this.hashCode();
    }

    public void destroy() {
        this.destroy("user initiated");
    }

    final void destroy(boolean isIgnoreError) {
        this.destroy("user initiated", isIgnoreError);
    }

    final void destroy(String reason) {
        this.destroy(reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroy(String reason, boolean isIgnoreError) {
        if (isIgnoreError) {
            this.setIgnoreWriteError();
        }
        this.isOpen.set(false);
        if (!this.isDestroyed.getAndSet(true)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] destroying data sink");
            }
            AbstractListeners.DestroyListeners destroyListeners = this.destroyListeners;
            synchronized (destroyListeners) {
                this.onDestroy(reason);
            }
            this.callDestroyListener();
        }
    }

    abstract void onDestroy(String var1);

    public String toString() {
        return this.writeQueue.toString();
    }

    private final class WriteCompletionHandlerCaller
    implements IUnsynchronized {
        private final IWriteCompletionHandler writeCompletionHandler;
        private final HttpUtils.CompletionHandlerInfo writeCompletionHandlerInfo;
        private final int size;

        public WriteCompletionHandlerCaller(IWriteCompletionHandler writeCompletionHandler, ByteBuffer[] buffers) {
            this.writeCompletionHandler = writeCompletionHandler;
            this.writeCompletionHandlerInfo = HttpUtils.getCompletionHandlerInfo(writeCompletionHandler);
            this.size = HttpUtils.computeRemaining(buffers);
        }

        void onWritten() {
            if (this.writeCompletionHandlerInfo.isUnsynchronized()) {
                this.performCompletionHandler();
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHandlerCaller.this.performCompletionHandler();
                    }
                };
                if (this.writeCompletionHandlerInfo.isOnWrittenMultithreaded()) {
                    BodyDataSinkImplBase.this.executor.processMultithreaded(task);
                } else {
                    BodyDataSinkImplBase.this.executor.processNonthreaded(task);
                }
            }
        }

        private void performCompletionHandler() {
            try {
                this.writeCompletionHandler.onWritten(this.size);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + BodyDataSinkImplBase.this.getId() + "] error occured by perforing onWritten of " + this.writeCompletionHandler + " " + ioe.toString());
                }
                BodyDataSinkImplBase.this.destroy();
            }
        }

        void onException(final IOException ioe) {
            if (this.writeCompletionHandlerInfo.isUnsynchronized()) {
                this.writeCompletionHandler.onException(ioe);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHandlerCaller.this.writeCompletionHandler.onException(ioe);
                    }
                };
                if (this.writeCompletionHandlerInfo.isOnExceptionMutlithreaded()) {
                    BodyDataSinkImplBase.this.executor.processMultithreaded(task);
                } else {
                    BodyDataSinkImplBase.this.executor.processNonthreaded(task);
                }
            }
        }
    }

    private static final class RewriteableBuffer
    implements Cloneable {
        private ArrayList<ByteBuffer> bufs = new ArrayList();
        private int writePosition = 0;

        private RewriteableBuffer() {
        }

        public void append(ByteBuffer buffer) {
            if (buffer.remaining() < 1) {
                return;
            }
            if (this.writePosition == this.bufs.size()) {
                this.bufs.add(buffer);
                ++this.writePosition;
            } else {
                ByteBuffer currentBuffer = this.bufs.remove(this.writePosition);
                if (currentBuffer.remaining() == buffer.remaining()) {
                    this.bufs.add(this.writePosition, buffer);
                    ++this.writePosition;
                } else if (currentBuffer.remaining() > buffer.remaining()) {
                    currentBuffer.position(currentBuffer.position() + buffer.remaining());
                    this.bufs.add(this.writePosition, currentBuffer);
                    this.bufs.add(this.writePosition, buffer);
                    ++this.writePosition;
                } else {
                    this.bufs.add(this.writePosition, buffer);
                    ++this.writePosition;
                    int bytesToRemove = buffer.remaining() - currentBuffer.remaining();
                    while (bytesToRemove > 0) {
                        if (this.writePosition < this.bufs.size()) {
                            ByteBuffer buf = this.bufs.remove(this.writePosition);
                            if (buf.remaining() > bytesToRemove) {
                                buf.position(buf.position() + bytesToRemove);
                                this.bufs.add(this.writePosition, buf);
                                continue;
                            }
                            bytesToRemove -= buf.remaining();
                            continue;
                        }
                        bytesToRemove = 0;
                    }
                }
            }
        }

        public void resetWritePosition() {
            this.writePosition = 0;
        }

        public ByteBuffer[] drain() {
            ByteBuffer[] result = this.bufs.toArray(new ByteBuffer[this.bufs.size()]);
            this.bufs.clear();
            this.writePosition = 0;
            return result;
        }

        protected Object clone() throws CloneNotSupportedException {
            RewriteableBuffer copy = (RewriteableBuffer)super.clone();
            copy.bufs = new ArrayList();
            for (ByteBuffer buffer : this.bufs) {
                copy.bufs.add(buffer.duplicate());
            }
            return copy;
        }
    }

    private static final class Queue {
        private ByteBuffer[] buffers;

        private Queue() {
        }

        public synchronized boolean isEmpty() {
            return this.empty();
        }

        private boolean empty() {
            return this.buffers == null;
        }

        public synchronized void append(ByteBuffer data) {
            if (this.buffers == null) {
                this.buffers = new ByteBuffer[1];
                this.buffers[0] = data;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + 1];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                newBuffers[this.buffers.length] = data;
                this.buffers = newBuffers;
            }
        }

        public synchronized void append(ByteBuffer[] bufs) {
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + bufs.length];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                System.arraycopy(bufs, 0, newBuffers, this.buffers.length, bufs.length);
                this.buffers = newBuffers;
            }
        }

        public synchronized ByteBuffer[] drain() {
            ByteBuffer[] result = this.buffers;
            this.buffers = null;
            return result;
        }

        public synchronized ByteBuffer[] copyContent() {
            return ConnectionUtils.copy((ByteBuffer[])this.buffers);
        }

        public String toString() {
            return this.asString("US-ASCII");
        }

        public synchronized String asString(String encoding) {
            StringBuilder sb = new StringBuilder();
            if (this.buffers != null) {
                ByteBuffer[] copy = new ByteBuffer[this.buffers.length];
                try {
                    for (int i = 0; i < copy.length; ++i) {
                        if (this.buffers[i] == null) continue;
                        copy[i] = this.buffers[i].duplicate();
                    }
                    sb.append(DataConverter.toString((ByteBuffer[])copy, (String)encoding, (int)Integer.MAX_VALUE));
                }
                catch (UnsupportedEncodingException use) {
                    sb.append(DataConverter.toHexString((ByteBuffer[])copy, (int)Integer.MAX_VALUE));
                }
            }
            return sb.toString();
        }
    }

    private final class WriteQueue
    implements Cloneable {
        private final Queue queue = new Queue();
        private RewriteableBuffer writeMarkBuffer = null;
        private boolean isWriteMarked = false;

        private WriteQueue() {
        }

        public boolean isEmpty() {
            return this.queue.isEmpty() && this.writeMarkBuffer == null;
        }

        public ByteBuffer[] drain() {
            return this.queue.drain();
        }

        public int append(ByteBuffer data) {
            if (data == null) {
                return 0;
            }
            int size = data.remaining();
            if (this.isWriteMarked) {
                this.writeMarkBuffer.append(data);
            } else {
                this.queue.append(data);
            }
            return size;
        }

        public long append(ByteBuffer[] bufs) {
            if (bufs == null) {
                return 0L;
            }
            if (bufs.length < 1) {
                return 0L;
            }
            int size = 0;
            if (this.isWriteMarked) {
                for (ByteBuffer buffer : bufs) {
                    size += buffer.remaining();
                    this.writeMarkBuffer.append(buffer);
                }
            } else {
                for (ByteBuffer buffer : bufs) {
                    size += buffer.remaining();
                }
                this.queue.append(bufs);
            }
            return size;
        }

        public void markWritePosition() {
            this.removeWriteMark();
            this.isWriteMarked = true;
            this.writeMarkBuffer = new RewriteableBuffer();
        }

        public void removeWriteMark() {
            if (this.isWriteMarked) {
                this.isWriteMarked = false;
                this.append(this.writeMarkBuffer.drain());
                this.writeMarkBuffer = null;
            }
        }

        public boolean resetToWriteMark() {
            if (this.isWriteMarked) {
                this.writeMarkBuffer.resetWritePosition();
                return true;
            }
            return false;
        }

        protected Object clone() throws CloneNotSupportedException {
            WriteQueue copy = new WriteQueue();
            copy.queue.append(this.queue.copyContent());
            if (this.writeMarkBuffer != null) {
                copy.writeMarkBuffer = (RewriteableBuffer)this.writeMarkBuffer.clone();
            }
            return copy;
        }

        public String toString() {
            return this.queue.toString();
        }
    }

    private final class SyncCaller
    implements IWriteCompletionHandler,
    IUnsynchronized {
        private final Object writeGuard = new Object();
        private final WriteCompletionHandlerAdapter writeCompletionHandlerAdapter;
        private IOException ioe = null;
        private boolean isWritten = false;
        private ByteBuffer[] dataToWrite = null;

        public SyncCaller(ByteBuffer[] buffers, WriteCompletionHandlerAdapter writeCompletionHandlerAdapter) throws IOException {
            this.writeCompletionHandlerAdapter = writeCompletionHandlerAdapter;
            this.dataToWrite = buffers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call() throws IOException {
            BodyDataSinkImplBase.this.written += BodyDataSinkImplBase.this.writeData(this.dataToWrite, this);
            Object object = this.writeGuard;
            synchronized (object) {
                if (!this.isWritten) {
                    long start = System.currentTimeMillis();
                    long remainingTime = BodyDataSinkImplBase.this.sendTimeoutMillis;
                    do {
                        try {
                            this.writeGuard.wait(remainingTime);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        if (this.ioe != null) {
                            throw this.ioe;
                        }
                        if (!this.isWritten) continue;
                        return;
                    } while ((remainingTime = start + BodyDataSinkImplBase.this.sendTimeoutMillis - System.currentTimeMillis()) > 0L);
                    String msg = "[" + BodyDataSinkImplBase.this.getId() + "] send timeout " + DataConverter.toFormatedDuration((long)BodyDataSinkImplBase.this.sendTimeoutMillis) + " reached)";
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(msg);
                    }
                    throw new SocketTimeoutException(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWritten(int written) throws IOException {
            if (this.writeCompletionHandlerAdapter != null) {
                this.writeCompletionHandlerAdapter.onWritten(written);
            }
            Object object = this.writeGuard;
            synchronized (object) {
                this.isWritten = true;
                this.writeGuard.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(IOException ioe) {
            if (this.writeCompletionHandlerAdapter != null) {
                this.writeCompletionHandlerAdapter.onException(ioe);
            }
            Object object = this.writeGuard;
            synchronized (object) {
                this.ioe = ioe;
                this.isWritten = true;
                this.writeGuard.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteCompletionHandlerAdapter
    implements IWriteCompletionHandler,
    IUnsynchronized {
        private final List<WriteCompletionHandlerCaller> callers;

        public WriteCompletionHandlerAdapter(List<WriteCompletionHandlerCaller> callers) throws IOException {
            this.callers = callers;
        }

        public void onWritten(int written) throws IOException {
            for (WriteCompletionHandlerCaller caller : this.callers) {
                caller.onWritten();
            }
        }

        public void onException(IOException ioe) {
            if (BodyDataSinkImplBase.this.isIgnoreWriteError.get()) {
                for (WriteCompletionHandlerCaller caller : this.callers) {
                    caller.onWritten();
                }
            } else {
                for (WriteCompletionHandlerCaller caller : this.callers) {
                    caller.onException(ioe);
                }
            }
        }
    }
}

