/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Set;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.FullMessageBodyDataSource;
import org.xlightweb.FullMessageChunkedBodyDataSource;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.InMemoryBodyDataSource;
import org.xlightweb.MultipartByteRangeMessageBodyDataSource;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.Part;
import org.xsocket.DataConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHttpMessage
extends Part
implements IHttpMessage {
    AbstractHttpMessage(IHttpMessageHeader header) {
        super(header);
    }

    @Override
    public final IHttpMessageHeader getMessageHeader() {
        return (IHttpMessageHeader)this.getPartHeader();
    }

    @Override
    public final void setAttribute(String name, Object o) {
        this.getMessageHeader().setAttribute(name, o);
    }

    @Override
    public final Object getAttribute(String name) {
        return this.getMessageHeader().getAttribute(name);
    }

    @Override
    public final Enumeration getAttributeNames() {
        return this.getMessageHeader().getAttributeNames();
    }

    @Override
    public final Set<String> getAttributeNameSet() {
        return this.getMessageHeader().getAttributeNameSet();
    }

    @Override
    public final int getContentLength() {
        return this.getMessageHeader().getContentLength();
    }

    @Override
    public final void setContentLength(int length) {
        this.getMessageHeader().setContentLength(length);
    }

    @Override
    public final void removeHopByHopHeaders() {
        this.getMessageHeader().removeHopByHopHeaders();
        try {
            if (this.hasBody() && this.getContentLength() == -1 && this.getHeader("Transfer-Encoding") == null) {
                if (HttpUtils.hasContentType(this.getPartHeader(), "text/event-stream")) {
                    this.setHeader("Connection", "close");
                } else if (this.getNonBlockingBody().isComplete()) {
                    this.setContentLength(this.getNonBlockingBody().getSize());
                } else {
                    this.setHeader("Transfer-Encoding", "chunked");
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    final void setBody(IHttpMessageHeader header, ByteBuffer[] body, boolean compress) throws IOException {
        if (compress) {
            byte[] data = HttpUtils.compress(DataConverter.toBytes((ByteBuffer[])body));
            this.setBody(new InMemoryBodyDataSource((IHeader)header, data));
            this.getNonBlockingBody().getHeader().setHeader("Content-Encoding", "gzip");
        } else {
            super.setBody(header, body);
        }
        header.setContentLength(this.getNonBlockingBody().available());
    }

    @Override
    boolean setBody(NonBlockingBodyDataSource body) throws IOException {
        boolean isAdded = super.setBody(body);
        if (isAdded) {
            if (AbstractHttpConnection.isChunkedTransferEncoding(this.getMessageHeader())) {
                return isAdded;
            }
            if (this.getMessageHeader().getContentLength() >= 0) {
                return isAdded;
            }
            if (this.getNonBlockingBody().isComplete()) {
                this.getMessageHeader().setContentLength(this.getNonBlockingBody().available());
            } else if (this.getNonBlockingBody() instanceof FullMessageBodyDataSource) {
                this.getMessageHeader().setContentLength(((FullMessageBodyDataSource)this.getNonBlockingBody()).getSize());
            } else if (this.getNonBlockingBody() instanceof FullMessageChunkedBodyDataSource) {
                this.getMessageHeader().setTransferEncoding("chunked");
            } else if (this.getNonBlockingBody() instanceof MultipartByteRangeMessageBodyDataSource) {
                if (this.getMessageHeader().getContentType().toLowerCase().startsWith("multipart/byteranges")) {
                    return isAdded;
                }
                String separator = ((MultipartByteRangeMessageBodyDataSource)this.getNonBlockingBody()).getSeparator();
                this.getMessageHeader().setContentType("Content-Type: multipart/byteranges; boundary=" + separator);
            }
        }
        return isAdded;
    }
}

