/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.script;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.PageRankProvider;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.view.customization.ui.script.ReadonlyEntity;
import com.paterva.maltego.view.customization.ui.script.ScriptAugmentDescriptor;
import com.paterva.maltego.view.customization.ui.script.ScriptBindingProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.openide.util.Exceptions;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;

public class NodeScriptBindingProvider
implements ScriptBindingProvider<Node> {
    private static NodeScriptBindingProvider _instance;
    private static final String BIND_LINKS_IN = "linksIn";
    private static final String BIND_LINKS_OUT = "linksOut";
    private static final String BIND_LINKS_ALL = "linksAll";
    private static final String BIND_TYPE = "type";
    private static final String BIND_TYPES = "types";
    private static final String BIND_VALUE = "value";
    private static final String BIND_PROPERTY_KEYS = "propertyKeys";
    private static final String BIND_PROPERTY_VALUES = "propertyValues";
    private static final String BIND_NOTES = "notes";
    private static final String BIND_BOOKMARK = "bookmark";
    private static final String BIND_WEIGHT = "weight";
    private static final String BIND_DISPLAY_INFO_KEYS = "displayInfoKeys";
    private static final String BIND_DISPLAY_INFO_VALUES = "displayInfoValues";
    private static final String BIND_PAGE_RANK = "rank";
    private static final String BIND_PARENT_DISTANCES = "parentDistances";
    private static final String BIND_ENTITIES = "entities";
    private static final String BIND_ENTITY = "entity";
    private final List<ScriptAugmentDescriptor> _bindings = new ArrayList<ScriptAugmentDescriptor>();

    public static synchronized NodeScriptBindingProvider instance() {
        if (_instance == null) {
            _instance = new NodeScriptBindingProvider();
        }
        return _instance;
    }

    private NodeScriptBindingProvider() {
        this._bindings.add(new ScriptAugmentDescriptor(BIND_LINKS_IN, "number", "Amount of incoming links"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_LINKS_OUT, "number", "Amount of outgoing links"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_LINKS_ALL, "number", "Amount of incoming and outgoing links"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_TYPE, "string", "The entity type"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_TYPES, "Array<string>", "All inherited types"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_VALUE, "object", "The value of the entity"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_PROPERTY_KEYS, "Array<string>", "The names of all the properties"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_PROPERTY_VALUES, "Array<object>", "The values of all the properties"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_NOTES, "string", "The entity notes"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_BOOKMARK, "number", "The entity bookmark value (-1 if not bookmarked)"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_WEIGHT, "number", "The entity weight"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_DISPLAY_INFO_KEYS, "Array<string>", "The names of all display information entries"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_DISPLAY_INFO_VALUES, "Array<string>", "The values of all display information entries"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_PAGE_RANK, "number", "The \"importance\" of the entity based on its own and its neighbours links."));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_PARENT_DISTANCES, "Array<number>", "The shortest distances through the common ancestors of all parent pairs. Max distance is 10."));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_ENTITIES, "number", "1 or the amount of entities contained in the collection"));
        this._bindings.add(new ScriptAugmentDescriptor(BIND_ENTITY, "object", "Direct read-only access to the entity. (for advanced users)"));
    }

    @Override
    public List<ScriptAugmentDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public Bindings createBindings(Node node, String script) {
        SimpleBindings bindings = new SimpleBindings();
        Graph graph = node.getGraph();
        GraphID graphID = GraphIDProvider.forGraph((Graph)graph);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph);
        EntityID viewEntityID = wrapper.entityID(node);
        ReadonlyEntity readonlyEntity = new ReadonlyEntity(graphID, viewEntityID, wrapper);
        if (script.contains(BIND_LINKS_IN) || script.contains(BIND_LINKS_OUT) || script.contains(BIND_LINKS_ALL)) {
            Integer inDegree = null;
            Integer outDegree = null;
            if (script.contains(BIND_LINKS_IN)) {
                if (inDegree == null) {
                    inDegree = readonlyEntity.linksIn();
                }
                bindings.put(BIND_LINKS_IN, (Object)inDegree);
            }
            if (script.contains(BIND_LINKS_OUT)) {
                if (outDegree == null) {
                    outDegree = readonlyEntity.linksOut();
                }
                bindings.put(BIND_LINKS_OUT, (Object)outDegree);
            }
            if (script.contains(BIND_LINKS_ALL)) {
                if (inDegree == null) {
                    inDegree = readonlyEntity.linksIn();
                }
                if (outDegree == null) {
                    outDegree = readonlyEntity.linksOut();
                }
                bindings.put(BIND_LINKS_ALL, (Object)(inDegree + outDegree));
            }
        }
        if (script.contains(BIND_TYPE)) {
            bindings.put(BIND_TYPE, (Object)readonlyEntity.getType());
        }
        if (script.contains(BIND_TYPES)) {
            bindings.put(BIND_TYPES, (Object)readonlyEntity.getTypes());
        }
        if (script.contains(BIND_VALUE)) {
            bindings.put(BIND_VALUE, readonlyEntity.getValue());
        }
        if (script.contains(BIND_PROPERTY_KEYS)) {
            bindings.put(BIND_PROPERTY_KEYS, (Object)readonlyEntity.getPropertyKeys());
        }
        if (script.contains(BIND_PROPERTY_VALUES)) {
            bindings.put(BIND_PROPERTY_VALUES, (Object)readonlyEntity.getPropertyValues());
        }
        if (script.contains(BIND_NOTES)) {
            bindings.put(BIND_NOTES, (Object)readonlyEntity.getNotes());
        }
        if (script.contains(BIND_BOOKMARK)) {
            bindings.put(BIND_BOOKMARK, (Object)readonlyEntity.getBookmark());
        }
        if (script.contains(BIND_WEIGHT)) {
            bindings.put(BIND_WEIGHT, (Object)readonlyEntity.getWeight());
        }
        if (script.contains(BIND_DISPLAY_INFO_KEYS)) {
            bindings.put(BIND_DISPLAY_INFO_KEYS, (Object)readonlyEntity.getDisplayInfoKeys());
        }
        if (script.contains(BIND_DISPLAY_INFO_VALUES)) {
            bindings.put(BIND_DISPLAY_INFO_VALUES, (Object)readonlyEntity.getDisplayInfoValues());
        }
        if (script.contains(BIND_PAGE_RANK)) {
            bindings.put(BIND_PAGE_RANK, (Object)PageRankProvider.getDefault().get(node));
        }
        try {
            if (script.contains(BIND_PARENT_DISTANCES)) {
                GraphStructureReader structureReader;
                if (wrapper.isCollectionNode(viewEntityID)) {
                    GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                    structureReader = view.getGraphStructureStore().getStructureReader();
                } else {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    structureReader = graphStore.getGraphStructureStore().getStructureReader();
                }
                ArrayList<Integer> depths = new ArrayList<Integer>();
                EntityID[] parents = structureReader.getParents(viewEntityID).toArray(new EntityID[0]);
                for (int p1 = 0; p1 < parents.length - 1; ++p1) {
                    for (int p2 = p1 + 1; p2 < parents.length; ++p2) {
                        int depth = this.getParentDistance(structureReader, parents[p1], parents[p2], 10);
                        depths.add(depth);
                    }
                }
                bindings.put(BIND_PARENT_DISTANCES, (Object)depths.toArray(new Integer[depths.size()]));
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (script.contains(BIND_ENTITIES)) {
            bindings.put(BIND_ENTITIES, (Object)(readonlyEntity.isCollection() ? readonlyEntity.getWeight() : 1));
        }
        if (script.contains(BIND_ENTITY)) {
            bindings.put(BIND_ENTITY, (Object)readonlyEntity);
        }
        return bindings;
    }

    private int getParentDistance(GraphStructureReader structureReader, EntityID n1, EntityID n2, int limit) throws GraphStoreException {
        HashSet<EntityID> n1Nodes = new HashSet<EntityID>();
        HashSet<EntityID> n2Nodes = new HashSet<EntityID>();
        n1Nodes.add(n1);
        n2Nodes.add(n2);
        Set<EntityID> n1Parents = new HashSet<EntityID>();
        Set<EntityID> n2Parents = new HashSet<EntityID>();
        n1Parents.addAll(structureReader.getParents(n1));
        n2Parents.addAll(structureReader.getParents(n2));
        int depth1 = 0;
        int depth2 = 0;
        while (!(depth1 + depth2 + 2 >= limit || n1Parents.isEmpty() && n2Parents.isEmpty())) {
            if (!Collections.disjoint(n1Parents, n2Nodes)) {
                return depth1 + 1 + depth2;
            }
            if (!Collections.disjoint(n2Parents, n1Nodes)) {
                return depth1 + (depth2 + 1);
            }
            if (!Collections.disjoint(n1Parents, n2Parents)) {
                return depth1 + depth2 + 2;
            }
            if (!n1Parents.isEmpty()) {
                n1Nodes.addAll(n1Parents);
                n1Parents = this.getParents(structureReader, n1Parents);
                ++depth1;
            }
            if (n2Parents.isEmpty()) continue;
            n2Nodes.addAll(n2Parents);
            n2Parents = this.getParents(structureReader, n2Parents);
            ++depth2;
        }
        return limit;
    }

    private int getParentDistance(Node n1, Node n2, int limit) {
        HashSet<Node> n1Nodes = new HashSet<Node>();
        HashSet<Node> n2Nodes = new HashSet<Node>();
        n1Nodes.add(n1);
        n2Nodes.add(n2);
        Set<Node> n1Parents = new HashSet<Node>();
        Set<Node> n2Parents = new HashSet<Node>();
        n1Parents.addAll((Collection<Node>)new NodeList(n1.predecessors()));
        n2Parents.addAll((Collection<Node>)new NodeList(n2.predecessors()));
        int depth1 = 0;
        int depth2 = 0;
        while (!(depth1 + depth2 + 2 >= limit || n1Parents.isEmpty() && n2Parents.isEmpty())) {
            if (this.intersects(n1Parents, n2Nodes)) {
                return depth1 + 1 + depth2;
            }
            if (this.intersects(n2Parents, n1Nodes)) {
                return depth1 + (depth2 + 1);
            }
            if (this.intersects(n1Parents, n2Parents)) {
                return depth1 + depth2 + 2;
            }
            if (!n1Parents.isEmpty()) {
                n1Nodes.addAll(n1Parents);
                n1Parents = this.getParents(n1Parents);
                ++depth1;
            }
            if (n2Parents.isEmpty()) continue;
            n2Nodes.addAll(n2Parents);
            n2Parents = this.getParents(n2Parents);
            ++depth2;
        }
        return limit;
    }

    private boolean intersects(Set<Node> nodes1, Set<Node> nodes2) {
        for (Node node : nodes1) {
            if (!nodes2.contains(node)) continue;
            return true;
        }
        return false;
    }

    private Set<Node> getParents(Set<Node> nodes) {
        HashSet<Node> parents = new HashSet<Node>();
        for (Node node : nodes) {
            parents.addAll((Collection<Node>)new NodeList(node.predecessors()));
        }
        return parents;
    }

    private Set<EntityID> getParents(GraphStructureReader structureReader, Set<EntityID> nodes) throws GraphStoreException {
        HashSet<EntityID> parents = new HashSet<EntityID>();
        for (EntityID node : nodes) {
            parents.addAll(structureReader.getParents(node));
        }
        return parents;
    }
}

