/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.script;

import com.paterva.maltego.view.customization.api.BindingScript;
import com.paterva.maltego.view.customization.ui.script.NodeScriptTransformer;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import y.base.Node;

public class BindingScriptImpl
implements BindingScript {
    private static Map<String, ScriptEngine> _cachedScriptEngines = new HashMap<String, ScriptEngine>();
    private String _engine;
    private String _script;

    public BindingScriptImpl(String engine, String script) throws IllegalArgumentException {
        ScriptEngine scriptEngine = _cachedScriptEngines.get(engine);
        if (scriptEngine == null) {
            ScriptEngineManager manager = new ScriptEngineManager();
            scriptEngine = manager.getEngineByName(engine);
            if (scriptEngine == null) {
                throw new IllegalArgumentException("The following script engine does not exist: " + engine);
            }
            _cachedScriptEngines.put(engine, scriptEngine);
        }
        this._engine = engine;
        this._script = script;
    }

    public BindingScriptImpl(String engine) throws IllegalArgumentException {
        this(engine, "");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getScriptEngineName() {
        return this._engine;
    }

    public Object evaluate(Object input) throws ScriptException {
        String script = this._script;
        Bindings bindings = new SimpleBindings();
        if (input instanceof Node) {
            Node node = (Node)input;
            NodeScriptTransformer transform = new NodeScriptTransformer();
            transform.transform(script, node);
            script = transform.getScript();
            bindings = transform.getBindings();
        }
        return _cachedScriptEngines.get(this._engine).eval(script, bindings);
    }

    public String getText() {
        return this._script;
    }

    public void setText(String script) {
        this._script = script;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindingScriptImpl other = (BindingScriptImpl)obj;
        if (this._script == null ? other._script != null : !this._script.equals(other._script)) {
            return false;
        }
        return !(this._engine != null ? !this._engine.equals(other._engine) : other._engine != null);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this._script != null ? this._script.hashCode() : 0);
        hash = 97 * hash + (this._engine != null ? this._engine.hashCode() : 0);
        return hash;
    }
}

