/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.binding;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.util.SlownessDetector;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;
import y.view.Graph2D;

public class TypeNameValidationManualTest
extends TopGraphAction {
    public String getName() {
        return "TypeNameValidationManualTest";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void actionPerformed(TopComponent tc) {
        SlownessDetector.setEnabled((boolean)false);
        try {
            this.populateGraphWithEntities();
        }
        catch (GraphStoreException | TypeInstantiationException | FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void populateGraphWithEntities() throws TypeInstantiationException, GraphStoreException, FileNotFoundException {
        Graph2D viewGraph = this.getTopViewGraph();
        GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreWriter writer = graphStore.getGraphDataStore().getDataStoreWriter();
        writer.beginUpdate();
        viewGraph.firePreEvent();
        EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
        this.addEntitiesToGraph(entityFactory, graphID);
        System.out.println("Commiting...");
        viewGraph.firePostEvent((Object)false);
        writer.endUpdate();
        viewGraph.fitGraph2DView();
        System.out.println("Done");
    }

    private void addEntitiesToGraph(EntityFactory entityFactory, GraphID graphID) {
        EntityRegistry registry = EntityRegistry.getDefault();
        Collection specs = registry.getAll();
        specs.forEach(spec -> {
            try {
                String typeName = spec.getTypeName();
                MaltegoEntity entity = (MaltegoEntity)entityFactory.createInstance(typeName, false, false);
                GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)entity);
            }
            catch (TypeInstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }
}

