/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.yfiles;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.jai.ProgressCallback;
import com.paterva.maltego.util.jai.TileInfo;
import com.paterva.maltego.util.jai.TileSupplier;
import com.paterva.maltego.util.jai.TilingAdapter;
import com.paterva.maltego.util.yfiles.GraphSettings;
import com.paterva.maltego.util.yfiles.IOHandlerJai;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import y.view.Graph2D;
import y.view.Graph2DView;

public class TiledImageOutputHandlerJai
extends IOHandlerJai {
    private final IOHandlerJai ioHandlerJai;
    private final int maxTileWidth;
    private final int maxTileHeight;
    private GraphSettings graphSettings;

    public TiledImageOutputHandlerJai(IOHandlerJai ioHandlerJai, int maxTileWidth, int maxTileHeight) {
        this.ioHandlerJai = ioHandlerJai;
        this.maxTileWidth = maxTileWidth;
        this.maxTileHeight = maxTileHeight;
    }

    public void write(final Graph2D graph2D, final File outFile, String format, final ProgressCallback cb) throws IOException {
        this.setupGraphSettings(graph2D);
        final Graph2DView graph2DView = this.graphSettings.getGraph2DView();
        final int pointX = this.graphSettings.getPointX();
        final int pointY = this.graphSettings.getPointY();
        int viewWidth = this.graphSettings.getViewWidth();
        int viewHeight = this.graphSettings.getViewHeight();
        final int colCount = (int)Math.ceil((double)viewWidth / (double)this.maxTileWidth);
        final int rowCount = (int)Math.ceil((double)viewHeight / (double)this.maxTileHeight);
        final double viewZoom = graph2DView.getZoom();
        final int tileWidth = Math.min(this.maxTileWidth, (int)Math.ceil((double)viewWidth / (double)colCount));
        final int tileHeight = Math.min(this.maxTileHeight, (int)Math.ceil((double)viewHeight / (double)rowCount));
        graph2DView.setSize(tileWidth, tileHeight);
        BufferedImage sample = this.getBufferedImage(graph2DView, tileWidth, tileHeight, pointX, pointY, viewZoom, graph2D, 0, 0);
        final String printName = StringUtilities.randomAlphabetic(10) + "." + FileUtilities.getFileExtension(outFile);
        final AtomicInteger progressUnit = new AtomicInteger(0);
        TileSupplier supplier = new TileSupplier(){

            @Override
            public TileInfo getTile(int tileIndexX, int tileIndexY) {
                if (!(tileIndexY % 10 != 0 && tileIndexY != rowCount - 1 || tileIndexX != 0 && tileIndexX != colCount - 1)) {
                    double percentage = 100.0 * (double)(tileIndexX + 1 + colCount * tileIndexY) / (double)(colCount * rowCount);
                    if (outFile.getName().toLowerCase().endsWith(".bmp")) {
                        percentage = 100.0 - percentage;
                    }
                    if ((int)percentage > progressUnit.get()) {
                        TilingAdapter.printDiagnostics(this, printName, percentage);
                        progressUnit.set((int)percentage);
                        cb.progress("EXPORT_IMAGE", "Saving image stream to file", (int)percentage);
                    }
                }
                BufferedImage bi = null;
                try {
                    bi = TiledImageOutputHandlerJai.this.getBufferedImage(graph2DView, tileWidth, tileHeight, pointX, pointY, viewZoom, graph2D, tileIndexY, tileIndexX);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TileInfo info = new TileInfo(bi, tileWidth, tileHeight, tileIndexX * tileWidth, tileIndexY * tileHeight);
                return info;
            }
        };
        TilingAdapter adapter = new TilingAdapter(tileWidth, tileHeight, tileWidth * colCount, tileHeight * rowCount, supplier);
        adapter.write(outFile, sample, format);
        this.restoreGraphSettings();
    }

    private BufferedImage getBufferedImage(Graph2DView graph2DView, int tileWidth, int tileHeight, int pointX, int pointY, double viewZoom, Graph2D graph2D, int rowIndex, int colIndex) throws IOException {
        double zoomX = (double)pointX * viewZoom + (double)(colIndex * tileWidth);
        double zoomY = (double)pointY * viewZoom + (double)(rowIndex * tileHeight);
        graph2DView.setViewPoint2D(zoomX / viewZoom, zoomY / viewZoom);
        return this.getTileBufferedImage(graph2D, this.ioHandlerJai);
    }

    private void setupGraphSettings(Graph2D graph2D) throws IllegalArgumentException {
        URL url = graph2D.getURL();
        Graph2DView graph2DView = (Graph2DView)graph2D.getCurrentView();
        if (graph2DView == null) {
            throw new IllegalArgumentException("graph has no associated Graph2DView");
        }
        int pointX = graph2DView.getViewPoint().x;
        int pointY = graph2DView.getViewPoint().y;
        int viewWidth = graph2DView.getWidth();
        int viewHeight = graph2DView.getHeight();
        this.graphSettings = new GraphSettings(graph2D, url, graph2DView, pointX, pointY, viewWidth, viewHeight);
    }

    private void restoreGraphSettings() {
        Graph2D graph2D = this.graphSettings.getGraph2D();
        Graph2DView graph2DView = this.graphSettings.getGraph2DView();
        graph2DView.setSize(this.graphSettings.getViewWidth(), this.graphSettings.getViewHeight());
        graph2DView.setViewPoint(this.graphSettings.getPointX(), this.graphSettings.getPointY());
        graph2D.setURL(this.graphSettings.getURL());
    }

    protected BufferedImage getTileBufferedImage(Graph2D graph2D, IOHandlerJai ioHandlerJai) throws IOException {
        BufferedImage bi = null;
        if (ioHandlerJai != null) {
            bi = ioHandlerJai.getTileBufferedImage(graph2D);
        }
        return bi;
    }

    @Override
    public BufferedImage getTileBufferedImage(Graph2D graph2D) throws IOException {
        return this.ioHandlerJai.getTileBufferedImage(graph2D);
    }
}

