/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.VersionSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openide.util.Exceptions;

public class Version
implements Comparable<Version> {
    private static final String PROP_OEM = "maltego.oem";
    private static final String PROP_VERSION = "maltego.version";
    private static final String PROP_BUILD_NUMBER = "maltego.buildnumber";
    private static final String PROP_VERSION_SUBTITLE = "maltego.version-subtitle";
    private static Version CURRENT = null;
    private int release = 0;
    private int major = 0;
    private int minor = 0;
    private int build = 0;
    private String subtitle = "";
    private String oem = "";

    public Version(int release, int major, int minor, int build) {
        this(release, major, minor, build, "", "");
    }

    public Version(int release, int major, int minor, int build, String subtitle, String oem) {
        this.release = release;
        this.major = major;
        this.minor = minor;
        this.build = build;
        this.subtitle = subtitle;
        this.oem = oem;
    }

    public static Version parse(String version) {
        int release = 0;
        int major = 0;
        int minor = 0;
        int build = 0;
        String[] parts = version.split("\\.");
        if (parts.length > 0) {
            release = Version.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            major = Version.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            minor = Version.parseInt(parts[2]);
        }
        if (parts.length > 3) {
            build = Version.parseInt(parts[3]);
        }
        return new Version(release, major, minor, build);
    }

    public static synchronized Version getCurrent() {
        if (CURRENT == null) {
            CURRENT = Version.loadVersion();
        }
        return CURRENT;
    }

    public int getRelease() {
        return this.release;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getOem() {
        return this.oem;
    }

    public boolean isDevBuild() {
        return this.getBuild() == 0 || this.getSubtitle().toLowerCase().contains("dev");
    }

    public void appendToUrl(StringBuilder sb) {
        this.appendToUrl(sb, null);
    }

    public void appendToUrl(StringBuilder sb, String branding) {
        sb.append("?version=");
        sb.append(this.toString(false, false, false));
        if (!StringUtilities.isNullOrEmpty(branding)) {
            sb.append("&branding=");
            sb.append(branding);
        }
        sb.append("&build=");
        sb.append(this.getBuild());
        sb.append("&subtitle=");
        sb.append(this.getSubtitle());
        sb.append("&oem=");
        sb.append(this.getOem());
    }

    public String toString(boolean includeProductName, boolean includeBuildNumber, boolean includeSuffixes) {
        String subscriptionPlan;
        StringBuilder sb = new StringBuilder();
        if (includeProductName) {
            String productName = System.getProperty("maltego.product-name", "Maltego");
            sb.append(productName.trim()).append(" ");
        }
        sb.append(this.release).append(".");
        sb.append(this.major).append(".");
        sb.append(this.minor);
        if (includeBuildNumber) {
            sb.append(".").append(this.build);
        }
        if (includeSuffixes) {
            if (!StringUtilities.isNullOrEmpty(this.subtitle)) {
                sb.append(" ").append(this.subtitle);
            }
            if (!StringUtilities.isNullOrEmpty(this.oem)) {
                sb.append(" (").append(this.oem).append(")");
            }
        }
        if (includeProductName && !StringUtilities.isNullOrEmpty(subscriptionPlan = System.getProperty("maltego.subscriptionPlan", ""))) {
            sb.append(" - ").append(subscriptionPlan);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version v = (Version)obj;
            return v.getRelease() == this.getRelease() && v.getMajor() == this.getMajor() && v.getMinor() == this.getMinor() && v.getBuild() == this.getBuild();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.release;
        hash = 37 * hash + this.major;
        hash = 37 * hash + this.minor;
        hash = 37 * hash + this.build;
        return hash;
    }

    @Override
    public int compareTo(Version v) {
        if (v.getRelease() != this.getRelease()) {
            return this.compareInts(this.getRelease(), v.getRelease());
        }
        if (v.getMajor() != this.getMajor()) {
            return this.compareInts(this.getMajor(), v.getMajor());
        }
        if (v.getMinor() != this.getMinor()) {
            return this.compareInts(this.getMinor(), v.getMinor());
        }
        return this.compareInts(this.getBuild(), v.getBuild());
    }

    private int compareInts(int i1, int i2) {
        return Integer.valueOf(i1).compareTo(i2);
    }

    private static Version loadVersion() {
        return VersionSupplier.getDefault().map(VersionSupplier::getVersion).orElseGet(Version::loadPatervaVersion);
    }

    public static Version loadPatervaVersion() {
        InputStream is = Version.class.getResourceAsStream("Maltego.properties");
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
        String versionStr = props.getProperty(PROP_VERSION, "4.0.0");
        String buildStr = props.getProperty(PROP_BUILD_NUMBER, "0000");
        String subtitle = props.getProperty(PROP_VERSION_SUBTITLE, "");
        String oem = props.getProperty(PROP_OEM, "");
        int release = 0;
        int major = 0;
        int minor = 0;
        String[] parts = versionStr.split("\\.");
        if (parts.length > 0) {
            release = Version.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            major = Version.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            minor = Version.parseInt(parts[2]);
        }
        int build = Version.parseInt(buildStr);
        return new Version(release, major, minor, build, subtitle, oem);
    }

    private static int parseInt(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

