/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.Base64;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.text.Bidi;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtilities {
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String ELLIPSES = "\u2026";

    private StringUtilities() {
    }

    public static boolean startsWithUpper(String val) {
        return !StringUtilities.isNullOrEmpty(val) ? Character.isUpperCase(val.codePointAt(0)) : false;
    }

    public static int countLetters(String val) {
        if (val == null) {
            return 0;
        }
        int count = 0;
        for (char c : val.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            ++count;
        }
        return count;
    }

    public static int countNumbers(String val) {
        if (val == null) {
            return 0;
        }
        int count = 0;
        for (char c : val.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            ++count;
        }
        return count;
    }

    public static int countChars(String val, char ... chars) {
        if (val == null) {
            return 0;
        }
        int count = 0;
        block0: for (char c : val.toCharArray()) {
            for (char aChar : chars) {
                if (c != aChar) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static String chompLines(String text, int length) {
        return StringUtilities.chompLines(text, length, ELLIPSES);
    }

    public static String chompLines(String text, int length, String endChars) {
        String[] lines = text.split("\n");
        return Arrays.stream(lines).map(line -> StringUtilities.chomp(line, length, endChars)).collect(Collectors.joining("\n"));
    }

    public static String chomp(String s, int count) {
        return StringUtilities.chomp(s, count, ELLIPSES);
    }

    public static String chomp(String s, int count, String endChars) {
        int length;
        if (s.length() > count && (length = count - endChars.length()) > 0) {
            s = s.substring(0, length);
            s = s + endChars;
        }
        return s;
    }

    public static String toString(InputStream is, String charset) throws IOException {
        return StringUtilities.toString(is, Charset.forName(charset != null ? charset : "UTF-8"));
    }

    public static String toString(InputStream is, Charset charset) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(StringUtilities.newLine());
            }
        }
        return buffer.toString();
    }

    public static String capitalize(String s) {
        if (StringUtilities.isNullOrEmpty(s)) {
            return s;
        }
        String start = s.substring(0, 1);
        return start.toUpperCase() + s.substring(1);
    }

    public static String capitalizeFully(String s) {
        return WordUtils.capitalizeFully((String)s);
    }

    public static boolean isNullString(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    public static String toCommaList(String[] values) {
        StringBuilder builder = new StringBuilder();
        if (values != null) {
            for (String v : values) {
                builder.append(v);
            }
        }
        return builder.toString();
    }

    public static String[] fromCommaList(String commaSeparated) {
        String[] values = commaSeparated.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public static String newLine() {
        return NEW_LINE;
    }

    public static boolean areEqual(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2 == null;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String trim(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public static Object trimIfNotBlank(Object value) {
        String text;
        if (value instanceof String && StringUtils.isNotBlank((CharSequence)(text = (String)value))) {
            value = text.trim();
        }
        return value;
    }

    public static String createUniqueString(Collection<String> otherStrings, String preferedString) {
        int index = 1;
        String newString = preferedString;
        while (otherStrings.contains(newString)) {
            newString = preferedString + index;
            ++index;
        }
        return newString;
    }

    public static String createRedPostfixHtmlString(String text, String postfix) {
        return "<html><body>" + text + " <font color=\"#FF0000\">" + postfix + "</font></body></html>";
    }

    public static String bytesToString(long bytes) {
        if (bytes <= 0L) {
            return "0 B";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(bytes) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)bytes / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String countToString(long count) {
        if (count <= 0L) {
            return "0";
        }
        String[] units = new String[]{"", "K", "M"};
        int digitGroups = (int)(Math.log10(count) / Math.log10(1000.0));
        return new DecimalFormat("##0.#").format((double)count / Math.pow(1000.0, digitGroups)) + units[digitGroups];
    }

    public static String toStringUnsignedLong(long l, int radix) {
        BigInteger bi = BigInteger.valueOf(l);
        if (bi.signum() < 0) {
            bi = bi.add(BigInteger.ONE.shiftLeft(64));
        }
        return bi.toString(radix);
    }

    public static long parseUnsignedLong(String value, int radix) {
        BigInteger parsedBi = new BigInteger(value, radix);
        long l = parsedBi.longValue();
        if (parsedBi.testBit(64)) {
            l |= Long.MIN_VALUE;
        }
        return l;
    }

    public static String replaceDigitsWithWords(String txt) {
        txt = txt.replace("0", "zero").replace("1", "one");
        txt = txt.replace("2", "two").replace("3", "three");
        txt = txt.replace("4", "four").replace("5", "five");
        txt = txt.replace("6", "six").replace("7", "seven");
        txt = txt.replace("8", "eight").replace("9", "nine");
        return txt;
    }

    public static String keepOnlyAlphaNumeric(String text) {
        return text.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static String basicEncrypt(String text) throws UnsupportedEncodingException, GeneralSecurityException {
        byte[] bytes = text.getBytes("UTF-8");
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(1, (Key)StringUtilities.getBasicSecretKey(), StringUtilities.getBasicIV());
        return Base64.encodeBytes(cipher.doFinal(bytes));
    }

    public static String basicDecrypt(String text) throws IOException, GeneralSecurityException {
        byte[] bytes = Base64.decode(text);
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(2, (Key)StringUtilities.getBasicSecretKey(), StringUtilities.getBasicIV());
        return new String(cipher.doFinal(bytes), "UTF-8");
    }

    private static SecretKey getBasicSecretKey() throws UnsupportedEncodingException, GeneralSecurityException {
        DESedeKeySpec keySpec = new DESedeKeySpec("!blUeM0nkeysE@tThoughT5!".getBytes("UTF8"));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
        return keyFactory.generateSecret(keySpec);
    }

    private static IvParameterSpec getBasicIV() throws UnsupportedEncodingException {
        return new IvParameterSpec("q!U@mtun".getBytes("UTF-8"));
    }

    public static String listToString(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(value).append("|");
        }
        return sb.toString();
    }

    public static List<String> listFromString(String text) {
        ArrayList<String> values = new ArrayList<String>();
        if (text.contains("|")) {
            String[] tokens = text.split("\\|", -1);
            values.addAll(Arrays.asList(tokens));
            values.remove(values.size() - 1);
        }
        return values;
    }

    public static String getCtrlShortcut(String otherKeys) {
        return (org.openide.util.Utilities.isMac() ? "Cmd+" : "Ctrl+") + otherKeys;
    }

    public static String getApproximateMemSize(String text) {
        return StringUtilities.bytesToString(text.length() * 2);
    }

    public static double getStringWidth(Graphics g, String s) {
        return StringUtilities.getStringWidth(g, g.getFont(), s);
    }

    public static double getStringWidth(Graphics g, Font f, String s) {
        FontMetrics fm = g.getFontMetrics(f);
        double width = org.openide.util.Utilities.isMac() ? (double)fm.stringWidth(s) : fm.getStringBounds(s, g).getWidth();
        return width;
    }

    public static double getStringHeight(Graphics g) {
        return g.getFont().getSize();
    }

    public static double getStringHeight(Graphics g, String s) {
        return StringUtilities.getStringHeight(g, g.getFont(), s);
    }

    public static double getStringHeight(Graphics g, Font f, String s) {
        FontMetrics fm = g.getFontMetrics(f);
        double height = org.openide.util.Utilities.isMac() ? (double)(fm.getAscent() + fm.getDescent()) : fm.getStringBounds(s, g).getHeight();
        return height;
    }

    public static String truncate(Graphics2D g, String text, double width, double height) {
        Rectangle displayNameRect = new Rectangle(0, 0, (int)width, (int)height);
        Rectangle viewRect = new Rectangle();
        viewRect.setRect(displayNameRect);
        Rectangle iconRect = new Rectangle();
        iconRect.setRect(displayNameRect);
        Rectangle textRect = new Rectangle();
        textRect.setRect(displayNameRect);
        text = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), text, null, 1, 2, 1, 2, viewRect, iconRect, textRect, 0);
        return text;
    }

    public static String getLongestWord(String text) {
        String word = "";
        String largeWord = "";
        int max = 0;
        boolean c = false;
        text = text + " ";
        int l = text.length();
        for (int i = 0; i < l; ++i) {
            char ch = text.charAt(i);
            if (ch != ' ') {
                word = word + ch;
                continue;
            }
            int lw = word.length();
            if (lw > max) {
                max = lw;
                largeWord = word;
            }
            word = "";
        }
        return largeWord;
    }

    public static int getWrappedLines(JTextArea textArea, int prefWidth) {
        String text = textArea.getText();
        FontMetrics fm = textArea.getFontMetrics(textArea.getFont());
        PlainDocument doc = new PlainDocument();
        Segment segment = new Segment();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int noLines = 0;
        int i = 0;
        while (i < text.length()) {
            try {
                doc.getText(i, text.length() - i, segment);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int caretWidth = 1;
            int breakpoint = Utilities.getBreakLocation(segment, fm, 0, prefWidth - caretWidth, null, 0);
            i += breakpoint;
            ++noLines;
        }
        return noLines;
    }

    public static int getWrappedLines(String text, FontMetrics fm, Insets insets, int prefWidth) {
        StringBuilder sb = new StringBuilder();
        String br = "<br>";
        text = text.trim();
        StringUtilities.wrapTextInStringBuilder(sb, text, fm, insets, br, prefWidth, Integer.MAX_VALUE);
        String wrappedText = sb.toString().trim();
        int change = 0;
        return StringUtils.countMatches((CharSequence)wrappedText, (CharSequence)br) + StringUtils.countMatches((CharSequence)wrappedText, (CharSequence)"\r") + Math.max(StringUtils.countMatches((CharSequence)wrappedText, (CharSequence)"\n"), StringUtils.countMatches((CharSequence)text, (CharSequence)"\n")) + change;
    }

    public static String getWrappedText(String text, FontMetrics fm, Insets insets, int prefWidth) {
        StringBuilder sb = new StringBuilder();
        String br = "<br>";
        text = text.trim();
        StringUtilities.wrapTextInStringBuilder(sb, text, fm, insets, br, prefWidth, Integer.MAX_VALUE);
        String wrappedText = sb.toString().trim();
        return wrappedText;
    }

    public static String getShortcutKeyDelimiter() {
        String temp = "-";
        String delimiter = UIManager.getLookAndFeelDefaults().getString("MenuItem.acceleratorDelimiter");
        return delimiter != null ? delimiter : temp;
    }

    public static String indent(String str, char openChar, char closeChar, String indentStr) {
        StringBuilder sb = new StringBuilder(str.length());
        int indent = 0;
        boolean lineStart = true;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            boolean append = true;
            if (ch == openChar) {
                if (lineStart && indent > 0) {
                    sb.append(indentStr);
                    lineStart = false;
                }
                ++indent;
            } else if (ch == closeChar) {
                --indent;
            } else if (ch == '\n') {
                sb.append(ch);
                for (int j = 0; j < indent - 1; ++j) {
                    sb.append(indentStr);
                }
                append = false;
                lineStart = true;
            } else if (ch == ' ') {
                append = !lineStart;
            } else if (ch != ' ' && lineStart) {
                sb.append(indentStr);
                lineStart = false;
            }
            if (!append) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String replace(String original, int offset, int length, String replacement) {
        StringBuilder sb = new StringBuilder(original);
        sb.replace(offset, offset + length, replacement);
        return sb.toString();
    }

    public static String insertStringPeriodically(String original, String insert, int period) {
        return original == null ? null : original.replaceAll("(.{0," + period + "})", "$1" + insert);
    }

    public static String fromGzipBase64(String gzipBase64Str) throws IOException {
        if (StringUtils.isBlank((CharSequence)gzipBase64Str)) {
            return null;
        }
        byte[] gzipBytes = java.util.Base64.getDecoder().decode(gzipBase64Str.getBytes(StandardCharsets.UTF_8));
        try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(gzipBytes));){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static void wrapTextInStringBuilder(StringBuilder sb, String text, FontMetrics fm, Insets insets, String br, int width, int height) throws Error {
        StringUtilities.wrapTextInStringBuilder(sb, text, fm, insets, br, width, height, Integer.MAX_VALUE);
    }

    public static void wrapTextInStringBuilder(StringBuilder sb, String text, FontMetrics fm, Insets insets, String br, int width, int height, int maxLines) throws Error {
        PlainDocument doc = new PlainDocument();
        Segment segment = new Segment();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int noOfLine = 0;
        boolean lastLine = false;
        int i = 0;
        while (i < text.length() && (noOfLine + 1) * fm.getHeight() + insets.top + insets.bottom <= height) {
            int breakpoint;
            if ((noOfLine + 2) * fm.getHeight() + insets.top + insets.bottom > height) {
                lastLine = true;
            }
            if (noOfLine + 1 >= maxLines) {
                lastLine = true;
            }
            try {
                doc.getText(i, text.length() - i, segment);
            }
            catch (BadLocationException e) {
                throw new Error("Can't get line text");
            }
            int caretWidth = 1;
            if (lastLine) {
                String ellipsis = " ...";
                int ellipsesWidth = fm.stringWidth(ellipsis);
                breakpoint = Utilities.getBreakLocation(segment, fm, 0, width - caretWidth - insets.left - insets.right - ellipsesWidth, null, 0);
                String lineText = text.substring(i, i + breakpoint);
                sb.append(lineText.trim());
                if (i + breakpoint >= text.length()) break;
                sb.append(ellipsis);
                break;
            }
            breakpoint = Utilities.getBreakLocation(segment, fm, 0, width - caretWidth - insets.left - insets.right, null, 0);
            sb.append(text.substring(i, i + breakpoint).trim());
            sb.append(br);
            i += breakpoint;
            ++noOfLine;
        }
    }

    public static String escapeRTLBidiText(String text) {
        Bidi bidi = new Bidi(text, -2);
        if (bidi.isLeftToRight()) {
            return text;
        }
        String special = " ~!@#$%^&*()_+=-0987654321`\\][';,./|}{:\"?><";
        String LRE = "\u202a";
        String RLE = "\u202b";
        String LRO = "\u202d";
        String RLO = "\u202e";
        String PDF = "\u202c";
        if (bidi.isRightToLeft()) {
            return "\u202e" + text + "\u202c";
        }
        String bidiText = text.replace("\u202d", "").replace("\u202e", "").replace("\u202a", "").replace("\u202b", "").replace("\u202c", "");
        if (!bidiText.equals(text)) {
            bidi = new Bidi(bidiText, -2);
        }
        int runCount = bidi.getRunCount();
        StringBuilder builder = new StringBuilder(bidiText.length() + runCount * 2);
        boolean startLTR = false;
        for (int run = 0; run < runCount; ++run) {
            int runLevel = bidi.getRunLevel(run);
            boolean rtl = runLevel % 2 != 0;
            int runStart = bidi.getRunStart(run);
            int runLimit = bidi.getRunLimit(run);
            String extract = bidiText.substring(runStart, runLimit);
            if (!rtl && (builder.length() == 0 || startLTR)) {
                startLTR = true;
                builder.append(extract);
                continue;
            }
            builder.append(rtl ? "\u202e" : "\u202d");
            if (rtl) {
                int end;
                for (end = extract.length(); end > 0 && " ~!@#$%^&*()_+=-0987654321`\\][';,./|}{:\"?><".indexOf(extract.charAt(end - 1)) >= 0; --end) {
                }
                if (end > 0 && end < extract.length()) {
                    extract = extract.substring(0, end);
                    bidiText = bidiText.substring(runStart + end);
                    bidi = new Bidi(bidiText, -2);
                    runCount = bidi.getRunCount();
                    run = -1;
                }
            }
            builder.append(extract);
            builder.append("\u202c");
        }
        return builder.toString();
    }

    public static String escapeNewlines(String str) {
        return str == null ? null : str.replaceAll("[\r\n]+", "\\\\n");
    }

    public static String unescapeNewlines(String str) {
        return str == null ? null : str.replace("\\n", "\n");
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String randomAlphabetic(int length) {
        return RandomStringUtils.randomAlphabetic((int)10);
    }
}

