/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.io.File;
import java.util.EnumMap;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public enum IconSize {
    TINY(16),
    SMALL(24),
    MEDIUM(32),
    LARGE(48),
    MASSIVE(96);

    private final int _size;

    private IconSize(int size) {
        this._size = size;
    }

    public int getSize() {
        return this._size;
    }

    public String getPostfix() {
        return TINY.equals((Object)this) ? "" : Integer.toString(this._size);
    }

    public String addPostfix(String filename) {
        String postfix = this.getPostfix();
        if (filename == null || postfix.isEmpty()) {
            return filename;
        }
        return filename.replaceFirst("(\\.[^\\.]*)$", postfix + "$1");
    }

    public static IconSize getSize(String size) {
        if (StringUtilities.isNullOrEmpty(size)) {
            return TINY;
        }
        return IconSize.getSize(Integer.valueOf(size));
    }

    public static IconSize getSize(int width, int height) {
        return IconSize.getSize(IconSize.positiveMin(width, height));
    }

    public static IconSize getSize(int size) {
        if (size >= 0) {
            if (size <= 20) {
                return TINY;
            }
            if (size <= 28) {
                return SMALL;
            }
            if (size <= 38) {
                return MEDIUM;
            }
            if (size <= 48) {
                return LARGE;
            }
        }
        return MASSIVE;
    }

    private static int positiveMin(int a, int b) {
        if (a < 0 && b < 0) {
            return -1;
        }
        if (a < 0 && b > 0) {
            return b;
        }
        if (a > 0 && b < 0) {
            return a;
        }
        return Math.min(a, b);
    }

    public static File getBiggestForIconType(EnumMap<IconSize, File> sizes, IconSize iconSize) {
        File file = IconSize.getBiggest(sizes, IconSize.getIconTypeSizes(iconSize));
        if (file == null) {
            file = IconSize.getBiggest(sizes, IconSize.values());
        }
        return file;
    }

    private static File getBiggest(EnumMap<IconSize, File> sizes, IconSize[] values) {
        for (int i = values.length - 1; i >= 0; --i) {
            File file = sizes.get((Object)values[i]);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public static FileObject getBiggestForIconType(IconSize iconSize, EnumMap<IconSize, FileObject> sizes) {
        FileObject fo = IconSize.getBiggestForIconType(sizes, iconSize, true);
        if (fo == null) {
            fo = IconSize.getBiggestForIconType(sizes, iconSize, false);
        }
        return fo;
    }

    private static FileObject getBiggestForIconType(EnumMap<IconSize, FileObject> sizes, IconSize iconSize, boolean preferSVG) {
        FileObject fo = IconSize.getBiggest(sizes, IconSize.getIconTypeSizes(iconSize), preferSVG);
        if (fo == null && !preferSVG) {
            fo = IconSize.getBiggest(sizes, IconSize.values(), preferSVG);
        }
        return fo;
    }

    private static FileObject getBiggest(EnumMap<IconSize, FileObject> sizes, IconSize[] values, boolean preferSVG) {
        for (int i = values.length - 1; i >= 0; --i) {
            FileObject fo = sizes.get((Object)values[i]);
            if (fo == null) continue;
            if (preferSVG && ImageUtils.isSVGFile(fo)) {
                return fo;
            }
            if (preferSVG) continue;
            return fo;
        }
        return null;
    }

    public static Image getBiggestForIconType(String fullName, IconSize iconSize) {
        Image img = IconSize.getBiggest(fullName, IconSize.getIconTypeSizes(iconSize));
        if (img == null) {
            img = IconSize.getBiggest(fullName, IconSize.values());
        }
        return img;
    }

    private static Image getBiggest(String fullName, IconSize[] values) {
        for (int i = values.length - 1; i >= 0; --i) {
            String resource = values[i].addPostfix(fullName);
            Image img = ImageUtilities.loadImage((String)resource);
            if (img == null) continue;
            return img;
        }
        return null;
    }

    private static IconSize[] getIconTypeSizes(IconSize iconSize) {
        if (iconSize.getSize() <= SMALL.getSize()) {
            return new IconSize[]{TINY, SMALL};
        }
        return new IconSize[]{MEDIUM, LARGE, MASSIVE};
    }
}

