/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.sound;

import com.paterva.maltego.sound.ThreadedSound;
import com.paterva.maltego.util.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.openide.util.NbPreferences;

public class SoundPlayer {
    public static final String PREF_SOUND_ENABLED = "isSoundEnabled";
    private static SoundPlayer _player = null;
    private ExecutorService _executor;

    private SoundPlayer() {
    }

    public static synchronized SoundPlayer instance() {
        if (_player == null) {
            _player = new SoundPlayer();
        }
        return _player;
    }

    public void play(String name) {
        if (SoundPlayer.isSoundsEnabled()) {
            ThreadedSound sound = new ThreadedSound();
            sound.setSoundFile("Maltego/Sounds/" + name);
            try {
                this.getExecutor().execute(sound);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private synchronized ExecutorService getExecutor() {
        if (this._executor == null) {
            this._executor = Executors.newFixedThreadPool(15, (ThreadFactory)new NamedThreadFactory("Sound Player"));
        }
        return this._executor;
    }

    public static void setSoundsEnabled(boolean enabled) {
        NbPreferences.forModule(SoundPlayer.class).putBoolean(PREF_SOUND_ENABLED, enabled);
    }

    public static boolean isSoundsEnabled() {
        return NbPreferences.forModule(SoundPlayer.class).getBoolean(PREF_SOUND_ENABLED, true);
    }
}

