/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.serializer;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.SpecActionDescriptor;
import com.paterva.maltego.entity.registry.converter.RegexEntityConverter;
import com.paterva.maltego.entity.registry.serializer.ActionStub;
import com.paterva.maltego.entity.registry.serializer.BaseEntityStub;
import com.paterva.maltego.entity.registry.serializer.ConverterStub;
import com.paterva.maltego.entity.registry.serializer.EntityConverterTranslator;
import com.paterva.maltego.entity.registry.serializer.EntitySpecStub;
import com.paterva.maltego.entity.registry.serializer.RegexGroup;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.serializer.FieldsSerializer;
import com.paterva.maltego.typing.serializer.OverlayStub;
import com.paterva.maltego.typing.serializer.PropertiesStub;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

class EntitySpecTranslator {
    private static final Logger LOG = Logger.getLogger(EntitySpecTranslator.class.getName());

    EntitySpecTranslator() {
    }

    public MaltegoEntitySpec translate(EntitySpecStub stub) throws TypeInstantiationException, XmlSerializationException {
        FieldsSerializer serializer = new FieldsSerializer();
        PropertyConfiguration properties = serializer.readSerializationStub(stub.Properties);
        MaltegoEntitySpec spec = new MaltegoEntitySpec(stub.ID, properties);
        if (stub.Properties != null) {
            spec.setImageExpression(StringUtilities.unescapeNewlines((String)stub.Properties.getImageExpression()));
            spec.setDisplayValueExpression(StringUtilities.unescapeNewlines((String)stub.Properties.getDisplayValueExpression()));
        }
        spec.setBaseEntitySpecs(this.translateBaseEntityStubs(stub.BaseEntities));
        spec.setDescription(stub.Description);
        spec.setDisplayName(stub.Name);
        spec.setDisplayNamePlural(stub.PluralName);
        if (!StringUtilities.isNullOrEmpty((String)stub.Category)) {
            spec.setDefaultCategory(stub.Category);
        } else {
            spec.setDefaultCategory("My Entities");
        }
        if (stub.LargeIconResource != null) {
            spec.setLargeIconResource(stub.LargeIconResource);
        } else if (stub.LargeIcon != null) {
            spec.setLargeIcon(this.decodeIcon(stub.LargeIcon));
        }
        if (spec.getLargeIconResource() == null && spec.getLargeIcon() == null) {
            spec.setLargeIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/entity/registry/UnknownEntity24.png"));
        }
        if (stub.SmallIconResource != null) {
            spec.setSmallIconResource(stub.SmallIconResource);
        } else if (stub.SmallIcon != null) {
            spec.setSmallIcon(this.decodeIcon(stub.SmallIcon));
        }
        if (spec.getSmallIconResource() == null && spec.getSmallIcon() == null) {
            spec.setSmallIcon((Image)ImageUtils.smartSize((BufferedImage)ImageUtils.createBufferedImage((Image)spec.getLargeIcon()), (double)16.0));
        }
        spec.setToolboxItem(stub.IsAllowedRoot);
        spec.setVisible(stub.Visible);
        spec.setHelpUrl(stub.HelpUrl);
        spec.setHelpText(stub.HelpText);
        if (!StringUtilities.isNullOrEmpty((String)stub.ClassName)) {
            try {
                ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clazz = Class.forName(stub.ClassName, false, loader);
                if (!MaltegoEntity.class.isAssignableFrom(clazz)) {
                    throw new TypeInstantiationException("Class " + stub.ClassName + " does not implement interface MaltegoEntity.");
                }
                spec.setInstanceClass(clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new TypeInstantiationException("Could not find class " + stub.ClassName, (Exception)ex);
            }
        }
        if (stub.ConversionOrder != null) {
            spec.setConversionOrder(Integer.parseInt(stub.ConversionOrder));
        }
        spec.setConverter(this.getConverter(stub.Converter, stub.Properties));
        spec.setColor(EntitySpecTranslator.getColor(stub.Color));
        if (stub.Actions != null) {
            spec.setActions(this.getActionsFromStubs(stub.Actions));
        }
        if (stub.Overlays != null) {
            OverlayDescriptorSet overlays = stub.Overlays.stream().map(o -> new OverlayDescriptor(o.propertyName, o.position, o.type)).collect(Collectors.toCollection(OverlayDescriptorSet::new));
            spec.setOverlaySet(overlays);
        }
        return spec;
    }

    private List<String> translateBaseEntityStubs(List<BaseEntityStub> baseEntities) {
        ArrayList<String> baseEntitySpecs = new ArrayList<String>();
        if (baseEntities != null) {
            for (BaseEntityStub baseEntityStub : baseEntities) {
                baseEntitySpecs.add(baseEntityStub.getText().trim());
            }
        }
        return baseEntitySpecs;
    }

    private EntityConverter getConverter(ConverterStub stub, PropertiesStub propertiesStub) {
        return EntityConverterTranslator.translate(stub, propertiesStub);
    }

    private static Color getColor(String name) {
        if (StringUtilities.isNullOrEmpty((String)name)) {
            return null;
        }
        return Color.decode(name);
    }

    private Image decodeIcon(String base64Icon) {
        BufferedImage image = null;
        try {
            image = ImageUtils.base64Decode((String)base64Icon);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return image;
    }

    private List<SpecActionDescriptor> getActionsFromStubs(List<ActionStub> actionStubs) {
        ArrayList<SpecActionDescriptor> descriptors = new ArrayList<SpecActionDescriptor>(actionStubs.size());
        for (ActionStub actionStub : actionStubs) {
            SpecActionDescriptor descriptor = new SpecActionDescriptor(actionStub.Type, actionStub.Name, actionStub.DisplayName, actionStub.Config);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public EntitySpecStub translate(MaltegoEntitySpec spec) throws XmlSerializationException {
        EntitySpecStub stub = new EntitySpecStub();
        if (spec.getInstanceClass() != null) {
            stub.ClassName = spec.getInstanceClass().getName();
        }
        stub.BaseEntities = this.translateBaseEntities(spec.getBaseEntitySpecs());
        stub.ConversionOrder = String.valueOf(spec.getConversionOrder());
        if (spec.getConverter() instanceof RegexEntityConverter) {
            stub.Converter = this.translateConverter((RegexEntityConverter)spec.getConverter());
        }
        stub.Description = spec.getDescription();
        stub.HelpText = spec.getHelpText();
        stub.HelpUrl = spec.getHelpUrl();
        stub.ID = spec.getTypeName();
        stub.IsAllowedRoot = spec.isToolboxItem();
        stub.Visible = spec.isVisible();
        stub.Name = spec.getDisplayName();
        stub.PluralName = spec.getDisplayNamePlural();
        stub.Category = spec.getDefaultCategory();
        stub.SmallIconResource = spec.getSmallIconResource();
        if (stub.SmallIconResource == null && spec.getSmallIcon() != null) {
            stub.SmallIcon = EntitySpecTranslator.encodeIcon(spec.getSmallIcon());
        }
        stub.LargeIconResource = spec.getLargeIconResource();
        if (stub.LargeIconResource == null && spec.getLargeIcon() != null) {
            stub.LargeIcon = EntitySpecTranslator.encodeIcon(spec.getLargeIcon());
        }
        stub.Color = EntitySpecTranslator.getColorName(spec.getColor());
        FieldsSerializer serializer = new FieldsSerializer();
        stub.Properties = serializer.createSerializationStub(spec.getPropertyConfiguration());
        stub.Properties.setImageExpression(StringUtilities.escapeNewlines((String)spec.getImageExpression().orElse(null)));
        stub.Properties.setDisplayValueExpression(StringUtilities.escapeNewlines((String)spec.getDisplayValueExpression()));
        stub.Actions = this.getStubsFromActions(spec.getActions());
        stub.Overlays = this.getStubsFromOverlays(spec.getOverlaySet());
        return stub;
    }

    private List<BaseEntityStub> translateBaseEntities(List<String> baseEntities) {
        ArrayList<BaseEntityStub> baseEntityStubs = new ArrayList<BaseEntityStub>();
        for (String baseEntity : baseEntities) {
            if ("maltego.Unknown".equals(baseEntity)) continue;
            BaseEntityStub baseEntityStub = new BaseEntityStub();
            baseEntityStub.setText(baseEntity);
            baseEntityStubs.add(baseEntityStub);
        }
        return baseEntityStubs.isEmpty() ? null : baseEntityStubs;
    }

    private static String encodeIcon(Image icon) {
        if (icon != null) {
            try {
                return ImageUtils.base64Encode((Image)icon, (String)"png");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private ConverterStub translateConverter(RegexEntityConverter converter) {
        if (converter != null) {
            ConverterStub stub = new ConverterStub();
            stub.Regex = converter.toString();
            List<String> groupsToProperties = converter.getProperties();
            if (groupsToProperties != null) {
                stub.Groups = new LinkedList<RegexGroup>();
                for (int i = 0; i < groupsToProperties.size(); ++i) {
                    RegexGroup group = new RegexGroup();
                    group.Property = groupsToProperties.get(i);
                    stub.Groups.add(group);
                }
            }
            return stub;
        }
        return null;
    }

    private static String getColorName(Color color) {
        if (color == null) {
            return null;
        }
        return color.toString();
    }

    private List<ActionStub> getStubsFromActions(List<SpecActionDescriptor> descriptors) {
        ArrayList<ActionStub> actionStubs = null;
        if (descriptors != null) {
            actionStubs = new ArrayList<ActionStub>(descriptors.size());
            for (SpecActionDescriptor descriptor : descriptors) {
                ActionStub stub = new ActionStub();
                stub.Type = descriptor.getType();
                stub.Name = descriptor.getName();
                stub.DisplayName = descriptor.getDisplayName();
                stub.Config = descriptor.getConfig();
                actionStubs.add(stub);
            }
        }
        return actionStubs;
    }

    List<OverlayStub> getStubsFromOverlays(OverlayDescriptorSet overlaySet) {
        if (overlaySet == null || overlaySet.isEmpty()) {
            return null;
        }
        ArrayList<OverlayStub> overlayStubs = new ArrayList<OverlayStub>(overlaySet.size());
        for (OverlayDescriptor descriptor : overlaySet) {
            OverlayStub stub = new OverlayStub();
            stub.propertyName = descriptor.getPropertyName();
            stub.position = descriptor.getPosition().code;
            stub.type = descriptor.getType().type;
            overlayStubs.add(stub);
        }
        return overlayStubs;
    }
}

