/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.item.AbstractRunnableItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunningItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TransformServerItem
extends AbstractRunnableItem {
    private final TransformServerInfo _server;
    private final String _transformName;
    private final List<RunningItem> _runningItems;

    TransformServerItem(TransformServerInfo server, String transformName, Collection<RunningItem> runningItems) {
        this._server = server;
        this._transformName = transformName;
        this._runningItems = new ArrayList<RunningItem>(runningItems);
    }

    public String getName() {
        return "server." + this._server.getUrl().toString();
    }

    public String getDisplayName() {
        return this._server.getDisplayName();
    }

    public String getDescription() {
        return this.getName();
    }

    public List<? extends RunProviderItem> getChildren() {
        return this._runningItems;
    }

    public String getLafPrefix() {
        String prefix = "transforms-item-server";
        return prefix;
    }

    public boolean canRun() {
        return true;
    }

    public void run(GraphID graphID, Set<EntityID> entities) {
        TransformDefinition transform;
        if (!entities.isEmpty() && (transform = TransformRepositoryRegistry.getDefault().findTransform(this._transformName)) != null) {
            TransformRequestProcessor.getDefault().runTransform(transform, this._server, graphID, entities);
        }
    }

    public boolean canFavorite() {
        return false;
    }

    public void setFavorite(boolean favorite) {
    }

    public boolean isFavorite() {
        return false;
    }
}

