/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.runregistry.RunProvider;
import com.paterva.maltego.runregistry.favs.RunFavorites;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunProviderItemComparator;
import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.descriptor.favs.TransformFavorites;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.TransformSelector;
import com.paterva.maltego.transform.runner.api.TransformRunnable;
import com.paterva.maltego.transform.runner.api.TransformRunner;
import com.paterva.maltego.transform.runner.treelist.GeneratedTransformsItem;
import com.paterva.maltego.transform.runner.treelist.LocalTransformsItem;
import com.paterva.maltego.transform.runner.treelist.NoTransformsItem;
import com.paterva.maltego.transform.runner.treelist.TransformCategoryItem;
import com.paterva.maltego.transform.runner.treelist.TransformHubItem;
import com.paterva.maltego.transform.runner.treelist.TransformRunItem;
import com.paterva.maltego.transform.runner.treelist.TransformSetItem;
import com.paterva.maltego.transform.runner.treelist.TransformsItem;
import com.paterva.maltego.ui.graph.run.GlobalContextRunProvider;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class TransformRunProvider
extends GlobalContextRunProvider {
    private static final String FAVORITES = "Favorites";
    private static final String FAVORITES_LAF_PREFIX = "transforms-item-fav";
    private static final String ALL = "All Transforms";
    private static final String ALL_LAF_PREFIX = "transforms-item-all-tx";
    private static final String OTHER = "Other";
    private final Map<String, TransformRunItem> _itemCache = new HashMap<String, TransformRunItem>();
    private final Set<RunnableItem> _favorites = new HashSet<RunnableItem>();

    public TransformRunProvider() {
        TransformRunner.getDefault().addPropertyChangeListener((PropertyChangeListener)new TransformRunnerListener());
        TransformFavorites.getDefault().addPropertyChangeListener((PropertyChangeListener)new TransformFavoritesListener());
        RepositoriesListener listener = new RepositoriesListener();
        TransformServerRegistry.getDefault().addRepositoryListener((RepositoryListener)listener);
        TransformSetRepository.getDefault().addRepositoryListener((RepositoryListener)listener);
        try {
            TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
            for (String repo : TransformRepositoryRegistry.ALL) {
                registry.getOrCreateRepository(repo).addRepositoryListener((RepositoryListener)listener);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.updateItems();
        HubSeedRegistry.getDefault().getSeeds(false);
        TransformSelector.getDefault().getAlwaysOnTransforms();
    }

    public int getPosition() {
        return 100;
    }

    public void run(List<RunProviderItem> items, GraphID graphID, Set<EntityID> entities) {
        Set<TransformDefinition> transforms = TransformRunProvider.getTransforms(items);
        if (!transforms.isEmpty()) {
            TransformRequestProcessor.getDefault().runTransforms(transforms, null, graphID, entities, transforms.size() > 1);
        }
    }

    protected void updateFavorites() {
        ArrayList<RunnableItem> favorites = new ArrayList<RunnableItem>(this._favorites);
        Collections.sort(favorites, new RunProviderItemComparator());
        RunFavorites.getDefault().setFavorites((RunProvider)this, favorites);
    }

    protected List<RunProviderItem> createItems(String component, GraphID graphID, Set<EntityID> entities) {
        this._favorites.clear();
        if (graphID == null || entities == null || entities.isEmpty() || !A.B()) {
            return Collections.EMPTY_LIST;
        }
        Set<TransformDefinition> transforms = TransformSelector.getDefault().getTransforms(graphID, entities);
        TransformServerRegistry txServerRegistry = TransformServerRegistry.getDefault();
        Iterator<TransformDefinition> i = transforms.iterator();
        while (i.hasNext()) {
            TransformDefinition tx = i.next();
            if (txServerRegistry.exists(tx.getName(), true)) continue;
            i.remove();
        }
        String filterText = this.getFilterText(component);
        if (!StringUtilities.isNullOrEmpty((String)filterText)) {
            return this.toFilteredItems(filterText.toLowerCase(), transforms);
        }
        return this.toItems(transforms);
    }

    private List<RunProviderItem> toFilteredItems(String filterText, Set<TransformDefinition> transforms) {
        List<Object> rootItems = (transforms = this.filter(filterText, transforms)).isEmpty() ? Collections.singletonList(new NoTransformsItem()) : this.createTransformRunItems(transforms);
        TransformsItem transformsItem = new TransformsItem(rootItems);
        return Collections.singletonList(transformsItem);
    }

    private Set<TransformDefinition> filter(String filterText, Set<TransformDefinition> transforms) {
        return transforms.stream().filter(transform -> this.filterKeepTransform(filterText, (TransformDefinition)transform)).collect(Collectors.toSet());
    }

    private boolean filterKeepTransform(String filterText, TransformDefinition transform) {
        String displayName = transform.getDisplayName();
        return displayName != null && displayName.toLowerCase().contains(filterText);
    }

    private List<RunProviderItem> toItems(Set<TransformDefinition> transforms) {
        ArrayList<Object> rootItems = new ArrayList<Object>();
        if (transforms.isEmpty()) {
            rootItems.add((Object)new NoTransformsItem());
        } else {
            ArrayList<RunProviderItem> categoryItems = new ArrayList<RunProviderItem>();
            HashSet<TransformDefinition> noCategoryTransforms = new HashSet<TransformDefinition>(transforms);
            SearchAwareItemComparator comparator = new SearchAwareItemComparator();
            Set<TransformSet> localTxSets = this.groupTransforms("Local", transforms, noCategoryTransforms, categoryItems, comparator, this::getSets, LocalTransformsItem::new);
            Set<TransformSet> genTxSets = this.groupTransforms("Generated", transforms, noCategoryTransforms, categoryItems, comparator, this::getGeneratedSets, GeneratedTransformsItem::new);
            HashMap<TransformSet, HashSet<Object>> hubSeedsForSets = new HashMap<TransformSet, HashSet<Object>>();
            HubSeedRegistry hubRegistry = HubSeedRegistry.getDefault();
            HubSeeds hubSeeds = hubRegistry.getSeeds(false);
            for (Object hubSeed : hubSeeds.getSeeds()) {
                Set set = hubRegistry.getTransforms((HubSeedDescriptor)hubSeed);
                set.retainAll(transforms);
                if (set.isEmpty()) continue;
                noCategoryTransforms.removeAll(set);
                ArrayList<TransformSetItem> hubRunItems = new ArrayList<TransformSetItem>();
                TransformSets hubSets = this.getSets(set);
                for (Map.Entry entrySet : hubSets.entrySet()) {
                    TransformSet set2 = (TransformSet)entrySet.getKey();
                    Set setTransforms = (Set)entrySet.getValue();
                    hubRunItems.add(this.createSetRunItem(set2.getName(), setTransforms, true, false));
                    HashSet<Object> setSeeds = (HashSet<Object>)hubSeedsForSets.get(set2);
                    if (setSeeds == null) {
                        setSeeds = new HashSet<Object>();
                        hubSeedsForSets.put(set2, setSeeds);
                    }
                    setSeeds.add(hubSeed);
                }
                Collections.sort(hubRunItems, comparator);
                hubRunItems.add(0, this.createSetRunItem(ALL, set, false, true, ALL_LAF_PREFIX));
                Set<TransformDefinition> favs = this.getFavorites(set);
                if (!favs.isEmpty()) {
                    hubRunItems.add(0, this.createSetRunItem(FAVORITES, favs, false, true, FAVORITES_LAF_PREFIX));
                }
                if (hubRunItems.size() == 1) {
                    categoryItems.add((RunProviderItem)new TransformHubItem((HubSeedDescriptor)hubSeed, ((TransformSetItem)((Object)hubRunItems.get(0))).getChildren()));
                    continue;
                }
                categoryItems.add((RunProviderItem)new TransformHubItem((HubSeedDescriptor)hubSeed, hubRunItems));
            }
            ArrayList<TransformSetItem> multiCategorySets = new ArrayList<TransformSetItem>();
            for (Map.Entry entry : hubSeedsForSets.entrySet()) {
                TransformSet set = (TransformSet)entry.getKey();
                Set setHubSeeds = (Set)entry.getValue();
                if (setHubSeeds.size() + (localTxSets.contains(set) ? 1 : 0) + (genTxSets.contains(set) ? 1 : 0) <= 1) continue;
                Set setTransforms = set.getIntersection(transforms);
                multiCategorySets.add(this.createSetRunItem(set.getName(), setTransforms, true, false));
            }
            Collections.sort(multiCategorySets, comparator);
            if (categoryItems.size() == 1 && multiCategorySets.isEmpty() && noCategoryTransforms.isEmpty()) {
                TransformCategoryItem hubItem = (TransformCategoryItem)((Object)categoryItems.get(0));
                rootItems.addAll(hubItem.getChildren());
            } else {
                rootItems.addAll(categoryItems);
                rootItems.addAll(multiCategorySets);
                rootItems.add(0, (Object)this.createSetRunItem(ALL, transforms, false, true, ALL_LAF_PREFIX));
                Set<TransformDefinition> favs = this.getFavorites(transforms);
                if (!favs.isEmpty()) {
                    rootItems.add(0, (Object)this.createSetRunItem(FAVORITES, favs, false, true, FAVORITES_LAF_PREFIX));
                }
            }
        }
        TransformsItem transformsItem = new TransformsItem(rootItems);
        return Collections.singletonList(transformsItem);
    }

    private Set<TransformSet> groupTransforms(String repository, Set<TransformDefinition> transforms, Set<TransformDefinition> noCategoryTransforms, List<RunProviderItem> categoryItems, RunProviderItemComparator comparator, SetsFunction setsFunction, CategoryItemFunction categoryItemFunction) {
        HashSet<TransformSet> txSets = new HashSet<TransformSet>();
        try {
            TransformRepository repo = TransformRepositoryRegistry.getDefault().getOrCreateRepository(repository);
            HashSet<TransformDefinition> repoTransforms = new HashSet<TransformDefinition>(repo.getAll());
            repoTransforms.retainAll(transforms);
            if (!repoTransforms.isEmpty()) {
                noCategoryTransforms.removeAll(repoTransforms);
                ArrayList<TransformSetItem> runItems = new ArrayList<TransformSetItem>();
                TransformSets sets = (TransformSets)setsFunction.apply(repoTransforms);
                for (Map.Entry entrySet : sets.entrySet()) {
                    TransformSet set = (TransformSet)entrySet.getKey();
                    Set setTransforms = (Set)entrySet.getValue();
                    runItems.add(this.createSetRunItem(set.getName(), setTransforms, true, false));
                    txSets.add(set);
                }
                Collections.sort(runItems, comparator);
                runItems.add(0, this.createSetRunItem(ALL, repoTransforms, false, true, ALL_LAF_PREFIX));
                Set<TransformDefinition> favs = this.getFavorites(repoTransforms);
                if (!favs.isEmpty()) {
                    runItems.add(0, this.createSetRunItem(FAVORITES, favs, false, true, FAVORITES_LAF_PREFIX));
                }
                ArrayList<TransformRunItem> children = new ArrayList<TransformRunItem>(runItems.size() != 1 ? runItems : ((TransformSetItem)((Object)runItems.get(0))).getChildren());
                for (TransformDefinition repoTransform : repoTransforms) {
                    if (!"generated.global.search".equals(repoTransform.getName())) continue;
                    TransformRunItem runItem = new TransformRunItem(repoTransform.getName());
                    children.add(runItem);
                }
                TransformCategoryItem categoryItem = (TransformCategoryItem)((Object)categoryItemFunction.apply(children));
                categoryItems.add((RunProviderItem)categoryItem);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return txSets;
    }

    private Set<TransformDefinition> getFavorites(Set<TransformDefinition> transforms) {
        HashSet<TransformDefinition> favs = new HashSet<TransformDefinition>();
        for (TransformDefinition transform : transforms) {
            if (!transform.isFavorite()) continue;
            favs.add(transform);
        }
        return favs;
    }

    private TransformSets getSets(Set<TransformDefinition> transforms) {
        TransformSets sets = new TransformSets();
        for (TransformSet set : TransformSetRepository.getDefault().allSets()) {
            Set setTransforms = set.getIntersection(transforms);
            if (setTransforms.isEmpty()) continue;
            sets.put(set, setTransforms);
        }
        return sets;
    }

    private TransformSets getGeneratedSets(Set<TransformDefinition> transforms) {
        TransformSets sets = new TransformSets();
        for (TransformDefinition transform : transforms) {
            for (String set : transform.getDefaultSets()) {
                TransformSet transformSet = new TransformSet(set);
                HashSet<TransformDefinition> setTransforms = (HashSet<TransformDefinition>)sets.get(transformSet);
                if (setTransforms == null) {
                    setTransforms = new HashSet<TransformDefinition>();
                    sets.put(transformSet, setTransforms);
                }
                setTransforms.add(transform);
            }
        }
        return sets;
    }

    private TransformSetItem createSetRunItem(String name, Set<TransformDefinition> transforms, boolean hasSettings, boolean builtIn) {
        return this.createSetRunItem(name, transforms, hasSettings, builtIn, null);
    }

    private TransformSetItem createSetRunItem(String name, Set<TransformDefinition> transforms, boolean hasSettings, boolean builtIn, String lafPrefix) {
        ArrayList<TransformRunItem> transformRunItems = this.createTransformRunItems(transforms);
        String uniqueName = builtIn ? "maltego.builtin." + name : name;
        TransformSetItem setRunItem = new TransformSetItem(uniqueName, name, transformRunItems, hasSettings, lafPrefix);
        return setRunItem;
    }

    private ArrayList<TransformRunItem> createTransformRunItems(Set<TransformDefinition> transforms) {
        ArrayList<TransformRunItem> transformRunItems = new ArrayList<TransformRunItem>();
        for (TransformDefinition transform : transforms) {
            TransformRunItem runItem = this.getTransformRunItem(transform);
            if (runItem.isFavorite()) {
                this._favorites.add((RunnableItem)runItem);
            }
            transformRunItems.add(runItem);
        }
        Collections.sort(transformRunItems, new SearchAwareItemComparator());
        return transformRunItems;
    }

    private TransformRunItem getTransformRunItem(TransformDefinition transform) {
        TransformRunItem runItem = this._itemCache.get(transform.getName());
        if (runItem == null) {
            runItem = new TransformRunItem(transform.getName());
            this._itemCache.put(transform.getName(), runItem);
        }
        return runItem;
    }

    public static Set<TransformDefinition> getTransforms(List<RunProviderItem> items) {
        HashSet<TransformDefinition> transforms = new HashSet<TransformDefinition>();
        for (RunProviderItem item : items) {
            if (item instanceof TransformRunItem) {
                TransformDefinition transform = ((TransformRunItem)item).getTransform();
                if (transform == null) continue;
                transforms.add(transform);
                continue;
            }
            if (item instanceof TransformSetItem) {
                transforms.addAll(((TransformSetItem)item).getTransforms());
                continue;
            }
            if (!(item instanceof TransformsItem)) continue;
            transforms.addAll(((TransformsItem)item).getTransforms());
        }
        return transforms;
    }

    private static class SearchAwareItemComparator
    extends RunProviderItemComparator {
        private static final String PREFIX = "transform.generated.";
        private static final String SUFFIX = ".search";
        private static final String GLOBAL = "transform.generated.global.search";

        private SearchAwareItemComparator() {
        }

        public int compare(RunProviderItem o1, RunProviderItem o2) {
            boolean o2IsSearch;
            boolean o2IsGlobalSearch;
            boolean o1IsGlobalSearch = this.isGlobalSearch(o1);
            if (o1IsGlobalSearch != (o2IsGlobalSearch = this.isGlobalSearch(o2))) {
                return o1IsGlobalSearch ? -1 : 1;
            }
            boolean o1IsSearch = this.isSearch(o1);
            if (o1IsSearch != (o2IsSearch = this.isSearch(o2))) {
                return o1IsSearch ? -1 : 1;
            }
            return super.compare(o1, o2);
        }

        private boolean isGlobalSearch(RunProviderItem item) {
            return item.getName().equals(GLOBAL);
        }

        private boolean isSearch(RunProviderItem item) {
            String name = item.getName();
            return name.startsWith(PREFIX) && name.endsWith(SUFFIX);
        }
    }

    private static interface CategoryItemFunction
    extends Function<List<? extends RunProviderItem>, TransformCategoryItem> {
    }

    private static interface SetsFunction
    extends Function<Set<TransformDefinition>, TransformSets> {
    }

    private static class TransformSets
    extends HashMap<TransformSet, Set<TransformDefinition>> {
        private TransformSets() {
        }
    }

    private class RepositoriesListener
    implements RepositoryListener {
        private RepositoriesListener() {
        }

        public void onItemAdded(RepositoryEvent evt) {
            TransformRunProvider.this.updateItemsLater();
        }

        public void onItemChanged(RepositoryEvent evt) {
            TransformRunProvider.this.updateItemsLater();
        }

        public void onItemRemoved(RepositoryEvent evt) {
            TransformRunProvider.this.updateItemsLater();
        }
    }

    private class TransformFavoritesListener
    implements PropertyChangeListener {
        private TransformFavoritesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TransformRunProvider.this.updateItems();
        }
    }

    private class TransformRunnerListener
    implements PropertyChangeListener {
        private TransformRunnerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TransformRunnable runnable = (TransformRunnable)evt.getNewValue();
            SwingUtilities.invokeLater(() -> {
                boolean childrenChanged = false;
                TransformDefinition transform = runnable.getContext().getTransform();
                if ("transform.started".equals(evt.getPropertyName())) {
                    TransformRunItem runItem = TransformRunProvider.this.getTransformRunItem(transform);
                    runItem.addChild(runnable);
                    childrenChanged = true;
                } else if (!"transform.progress".equals(evt.getPropertyName()) && "transform.done".equals(evt.getPropertyName())) {
                    TransformRunItem runItem = TransformRunProvider.this.getTransformRunItem(transform);
                    runItem.removeChild(runnable);
                    childrenChanged = true;
                }
                if (childrenChanged) {
                    TransformRunProvider.this.fireItemsChanged();
                }
            });
        }
    }
}

