/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.slider;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.transform.runner.slider.TransformSliderTickProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

class TransformToolbar
extends JPanel {
    public static final String PROP_VALUE = "value";
    private final Color _defaultColor;
    private TransformSliderTickProvider _tickProvider;
    private int _value;
    private JSlider _slider;
    private JLabel _sliderLabel;

    public TransformToolbar() {
        this.initComponents();
        this._tickProvider = new TransformSliderTickProvider();
        this._defaultColor = this._sliderLabel.getForeground();
        LicenseManager.A().A(ignored -> this.update());
        this.update();
        this._slider.addChangeListener(ignored -> {
            if (!this._slider.getValueIsAdjusting()) {
                int tickIndex = this._slider.getValue() - 1;
                int lookUpValue = this._tickProvider.getValue(tickIndex);
                if (this._slider.getValue() == this._slider.getMaximum()) {
                    String msg = "You've selected to return up to " + lookUpValue + " entities. Are you sure you want to continue?";
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Are you sure...", 2);
                    if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                        this.setValue(lookUpValue);
                    } else {
                        this._slider.setValue(--tickIndex + 1);
                        this.setValue(this._tickProvider.getValue(tickIndex));
                    }
                } else {
                    this.setValue(lookUpValue);
                }
            }
        });
        this._slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TransformToolbar.this._slider.isEnabled()) {
                    String msg = "The transform result slider can not be changed in the free version of Maltego.\nPlease consider buying Maltego to unlock this and other features.";
                    NotifyDescriptor.Confirmation conf = new NotifyDescriptor.Confirmation((Object)msg, "Buy Maltego");
                    String buyOption = "Buy";
                    String cancelOption = "Cancel";
                    Object[] options = new String[]{buyOption, cancelOption};
                    conf.setOptions(options);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)conf);
                    if (buyOption.equals(result)) {
                        BrowseToUrl.buyXL(null);
                        ProductSelectionAction.perform();
                    }
                }
            }
        });
    }

    private void update() {
        Color color;
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>(this._tickProvider.getTickCount());
        Color fgColor = this._sliderLabel.getForeground();
        this._slider.setMaximum(this._tickProvider.getTickCount());
        for (int i = 0; i < this._tickProvider.getTickCount(); ++i) {
            color = this._tickProvider.getColor(i);
            labelTable.put(i + 1, this.createLabel(this._tickProvider.getLabel(i), color != null ? color : fgColor));
        }
        this._slider.setLabelTable(labelTable);
        A licenseMode = LicenseManager.A().A(false);
        if (!licenseMode.B()) {
            this._sliderLabel.setForeground(Color.gray);
            this._slider.setEnabled(false);
        } else {
            this._sliderLabel.setForeground(this._defaultColor);
            this._slider.setEnabled(true);
        }
        color = this._sliderLabel.getForeground();
        Enumeration elements = labelTable.elements();
        while (elements.hasMoreElements()) {
            Object nextElement = elements.nextElement();
            if (!(nextElement instanceof JComponent)) continue;
            JComponent component = (JComponent)nextElement;
            component.setForeground(color);
        }
        if (!licenseMode.B()) {
            this._slider.setValue(1);
            if (this._tickProvider != null) {
                this.setValue(this._tickProvider.getValue(0));
            }
        }
        boolean defaultFound = false;
        for (int i = 0; i < this._tickProvider.getTickCount() && !defaultFound; ++i) {
            if (this._tickProvider.getValue(i) != this._tickProvider.getDefault()) continue;
            this._slider.setValue(i + 1);
            this.setValue(this._tickProvider.getValue(i));
            defaultFound = true;
        }
        if (!defaultFound) {
            this._slider.setValue(1);
            this.setValue(this._tickProvider.getValue(0));
        }
    }

    public final void setValue(int value) {
        if (this._value != value) {
            int old = this._value;
            this._value = value;
            this._tickProvider.setDefault(this._value);
            this.firePropertyChange(PROP_VALUE, old, value);
        }
    }

    public int getValue() {
        return this._value;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension labelPrefSize = this._sliderLabel.getPreferredSize();
        int width = labelPrefSize.width + insets.left + insets.right;
        int height = labelPrefSize.height + this._slider.getPreferredSize().height + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    private JLabel createLabel(String text, Color color) {
        JLabel label = new JLabel(text);
        label.setFont(this._sliderLabel.getFont());
        label.setForeground(color);
        return label;
    }

    private void initComponents() {
        this._slider = new JSlider();
        this._sliderLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 1, 1));
        this.setToolTipText("");
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setName("");
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this._slider.setForeground(new Color(51, 51, 51));
        this._slider.setMajorTickSpacing(1);
        this._slider.setMaximum(4);
        this._slider.setMinimum(1);
        this._slider.setMinorTickSpacing(1);
        this._slider.setPaintLabels(true);
        this._slider.setPaintTicks(true);
        this._slider.setSnapToTicks(true);
        this._slider.setToolTipText("The number of results returned by the transform.");
        this._slider.setValue(1);
        this._slider.setMinimumSize(new Dimension(36, 52));
        this._slider.setOpaque(false);
        this._slider.setRequestFocusEnabled(false);
        this._slider.setValueIsAdjusting(true);
        this.add((Component)this._slider, "Center");
        this._sliderLabel.setForeground(new Color(70, 70, 70));
        this._sliderLabel.setHorizontalAlignment(0);
        this._sliderLabel.setText("Number of Results");
        this._sliderLabel.setHorizontalTextPosition(2);
        this.add((Component)this._sliderLabel, "First");
    }
}

