/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.inputs;

import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public class WebApiKeyHelper {
    private static final Logger LOGGER = Logger.getLogger(WebApiKeyHelper.class.getName());

    public static Map<TransformDefinition, DataSource> getWebApiKeys(Collection<? extends TransformDefinition> transforms) {
        Map<String, Set<TransformDefinition>> serviceNames = WebApiKeyHelper.getServiceNamesForTransforms(transforms);
        Map<PublicWebService, Set<TransformDefinition>> services = WebApiKeyHelper.getServices(serviceNames);
        WebApiKeyHelper.checkIfServicesNeedRefresh(services.keySet());
        Map<PublicWebService, String> keys = WebApiKeyHelper.getApiKeys(services.keySet());
        while (services.size() != keys.size()) {
            Object result = WebApiKeyHelper.showKeysMissingDialog(services, keys);
            if (!NotifyDescriptor.YES_OPTION.equals(result)) {
                if (NotifyDescriptor.NO_OPTION.equals(result)) {
                    WebApiKeyHelper.removeTransformsDependentOnServicesWithMissingApiKeys(transforms, keys, services);
                    break;
                }
                return null;
            }
            Action action = (Action)NamedServicesProvider.getConfigObject((String)"Actions/Tools/com-paterva-maltego-pws-AccountManagerAction.instance", Action.class);
            action.actionPerformed(new ActionEvent(WebApiKeyHelper.getSignInRequired(services, keys).keySet(), 0, null));
            keys = WebApiKeyHelper.getApiKeys(services.keySet());
        }
        return WebApiKeyHelper.translateToInputs(services, keys, transforms);
    }

    private static void checkIfServicesNeedRefresh(Set<PublicWebService> keys) {
        for (PublicWebService pws : keys) {
            pws.refreshAccessTokenIfNeeded();
        }
    }

    private static void removeTransformsDependentOnServicesWithMissingApiKeys(Collection<? extends TransformDefinition> inputTransforms, Map<PublicWebService, String> servicesAlreadySignedIn, Map<PublicWebService, Set<TransformDefinition>> allServices) {
        for (PublicWebService service : allServices.keySet()) {
            if (servicesAlreadySignedIn.containsKey(service)) continue;
            for (TransformDefinition missingTransform : allServices.get(service)) {
                if (!inputTransforms.contains(missingTransform)) continue;
                inputTransforms.remove(missingTransform);
            }
        }
    }

    private static Map<String, Set<TransformDefinition>> getServiceNamesForTransforms(Collection<? extends TransformDefinition> transforms) {
        HashMap<String, Set<TransformDefinition>> services = new HashMap<String, Set<TransformDefinition>>();
        for (TransformDefinition transformDefinition : transforms) {
            String service = transformDefinition.getAuthenticator();
            if (StringUtilities.isNullOrEmpty((String)service)) continue;
            HashSet<TransformDefinition> txsForService = (HashSet<TransformDefinition>)services.get(service);
            if (txsForService == null) {
                txsForService = new HashSet<TransformDefinition>();
                services.put(service, txsForService);
            }
            txsForService.add(transformDefinition);
        }
        return services;
    }

    private static Map<PublicWebService, String> getApiKeys(Set<PublicWebService> services) {
        HashMap<PublicWebService, String> keys = new HashMap<PublicWebService, String>();
        for (PublicWebService service : services) {
            Set signedIn = service.getSignedIn();
            if (signedIn.isEmpty()) continue;
            keys.put(service, (String)signedIn.iterator().next());
        }
        return keys;
    }

    private static Map<PublicWebService, Set<TransformDefinition>> getServices(Map<String, Set<TransformDefinition>> serviceNames) {
        HashMap<PublicWebService, Set<TransformDefinition>> services = new HashMap<PublicWebService, Set<TransformDefinition>>();
        PublicWebServices registry = PublicWebServices.getDefault();
        for (Map.Entry<String, Set<TransformDefinition>> entry : serviceNames.entrySet()) {
            String serviceName = entry.getKey();
            PublicWebService service = registry.get(serviceName);
            if (service == null) {
                LOGGER.log(Level.WARNING, "Public Web Service not registered: {0}", serviceName);
                continue;
            }
            services.put(service, entry.getValue());
        }
        return services;
    }

    private static Object showKeysMissingDialog(Map<PublicWebService, Set<TransformDefinition>> services, Map<PublicWebService, String> keys) {
        StringBuilder sb = new StringBuilder();
        services = WebApiKeyHelper.getSignInRequired(services, keys);
        for (Map.Entry<PublicWebService, Set<TransformDefinition>> entry : services.entrySet()) {
            PublicWebService service = entry.getKey();
            sb.append("The following transform(s) require you to sign in to ");
            sb.append(service.getDisplayName()).append(":\n");
            for (TransformDefinition transform : entry.getValue()) {
                sb.append("      ").append(transform.getDisplayName()).append("\n");
            }
            sb.append("\n");
        }
        sb.append("Do you want to open the Service Manager to sign in?");
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)sb.toString());
        nd.setTitle("Sign in required");
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private static Map<PublicWebService, Set<TransformDefinition>> getSignInRequired(Map<PublicWebService, Set<TransformDefinition>> services, Map<PublicWebService, String> keys) {
        HashMap<PublicWebService, Set<TransformDefinition>> signInRequiredServices = new HashMap<PublicWebService, Set<TransformDefinition>>();
        for (Map.Entry<PublicWebService, Set<TransformDefinition>> entry : services.entrySet()) {
            PublicWebService service = entry.getKey();
            if (keys.get(service) != null) continue;
            signInRequiredServices.put(service, entry.getValue());
        }
        return signInRequiredServices;
    }

    private static Map<TransformDefinition, DataSource> translateToInputs(Map<PublicWebService, Set<TransformDefinition>> services, Map<PublicWebService, String> keys, Collection<? extends TransformDefinition> transforms) {
        HashMap<TransformDefinition, DataSource> inputs = new HashMap<TransformDefinition, DataSource>();
        for (Map.Entry<PublicWebService, Set<TransformDefinition>> entry : services.entrySet()) {
            PublicWebService service = entry.getKey();
            String input = keys.get(service);
            if (StringUtilities.isNullOrEmpty((String)input)) {
                input = " ";
            }
            Set<TransformDefinition> txs = entry.getValue();
            for (TransformDefinition transform : txs) {
                DataSource dataSource = (DataSource)inputs.get(transform);
                if (dataSource == null && transforms.contains(transform)) {
                    dataSource = new DataSources.Map();
                    inputs.put(transform, dataSource);
                }
                if (dataSource == null) continue;
                String propertyName = service.getTransformInputPropertyName();
                PropertyDescriptor pd = new PropertyDescriptor(String.class, propertyName);
                dataSource.setValue(pd, (Object)input);
            }
        }
        return inputs;
    }
}

