/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.matching.FilterMatchingRuleDescriptor;
import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.merging.DefaultGraphMergerFactory;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.GraphMergerFactory;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.transform.runner.api.impl.TransformBatchResult;
import com.paterva.maltego.transform.runner.api.impl.TransformMergeSettings;
import com.paterva.maltego.transform.runner.api.impl.TransformResultBatcher;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.Exceptions;

public class DefaultTransformResultBatcher
implements TransformResultBatcher {
    private static final int DELAY_MIN = 3000;
    private static final Logger LOG = Logger.getLogger(DefaultTransformResultBatcher.class.getName());
    private static final GraphMergeStrategy GRAPH_MERGE_STRAT = new GraphMergeStrategy.PreferNew();
    private final GraphID _graphID;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final List<BatchedResults> _results = new ArrayList<BatchedResults>();
    private boolean _frozen = false;
    private Timer _timer;

    public DefaultTransformResultBatcher(GraphID graphID) {
        this._graphID = graphID;
    }

    public void setFrozen(boolean frozen) {
        this.checkEDT("setFrozen()");
        if (this._frozen != frozen) {
            LOG.log(Level.FINE, "Frozen: {0}", frozen);
            this._frozen = frozen;
            this.updateNow();
            this._changeSupport.firePropertyChange("freezableChanged", !frozen, frozen);
        }
    }

    public boolean isFrozen() {
        return this._frozen;
    }

    public synchronized boolean hasUpdates() {
        return !this._results.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNow() {
        this.checkEDT("updateNow()");
        LOG.fine("Update now");
        DefaultTransformResultBatcher defaultTransformResultBatcher = this;
        synchronized (defaultTransformResultBatcher) {
            if (this._timer != null) {
                this._timer.restart();
            }
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update() {
        block14: {
            this.checkEDT("update()");
            try {
                WindowUtil.showWaitCursor();
                if (this._results.isEmpty()) break block14;
                LOG.log(Level.FINE, "Updating: {0}", this._results.size());
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(this._graphID)) {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                    graphStore.beginUpdate();
                    try {
                        for (BatchedResults results : this._results) {
                            try {
                                this.applyGraphResult(results);
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        graphStore.endUpdate();
                    }
                }
                this._results.clear();
                this._changeSupport.firePropertyChange("updatePending", true, false);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    public synchronized void onTransformsStarted() {
        LOG.fine("Transforms started");
        if (this._timer == null) {
            int delay = 3000;
            A licenseMode = LicenseManager.A().A(false);
            if (licenseMode.B() && licenseMode.Q()) {
                delay += 10 * this.getEntityCount();
            }
            LOG.log(Level.FINE, "Delay: {0}", delay);
            this._timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DefaultTransformResultBatcher.this._frozen) {
                        LOG.fine("Timer update");
                        DefaultTransformResultBatcher.this.update();
                    }
                }
            });
            this._timer.setRepeats(true);
            this._timer.start();
        }
    }

    public synchronized void onTransformsDone() {
        this.checkEDT("onTransformsDone()");
        LOG.fine("Transforms done");
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
            LOG.fine("Transforms done update");
            if (!this._frozen) {
                this.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGraphClosed() {
        DefaultTransformResultBatcher defaultTransformResultBatcher = this;
        synchronized (defaultTransformResultBatcher) {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
            this._results.clear();
        }
        this._changeSupport.firePropertyChange("updatePending", true, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addTransformBatchResult(TransformBatchResult batchResult) {
        LOG.fine("Add transforms result");
        this.add(batchResult);
        this._changeSupport.firePropertyChange("updatePending", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(TransformBatchResult batchResult) {
        TransformResult txResult = batchResult.getTransformResult();
        GraphID resultGraphID = txResult.getGraphID();
        try {
            TransformRunContext ctx = batchResult.getTransformContext();
            BatchedResults results = this.getOrCreateResults(ctx);
            if (resultGraphID != null) {
                Map inputToOutputEntities = txResult.getInputToOutputEntities();
                GraphID tempGraphID = results.getTempGraphID();
                TransformDefinition transform = batchResult.getTransformContext().getTransform();
                boolean appended = false;
                TransformDefinition transformDefinition = transform;
                synchronized (transformDefinition) {
                    HashSet noMatchParts = new HashSet(inputToOutputEntities.keySet());
                    GraphMatchStrategy matcher = new GraphMatchStrategy((MatchingRuleDescriptor)new FilterMatchingRuleDescriptor(transform.getMatchingRule(), noMatchParts), (MatchingRuleDescriptor)(TransformMergeSettings.isMergeLinks() ? StatelessMatchingRuleDescriptor.Default : null));
                    GraphMerger graphMerger = new DefaultGraphMergerFactory().create(null, matcher, GRAPH_MERGE_STRAT, null, false, false, true);
                    graphMerger.setGraphs(tempGraphID, resultGraphID, null);
                    appended = graphMerger.append();
                }
                if (appended) {
                    results.addInputToOutputEntities(ctx, inputToOutputEntities);
                }
            }
            if (txResult.transformComplete()) {
                results.setComplete(ctx);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (resultGraphID != null) {
                this.close(resultGraphID);
            }
        }
    }

    private BatchedResults getOrCreateResults(TransformRunContext ctx) throws GraphStoreException {
        BatchedResults batchedResults = this._results.stream().filter(results -> results.isCompatible(ctx)).findAny().orElse(null);
        if (batchedResults == null) {
            GraphID graphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
            batchedResults = new BatchedResults(ctx.getTransformsContext(), ctx.getTransform(), graphID);
            this._results.add(batchedResults);
        }
        return batchedResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyGraphResult(BatchedResults results) throws GraphStoreException {
        GraphID tempGraphID = results.getTempGraphID();
        try {
            boolean appended;
            GraphMerger graphMerger;
            TransformDefinition transform;
            TransformDefinition transformDefinition = transform = results.getTransform();
            synchronized (transformDefinition) {
                GraphMatchStrategy matcher = new GraphMatchStrategy(transform.getMatchingRule(), (MatchingRuleDescriptor)(TransformMergeSettings.isMergeLinks() ? StatelessMatchingRuleDescriptor.Default : null));
                String doDescription = String.format("Transform %s result", transform.getDisplayName());
                String undoDescription = String.format("Delete/unmerge %s result", transform.getDisplayName());
                SimilarStrings descriptions = new SimilarStrings(doDescription, undoDescription);
                graphMerger = GraphMergerFactory.getDefault().create(descriptions, matcher, GRAPH_MERGE_STRAT, null, true, true, true);
                GraphID targetGraphID = results.getTargetGraphID();
                graphMerger.setGraphs(targetGraphID, tempGraphID, null);
                appended = graphMerger.append();
            }
            if (appended) {
                InputToOutputEntities inputToOutputEntities = results.getInputToOutputEntities();
                for (Map.Entry entry : inputToOutputEntities.entrySet()) {
                    TransformRunContext ctx2 = (TransformRunContext)entry.getKey();
                    Map inputsToOutputs = (Map)entry.getValue();
                    HashSet<MaltegoEntity> newEntities = new HashSet<MaltegoEntity>();
                    HashSet<MaltegoEntity> mergedEntities = new HashSet<MaltegoEntity>();
                    this.splitNewAndMerged(graphMerger.getEntityMapping().values(), graphMerger.getMatches().values(), inputsToOutputs.keySet(), newEntities, mergedEntities);
                    ctx2.getTransformsContext().onTransformResultAddedToTargetGraph(ctx2, newEntities, mergedEntities);
                }
            }
            results.getCompleted().forEach(ctx -> ctx.getTransformsContext().onTransformComplete(ctx));
        }
        finally {
            this.close(tempGraphID);
        }
    }

    private void close(GraphID memGraphID) {
        try {
            if (GraphStoreRegistry.getDefault().isExistingAndOpen(memGraphID)) {
                GraphLifeCycleManager.getDefault().fireGraphClosing(memGraphID);
                GraphStore memGraphStore = GraphStoreRegistry.getDefault().forGraphID(memGraphID);
                memGraphStore.close(true);
                GraphLifeCycleManager.getDefault().fireGraphClosed(memGraphID);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateCenters(GraphID targetGraphID, Map<EntityID, Set<EntityID>> inputToOutputEntities, Set<MaltegoEntity> newEntities) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(targetGraphID);
            GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
            GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
            for (Map.Entry<EntityID, Set<EntityID>> entry : inputToOutputEntities.entrySet()) {
                EntityID inputEntityID = entry.getKey();
                Set<EntityID> newEntityIDs = entry.getValue();
                Point center = layoutReader.getCenter(inputEntityID);
                if (center == null) continue;
                HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>();
                for (MaltegoEntity newEntity : newEntities) {
                    EntityID entityID = (EntityID)newEntity.getID();
                    if (!newEntityIDs.contains(entityID)) continue;
                    centers.put(entityID, center);
                }
                layoutWriter.setCenters(centers);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void splitNewAndMerged(Collection<? extends MaltegoEntity> all, Collection<? extends MaltegoEntity> matched, Collection<EntityID> inputEntities, Set<MaltegoEntity> nue, Set<MaltegoEntity> merged) {
        for (MaltegoEntity maltegoEntity : all) {
            if (inputEntities.contains(maltegoEntity.getID())) continue;
            if (matched.contains(maltegoEntity)) {
                merged.add(maltegoEntity);
                continue;
            }
            nue.add(maltegoEntity);
        }
    }

    private int getEntityCount() {
        int delay = 0;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            delay = structureReader.getEntityCount();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return delay;
    }

    private void checkEDT(String methodName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                throw new IllegalStateException(methodName + " may not be called outside the UI thread");
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class InputToOutputEntities
    extends HashMap<TransformRunContext, Map<EntityID, Set<EntityID>>> {
        private InputToOutputEntities() {
        }

        public void add(TransformRunContext context, Map<EntityID, List<EntityID>> inputToOutputEntities) {
            Args.notNull((Object)context, (String)"context");
            Args.notNull(inputToOutputEntities, (String)"inputToOutputEntities");
            HashMap<EntityID, HashSet<EntityID>> inputsToOutputs = (HashMap<EntityID, HashSet<EntityID>>)this.get(context);
            if (inputsToOutputs == null) {
                inputsToOutputs = new HashMap<EntityID, HashSet<EntityID>>();
                this.put(context, inputsToOutputs);
            }
            for (Map.Entry<EntityID, List<EntityID>> entry : inputToOutputEntities.entrySet()) {
                EntityID inputEntity = entry.getKey();
                List<EntityID> newOutputEntities = entry.getValue();
                HashSet<EntityID> outputEntities = (HashSet<EntityID>)inputsToOutputs.get(inputEntity);
                if (outputEntities == null) {
                    outputEntities = new HashSet<EntityID>();
                    inputsToOutputs.put(inputEntity, outputEntities);
                }
                outputEntities.addAll(newOutputEntities);
            }
        }
    }

    private static class BatchedResults {
        private final TransformsRunContext _ctx;
        private final TransformDefinition _transform;
        private final GraphID _tempGraphID;
        private final InputToOutputEntities _inputToOutputEntities = new InputToOutputEntities();
        private final Set<TransformRunContext> _complete = new HashSet<TransformRunContext>();

        public BatchedResults(TransformsRunContext ctx, TransformDefinition transform, GraphID tempGraphID) {
            this._ctx = ctx;
            this._transform = transform;
            this._tempGraphID = tempGraphID;
        }

        public GraphID getTargetGraphID() {
            return this._ctx.getTargetGraphID();
        }

        public TransformsRunContext getCtx() {
            return this._ctx;
        }

        public TransformDefinition getTransform() {
            return this._transform;
        }

        public GraphID getTempGraphID() {
            return this._tempGraphID;
        }

        public boolean isComplete(TransformRunContext context) {
            return this._complete.contains(context);
        }

        public void setComplete(TransformRunContext context) {
            this._complete.add(context);
        }

        public Set<TransformRunContext> getCompleted() {
            return this._complete;
        }

        public boolean isCompatible(TransformRunContext ctx) {
            return this.getTargetGraphID().equals((Object)ctx.getTargetGraphID()) && this.getTransform().equals(ctx.getTransform());
        }

        public void addInputToOutputEntities(TransformRunContext context, Map<EntityID, List<EntityID>> inputToOutputEntities) {
            this._inputToOutputEntities.add(context, inputToOutputEntities);
        }

        public InputToOutputEntities getInputToOutputEntities() {
            return this._inputToOutputEntities;
        }
    }
}

