/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.TransformMessageWindow;
import com.paterva.maltego.transform.runner.api.TransformMessageCacheManager;
import com.paterva.maltego.transform.runner.impl.SelectTransformEntitiesListener;
import com.paterva.maltego.transform.runner.impl.TransformFilterOutputPanel;
import com.paterva.maltego.transform.runner.impl.TransformFilterSettings;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.output.MessageChunk;
import com.paterva.maltego.util.output.MessageLinkListener;
import com.paterva.maltego.util.output.OutputMessage;
import com.paterva.maltego.util.ui.output.PrintMessage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class DefaultTransformMessageWindow
extends TransformMessageWindow {
    private WeakReference<InputOutput> _io;

    @Override
    public void write(TransformMessage.Severity severity, String message) {
        InputOutput io = this.getIO();
        try {
            IOColorPrint.print((InputOutput)io, (CharSequence)(message + "\n"), (Color)DefaultTransformMessageWindow.getColor(severity));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void writeWithEntities(TransformMessage.Severity severity, String message, GraphID graphID, Map<EntityID, MaltegoEntity> inputEntities) {
        InputOutput io = this.getIO();
        boolean display = false;
        switch (severity) {
            case Debug: {
                display = TransformFilterSettings.isShowDebug();
                break;
            }
            case Info: {
                display = TransformFilterSettings.isShowInfo();
                break;
            }
            case Warning: {
                display = TransformFilterSettings.isShowWarning();
                break;
            }
            case Error: {
                display = TransformFilterSettings.isShowError();
            }
        }
        if (display && !inputEntities.isEmpty()) {
            SelectTransformEntitiesListener listener = new SelectTransformEntitiesListener(graphID, inputEntities.keySet());
            String description = GraphTransactionHelper.getDescriptionForEntities((GraphID)graphID, inputEntities.values(), (boolean)false);
            OutputMessage msg = new OutputMessage();
            String trim = message.trim();
            trim = trim.replaceAll("\\.(?=\\s*$)", "");
            msg.addChunk(new MessageChunk(trim + " (from "));
            if (description.matches("^entity .+$")) {
                String entityStr = "entity ";
                msg.addChunk(new MessageChunk(entityStr));
                description = description.substring(entityStr.length());
            }
            msg.addChunk(new MessageChunk(description, (MessageLinkListener)listener));
            msg.addChunk(new MessageChunk(")"));
            try {
                PrintMessage.printMessage((OutputMessage)msg, (Color)DefaultTransformMessageWindow.getColor(severity), (InputOutput)io, (Color)DefaultTransformMessageWindow.getColor(severity));
                io.getOut().println();
            }
            catch (IOException | NumberFormatException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private synchronized InputOutput getIO() {
        InputOutput io = null;
        if (this._io != null) {
            io = (InputOutput)this._io.get();
        }
        if (io == null) {
            io = IOProvider.getDefault().getIO("Transform Output", new Action[]{new TransformOutputFilterAction(), new TransformOutputClearAction()});
            io.select();
            try {
                io.getOut().reset();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this._io = new WeakReference<InputOutput>(io);
        }
        return io;
    }

    public static Color getColor(TransformMessage.Severity severity) {
        switch (severity) {
            case Debug: {
                return Color.lightGray;
            }
            case Info: {
                return Color.darkGray;
            }
            case Warning: {
                return Color.decode("#F7A009");
            }
            case Error: {
                return UIManager.getLookAndFeelDefaults().getColor("7-red");
            }
        }
        return Color.black;
    }

    public class TransformOutputClearAction
    extends AbstractAction {
        public TransformOutputClearAction() {
            this.putValue("Name", "Clear Transform Messages");
            this.putValue("ShortDescription", "Clear the transform messages");
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"com/paterva/maltego/transform/runner/resources/Clear.png", (boolean)true));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputOutput io = DefaultTransformMessageWindow.this.getIO();
            try {
                io.getOut().reset();
                TransformMessageCacheManager.getDefault().clear();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public class TransformOutputFilterAction
    extends AbstractAction {
        public TransformOutputFilterAction() {
            this.putValue("Name", "Filter Transform Messages");
            this.putValue("ShortDescription", "Choose the types of transform messages to display");
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"com/paterva/maltego/collab/resources/Filter.png", (boolean)true));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransformFilterOutputPanel panel = new TransformFilterOutputPanel();
            panel.setShowDebug(TransformFilterSettings.isShowDebug());
            panel.setShowInfo(TransformFilterSettings.isShowInfo());
            panel.setShowWarning(TransformFilterSettings.isShowWarning());
            panel.setShowError(TransformFilterSettings.isShowError());
            DialogDescriptor nd = new DialogDescriptor((Object)panel, "Choose messages to display");
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                TransformFilterSettings.setShowDebug(panel.isShowDebug());
                TransformFilterSettings.setShowInfo(panel.isShowInfo());
                TransformFilterSettings.setShowWarning(panel.isShowWarning());
                TransformFilterSettings.setShowError(panel.isShowError());
            }
        }
    }
}

