/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.api.TransformMessageCache;
import com.paterva.maltego.transform.runner.api.TransformMessageCacheManager;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.GraphViewRegistry;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import y.view.Graph2D;

public class DefaultTransformMessageCacheManager
extends TransformMessageCacheManager {
    private static final Logger LOG = Logger.getLogger(DefaultTransformMessageCacheManager.class.getName());
    private final Timer timer = new Timer(3000, __ -> this.onTimer());

    public void handle(TransformRunContext ctx, MaltegoEntity inputEntity, List<TransformMessage> messages) {
    }

    public void clear() {
        GraphViewCookie cookie;
        TransformMessageCache.getInstance().getMessages().clear();
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null) {
            cookie.getGraphView().getViewGraph().updateViews();
        }
    }

    private void handledInEdt(TransformRunContext ctx, MaltegoEntity inputEntity, List<TransformMessage> messages) {
        try {
            if (messages != null && !messages.isEmpty()) {
                GraphID graphID = ctx.getTargetGraphID();
                EntityID entityID = (EntityID)inputEntity.getID();
                this.cacheMessages(graphID, entityID, messages);
                this.logMessages();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void cacheMessages(GraphID graphID, EntityID entityID, List<TransformMessage> messages) throws GraphStoreException {
        if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
            List<TransformMessage> entityMsgs = this.getEntityMessages(graphID, entityID);
            entityMsgs.addAll(messages);
        }
    }

    private void onTimer() {
        try {
            Iterator itr = TransformMessageCache.getInstance().getMessages().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                GraphID graphID = (GraphID)entry.getKey();
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                    Graph2D graph;
                    GraphView view;
                    TransformMessageCache.GraphMessages graphMsgs = (TransformMessageCache.GraphMessages)entry.getValue();
                    this.removeOldMessages(graphMsgs);
                    if (graphMsgs.isEmpty()) {
                        itr.remove();
                        this.logMessages();
                    }
                    if ((view = GraphViewRegistry.get((GraphID)graphID)) == null || (graph = view.getViewGraph()) == null) continue;
                    graph.updateViews();
                    continue;
                }
                itr.remove();
                this.logMessages();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void removeOldMessages(TransformMessageCache.GraphMessages graphMsgs) {
        int messageLifeTimeMillis = TransformMessageCache.getInstance().getMessageLifetimeMillis();
        long time = System.currentTimeMillis();
        Iterator mapItr = graphMsgs.entrySet().iterator();
        while (mapItr.hasNext()) {
            List messages = (List)((Map.Entry)mapItr.next()).getValue();
            Iterator itr = messages.iterator();
            while (itr.hasNext()) {
                TransformMessage msg = (TransformMessage)itr.next();
                if (time - msg.getTimestamp().getTime() <= (long)messageLifeTimeMillis) continue;
                itr.remove();
            }
            if (!messages.isEmpty()) continue;
            mapItr.remove();
        }
    }

    private List<TransformMessage> getEntityMessages(GraphID graphID, EntityID entityID) {
        Map cachedMsgs = TransformMessageCache.getInstance().getMessages();
        TransformMessageCache.GraphMessages graphMsgs = this.getGraphMessages(cachedMsgs, graphID);
        List<TransformMessage> entityMsgs = this.getEntityMessages(graphMsgs, entityID);
        return entityMsgs;
    }

    private TransformMessageCache.GraphMessages getGraphMessages(Map<GraphID, TransformMessageCache.GraphMessages> cachedMsgs, GraphID graphID) {
        TransformMessageCache.GraphMessages graphMsgs = cachedMsgs.get(graphID);
        if (graphMsgs == null) {
            graphMsgs = new TransformMessageCache.GraphMessages();
            cachedMsgs.put(graphID, graphMsgs);
        }
        return graphMsgs;
    }

    private List<TransformMessage> getEntityMessages(TransformMessageCache.GraphMessages graphMsgs, EntityID entityID) {
        LinkedList entityMsgs = (LinkedList)graphMsgs.get((Object)entityID);
        if (entityMsgs == null) {
            entityMsgs = new LinkedList();
            graphMsgs.put((Object)entityID, entityMsgs);
        }
        return entityMsgs;
    }

    private void logMessages() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Cached messages: " + TransformMessageCache.getInstance().getMessages());
        }
    }

    private /* synthetic */ void lambda$handle$1(TransformRunContext ctx, MaltegoEntity inputEntity, List messages) {
        this.handledInEdt(ctx, inputEntity, messages);
    }
}

