/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openide.util.Lookup;

public abstract class TransformRequestProcessor {
    public static TransformRequestProcessor getDefault() {
        TransformRequestProcessor manager = (TransformRequestProcessor)Lookup.getDefault().lookup(TransformRequestProcessor.class);
        if (manager == null) {
            manager = new TrivialTransformRequestProcessor();
        }
        return manager;
    }

    public void runTransform(TransformDefinition transform, TransformServerInfo server, GraphID graphID, Set<EntityID> entities) {
        this.runTransforms(Collections.singleton(transform), server, graphID, entities, false);
    }

    public abstract void runTransforms(Collection<? extends TransformDefinition> var1, TransformServerInfo var2, GraphID var3, Set<EntityID> var4, boolean var5);

    public void runTransforms(Collection<? extends TransformDefinition> transform, GraphID graphID, Set<EntityID> entities, boolean runAll) {
        this.runTransforms(transform, null, graphID, entities, runAll);
    }

    public void runTransform(TransformDefinition transform) {
        this.runTransform(transform, null, null, null);
    }

    public void runTransforms(Collection<TransformDefinition> transform, boolean runAll) {
        this.runTransforms(transform, null, null, runAll);
    }

    private static class TrivialTransformRequestProcessor
    extends TransformRequestProcessor {
        private TrivialTransformRequestProcessor() {
        }

        @Override
        public void runTransforms(Collection<? extends TransformDefinition> transform, TransformServerInfo server, GraphID graphID, Set<EntityID> entities, boolean runAll) {
            throw new UnsupportedOperationException("No TransformRequestProcessor registered");
        }
    }
}

