/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.transform.api.TransformMessage;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class TransformMessageWindow {
    public static TransformMessageWindow getDefault() {
        TransformMessageWindow window = (TransformMessageWindow)Lookup.getDefault().lookup(TransformMessageWindow.class);
        if (window == null) {
            window = new CommandlineMessageWindow();
        }
        return window;
    }

    public abstract void write(TransformMessage.Severity var1, String var2);

    public abstract void writeWithEntities(TransformMessage.Severity var1, String var2, GraphID var3, Map<EntityID, MaltegoEntity> var4);

    public void write(TransformMessage message) {
        this.write(message.getSeverity(), message.getText());
    }

    public void writeWithEntities(TransformMessage message, GraphID graphID, Map<EntityID, MaltegoEntity> inputEntities) {
        this.writeWithEntities(message.getSeverity(), message.getText(), graphID, inputEntities);
    }

    private static class CommandlineMessageWindow
    extends TransformMessageWindow {
        private CommandlineMessageWindow() {
        }

        @Override
        public void write(TransformMessage.Severity severity, String message) {
            System.out.println("Transform message: " + message);
        }

        @Override
        public void writeWithEntities(TransformMessage.Severity severity, String message, GraphID graphID, Map<EntityID, MaltegoEntity> inputEntities) {
            System.out.println("Transform message: " + message);
        }
    }
}

