/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api;

import com.paterva.maltego.licensing.rest.E;
import com.paterva.maltego.rest.MaltegoRestExchange;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.util.NormalException;
import java.net.URL;
import java.util.Map;

public class HubSeedRequests {
    private static final String THREAD_NAME = "Hub Install/Uninstall";
    private static final String HUB_INSTALL_URL = "https://dolores.paterva.com/maltego/hub/activate";
    private static final String HUB_INSTALL_XML_ROOT = "MaltegoHubInstall";
    private static final String HUB_UNINSTALL_URL = "https://dolores.paterva.com/maltego/hub/deactivate";
    private static final String HUB_UNINSTALL_XML_ROOT = "MaltegoHubUninstall";
    private static final String HUB_NAME = "HubName";
    private static final String HUB_DISPLAY_NAME = "HubDisplayName";
    private static final String HUB_URL = "HubUrl";

    public static void sendInstalled(HubSeedDescriptor hubItem) {
        HubSeedRequests.send(HUB_INSTALL_URL, HUB_INSTALL_XML_ROOT, hubItem);
    }

    public static void sendUninstalled(HubSeedDescriptor hubItem) {
        HubSeedRequests.send(HUB_UNINSTALL_URL, HUB_UNINSTALL_XML_ROOT, hubItem);
    }

    private static void send(String url, String xmlRoot, HubSeedDescriptor hubItem) {
        Runnable runnable = () -> {
            try {
                Map entries = E.A();
                entries.put(HUB_NAME, hubItem.getName());
                entries.put(HUB_DISPLAY_NAME, hubItem.getDisplayName());
                entries.put(HUB_URL, hubItem.getHubSeedUrl().getUrl());
                MaltegoRestExchange exchange = new MaltegoRestExchange(new URL(url), xmlRoot, entries);
                exchange.setCheckNonce(false);
                exchange.sendRequest();
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
        };
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.start();
    }
}

