/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.convert.DefaultStringConverter;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateRangePresets;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.FixedDateRange;
import com.paterva.maltego.typing.types.PresetsRelative;
import com.paterva.maltego.util.FastURL;
import java.text.DecimalFormat;
import java.util.Date;

public class ValueConverter {
    private ValueConverter() {
    }

    public static Object read(String value, Class destinationClass) throws Exception {
        TypeDescriptor type = TypeRegistry.getDefault().getType(destinationClass);
        if (type != null) {
            return type.convert(value);
        }
        return DefaultStringConverter.instance().convertFrom(value, destinationClass);
    }

    public static String write(Object value, Class valueClass) throws Exception {
        if (value instanceof DateRange) {
            return ValueConverter.toFixedDateRange((DateRange)value);
        }
        TypeDescriptor type = TypeRegistry.getDefault().getType(valueClass);
        if (type != null) {
            return type.convert(value);
        }
        return DefaultStringConverter.instance().convertTo(value, valueClass);
    }

    private static String toFixedDateRange(DateRange dateRange) {
        if (dateRange.isRelative()) {
            FixedDateRange fixedDateRange = DateRangePresets.getPresetDateRange((PresetsRelative)dateRange.getRelativeItem());
            dateRange = new DateRange(fixedDateRange);
        }
        return ValueConverter.formatDateRangeForTransforms(dateRange);
    }

    private static String formatDateRangeForTransforms(DateRange dateRange) {
        String from = ValueConverter.formatAsUnixTimeWithSubSeconds(dateRange.getFromDate());
        String to = ValueConverter.formatAsUnixTimeWithSubSeconds(dateRange.getToDate());
        return from + "-" + to;
    }

    private static String formatAsUnixTimeWithSubSeconds(DateTime dateTime) {
        DecimalFormat format = new DecimalFormat(".000");
        double unixTime = (double)dateTime.getTime() / 1000.0;
        String unixTimeStr = format.format(unixTime);
        return unixTimeStr;
    }

    public static String getTypeName(Class type) {
        if (type == String.class) {
            return "string";
        }
        if (type == Date.class) {
            return "date";
        }
        if (type == DateTime.class) {
            return "datetime";
        }
        if (type == DateRange.class) {
            return "daterange";
        }
        if (type == Integer.TYPE) {
            return "int";
        }
        if (type == Long.TYPE) {
            return "long";
        }
        if (type == Boolean.TYPE) {
            return "boolean";
        }
        if (type == Double.TYPE) {
            return "double";
        }
        if (type == FastURL.class) {
            return "url";
        }
        return null;
    }

    public static Class getType(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("string")) {
            return String.class;
        }
        if (name.equals("dateTime")) {
            return Date.class;
        }
        if (name.equals("date")) {
            return Date.class;
        }
        if (name.equals("datetime")) {
            return DateTime.class;
        }
        if (name.equals("daterange")) {
            return DateRange.class;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("url")) {
            return FastURL.class;
        }
        return null;
    }
}

