/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.transform.protocol.v2api.api.TransformInfo;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInputDescriptor;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListInputDescriptor;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListResponse;
import com.paterva.maltego.transform.protocol.v2api.remote.ValueConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class RemoteTransformTranslator {
    public TransformInfo translate(TransformListResponse.TransformDescriptor desc) throws Exception {
        TransformInfo info = new TransformInfo();
        info.setAuthor(desc.getAuthor());
        info.setDescription(desc.getDescription());
        info.setDisclaimer(desc.getDisclaimer());
        info.setDisplayName(desc.getDisplayName());
        info.setInputEntityType(desc.getInputEntity());
        info.setLocationRelevance(desc.getLocationRelevance());
        info.setMaxInputs(desc.getMaxInputs());
        info.setMaxOutputs(desc.getMaxOutputs());
        info.setName(desc.getName());
        info.setAuthenticator(desc.getAuthenticator());
        String[] outputs = new String[desc.getOuputEntities().size()];
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = desc.getOuputEntities().get((int)i).Name;
        }
        info.setOutputEntityTypes(outputs);
        info.setOwner(desc.getOwner());
        info.setVersion(desc.getVersion());
        this.copyInputs(info, desc.getInputs());
        return info;
    }

    private void copyInputs(TransformInfo info, Collection<TransformListInputDescriptor> descriptors) throws Exception {
        if (descriptors != null) {
            Set<TransformInputDescriptor> inputs = info.getInputs();
            for (TransformInputDescriptor input : this.translateInputs(descriptors)) {
                inputs.add(input);
            }
        }
    }

    public Set<TransformInputDescriptor> translateInputs(Collection<TransformListInputDescriptor> descriptors) throws Exception {
        LinkedHashSet<TransformInputDescriptor> inputs = new LinkedHashSet<TransformInputDescriptor>();
        if (descriptors != null) {
            for (TransformListInputDescriptor d : descriptors) {
                inputs.add(this.translate(d));
            }
        }
        return inputs;
    }

    private TransformInputDescriptor translate(TransformListInputDescriptor d) throws Exception {
        TransformInputDescriptor tid = new TransformInputDescriptor();
        tid.setName(d.getName());
        tid.setDisplayName(d.getDisplayName());
        tid.setRequired(!d.getOptional());
        tid.setPopup(d.isPopup());
        tid.setAuth(d.isAuth());
        Class type = ValueConverter.getType(d.getTypeName());
        if (type == null) {
            throw new Exception("Could not get class for xml type " + d.getTypeName());
        }
        tid.setType(type);
        if (d.getDefaultValue() != null) {
            tid.setDefaultValue(ValueConverter.read(d.getDefaultValue(), type));
        }
        return tid;
    }

    public Collection<TransformInfo> translate(Collection<TransformListResponse.TransformDescriptor> descriptors) throws Exception {
        ArrayList<TransformInfo> info = new ArrayList<TransformInfo>();
        for (TransformListResponse.TransformDescriptor d : descriptors) {
            info.add(this.translate(d));
        }
        return info;
    }
}

