/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryInfo;
import com.paterva.maltego.transform.protocol.v2api.api.TransformFindException;
import com.paterva.maltego.transform.protocol.v2api.api.TransformListInfo;
import com.paterva.maltego.transform.protocol.v2api.messaging.DiscoveryResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.ExceptionResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyException;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyFactory;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListResponse;
import com.paterva.maltego.transform.protocol.v2api.remote.AuthenticatorTranslator;
import com.paterva.maltego.transform.protocol.v2api.remote.DiscoveryInfoTranslator;
import com.paterva.maltego.transform.protocol.v2api.remote.MacroExpander;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformFindException;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformTranslator;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.util.Exceptions;

public class RemoteTransformSource {
    public DiscoveryInfo getDiscoveryInfo(String seedUrl, String sourceDescription, boolean httpsOnly) throws TransformFindException, CertificateNeedValidationException {
        try {
            DiscoveryResponse response;
            Proxy p = this.getProxy(sourceDescription);
            DiscoveryInfoTranslator tt = new DiscoveryInfoTranslator(seedUrl);
            MaltegoMessageWrapper wrapper = p.listTransforms(httpsOnly);
            DiscoveryResponse discoveryResponse = response = wrapper == null ? null : wrapper.getDiscoveryResponse();
            if (response == null) {
                ExceptionResponse exception;
                ExceptionResponse exceptionResponse = exception = wrapper == null ? null : wrapper.getExceptionResponse();
                if (exception == null) {
                    throw new RemoteTransformFindException("NULL response received");
                }
                throw new RemoteTransformFindException(exception);
            }
            this.replaceMacros(response, sourceDescription);
            try {
                return tt.translate(response);
            }
            catch (Exception ex) {
                throw new TransformFindException("Invalid message format: " + ex.getMessage(), ex);
            }
        }
        catch (ProxyException ex) {
            throw new TransformFindException("Error during remote execution: " + ex.getMessage(), ex);
        }
    }

    public TransformListInfo getTransforms(String sourceDescription) throws TransformFindException, CertificateNeedValidationException {
        try {
            Proxy p = this.getProxy(sourceDescription);
            MaltegoMessageWrapper wrapper = p.listTransforms(true);
            TransformListResponse response = wrapper.getListResponse();
            if (response == null) {
                ExceptionResponse exception = wrapper.getExceptionResponse();
                if (exception == null) {
                    throw new RemoteTransformFindException("NULL response received");
                }
                throw new RemoteTransformFindException(exception);
            }
            try {
                TransformListInfo info = new TransformListInfo();
                AuthenticatorTranslator at = new AuthenticatorTranslator();
                info.getOAuthAuthenticators().addAll(at.translateOAuth(response.getAuthenticators()));
                RemoteTransformTranslator tt = new RemoteTransformTranslator();
                info.getTransforms().addAll(tt.translate(response.getTransforms()));
                return info;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                throw new TransformFindException("Invalid message format", ex);
            }
        }
        catch (ProxyException ex) {
            throw new TransformFindException("Error during remote execution", ex);
        }
    }

    protected Proxy getProxy(String source) {
        return ProxyFactory.getDefault().createProxy(source);
    }

    private void replaceMacros(DiscoveryResponse response, String sourceDescription) {
        MacroExpander expander = new MacroExpander();
        try {
            URL url = new URL(sourceDescription);
            expander.add("${this}", url.getHost());
            expander.expand(response);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

