/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.proxy;

import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.transform.protocol.v2api.messaging.CanceledMessage;
import com.paterva.maltego.transform.protocol.v2api.messaging.ListTransformsCache;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageInputStream;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.MessagingHelper;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyException;
import com.paterva.maltego.transform.protocol.v2api.proxy.ProxySettings;
import com.paterva.maltego.transform.runner.api.TransformRunRequestDecorator;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLException;

public class HttpProxy
implements Proxy {
    public static boolean ALLOW_HTTP = false;
    private static final Logger LOG = Logger.getLogger(HttpProxy.class.getName());
    private String _transformApp;
    private ProxySettings _proxy;
    private static int count = 0;

    public HttpProxy(String transformApplication) {
        this(transformApplication, null);
    }

    public HttpProxy(String transformApplication, ProxySettings proxy) {
        this._transformApp = transformApplication;
        this._proxy = proxy;
    }

    public ProxySettings getProxySettings() {
        return this._proxy;
    }

    public void setProxySettings(ProxySettings settings) {
        this._proxy = settings;
    }

    private URL getRunRequestUrl(StringBuilder runRequestUrlStringBuilder) throws MalformedURLException {
        return new URL(TransformRunRequestDecorator.decorate((String)runRequestUrlStringBuilder.toString()));
    }

    private StringBuilder getRunRequestUrlStringBuilder(String transform, String key) {
        StringBuilder url = new StringBuilder(this._transformApp);
        url.append("?Command=_RUN&TransformToRun=");
        url.append(transform);
        if (!StringUtilities.isNullOrEmpty((String)key)) {
            url.append("&Key=");
            url.append(key);
        }
        Version version = Version.getCurrent();
        url.append("&OEM=");
        url.append(version.getOem());
        return url;
    }

    @Override
    public MaltegoMessageWrapper listTransforms(boolean httpsOnly) throws ProxyException, CertificateNeedValidationException {
        String url = this._transformApp + "?Command=_TRANSFORMS";
        MaltegoMessageWrapper wrapper = ListTransformsCache.get(url);
        if (wrapper == null && (wrapper = this.doGet(url, httpsOnly)) != null) {
            ListTransformsCache.put(url, wrapper);
        }
        return wrapper;
    }

    private MaltegoMessageWrapper doGet(String url, boolean httpsOnly) throws ProxyException, CertificateNeedValidationException {
        MaltegoMessageWrapper result = null;
        HttpAgent agent = null;
        try {
            LOG.log(Level.FINE, "Get from {0}", url);
            agent = new HttpAgent(new URL(url));
            agent.setConnectTimeout(30000);
            agent.setReadTimeout(30000);
            agent.setAcceptEncoding("gzip");
            Optional certOpt = Optional.ofNullable(null);
            CertificateTrustHandler.CertificateActions action = null;
            try {
                certOpt = agent.getServerCertificate(true);
            }
            catch (NoTrustedCertificateChainFoundException ex) {
                action = CertificateUtils.getCertActionFromException((NoTrustedCertificateChainFoundException)ex);
            }
            if (!certOpt.isPresent()) {
                if (action != null) {
                    switch (action) {
                        case ALLOW: {
                            break;
                        }
                        case BLOCK: 
                        case DATE_INVALID: {
                            throw new NoTrustedCertificateChainFoundException("No valid certificate chain found.");
                        }
                        case BLACKLISTED: {
                            MaltegoMessageWrapper maltegoMessageWrapper = new MaltegoMessageWrapper();
                            return maltegoMessageWrapper;
                        }
                        case SHOW_STORE: 
                        case SHOW_STORE_ATTACH_HOSTNAME: 
                        case SHOW_ATTACH_HOSTNAME: {
                            throw new CertificateNeedValidationException("Certificate for " + url + " will need to be validated first.");
                        }
                    }
                } else if (httpsOnly) {
                    this.throwNoHttps(url);
                }
            }
            agent.doGet();
            result = MessagingHelper.read(agent.getInputStream(), agent.getContentEncoding());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessagingHelper.toString(result));
            }
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.WARNING, "No trusted certificate chain found: {0}", ex.toString());
        }
        catch (CertificateNeedValidationException ex) {
            throw ex;
        }
        catch (IOException ex) {
            String msg = "HTTP error for " + url + ": " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
            }
            throw new ProxyException(msg, ex);
        }
        catch (Exception ex) {
            throw new ProxyException("Message parsing exception for " + url + ": " + ex.getMessage(), ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
        return result;
    }

    @Override
    public MaltegoMessageWrapper doTransform(String transform, MaltegoMessageWrapper input, String key, int timeout) throws ProxyException {
        Object msg;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--==<Transform input>==--\n{0}", MessagingHelper.toString(input));
        }
        MaltegoMessageWrapper result = null;
        HttpAgent agent = null;
        InputStream is = null;
        OutputStream os = null;
        StringBuilder urlStringBuilder = this.getRunRequestUrlStringBuilder(transform, key);
        try {
            URL url = this.getRunRequestUrl(urlStringBuilder);
            LOG.log(Level.FINE, "Transform request url: {0}", url);
            agent = new HttpAgent(url);
            agent.setAcceptEncoding("gzip");
            agent.setConnectTimeout(timeout);
            agent.setReadTimeout(timeout);
            msg = this.checkValidCertificate(agent);
            if (msg != null) {
                CanceledMessage canceledMessage = new CanceledMessage((String)msg);
                return canceledMessage;
            }
            boolean TEST_RESPONSE = false;
            os = agent.doPost("text/xml");
            MessagingHelper.write(input, os);
            String encoding = agent.getContentEncoding();
            is = encoding != null && encoding.contains("gzip") ? new GZIPInputStream(agent.getInputStream()) : agent.getInputStream();
            is = new MaltegoMessageInputStream(is);
            result = MessagingHelper.read(is);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "--==<Transform result>==--\n{0}", MessagingHelper.toString(result));
            }
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            msg = new CanceledMessage("Transform canceled, no trusted certificate chain found");
            return msg;
        }
        catch (IOException ex) {
            msg = "HTTP error: " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
            }
            throw new ProxyException((String)msg, ex);
        }
        catch (Exception ex) {
            throw new ProxyException("Message parsing exception: " + ex.getMessage(), ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(HttpProxy.class.getName()).log(Level.INFO, null, ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(HttpProxy.class.getName()).log(Level.INFO, null, ex);
                }
            }
        }
        return result;
    }

    private InputStream createTestResponse() {
        ByteArrayInputStream is;
        if (++count % 4 == 0) {
            is = new ByteArrayInputStream("<MaltegoMessage>\n   <MaltegoTransformResponseMessage>\n      <Entities>\n      </Entities>\n   </MaltegoTransformResponseMessage>\n</MaltegoMessage>".getBytes(StandardCharsets.UTF_8));
        } else {
            String msgType;
            switch (count % 4) {
                case 1: {
                    msgType = "FatalError";
                    break;
                }
                case 2: {
                    msgType = "PartialError";
                    break;
                }
                default: {
                    msgType = "Inform";
                }
            }
            is = new ByteArrayInputStream(("<MaltegoMessage>\n   <MaltegoTransformResponseMessage>\n      <Entities/>\n      <UIMessages>\n         <UIMessage MessageType=\"" + msgType + "\">This is a test message of type '" + msgType + "'\n---This is another line of the same message</UIMessage>\n      </UIMessages>\n   </MaltegoTransformResponseMessage>\n</MaltegoMessage>").getBytes(StandardCharsets.UTF_8));
        }
        return is;
    }

    @Override
    public int getLoad() throws ProxyException {
        HttpAgent agent = null;
        int result = 0;
        try {
            agent = new HttpAgent(new URL(this._transformApp + "?Command=_PERFORMANCE"));
            agent.doGet();
            String content = agent.getContentAsString();
            result = Integer.parseInt(content);
        }
        catch (IOException ex) {
            String msg = "HTTP error: " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
            }
            throw new ProxyException(msg, ex);
        }
        catch (Exception ex) {
            throw new ProxyException("Message parsing exception: " + ex.getMessage(), ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
        return result;
    }

    @Override
    public byte[] getMtzConfig() throws ProxyException {
        HttpAgent agent = null;
        byte[] result = null;
        try {
            agent = new HttpAgent(new URL(this._transformApp + "?Command=_CONFIG"));
            agent.doGet();
            result = agent.getContentAsBytes();
        }
        catch (IOException ex) {
            String msg = "HTTP error: " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
            }
            throw new ProxyException(msg, ex);
        }
        catch (Exception ex) {
            throw new ProxyException("Message parsing exception: " + ex.getMessage(), ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
        return result;
    }

    private String checkValidCertificate(HttpAgent agent) throws IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException {
        NoTrustedCertificateChainFoundException ntccfe = null;
        Optional certOpt = Optional.ofNullable(null);
        try {
            certOpt = agent.getServerCertificate();
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            ntccfe = ex;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw ex;
        }
        if (!certOpt.isPresent()) {
            if (ntccfe == null) {
                this.throwNoHttps(this._transformApp);
            } else {
                return "Transform canceled, server not trusted";
            }
        }
        return null;
    }

    private void throwNoHttps(String url) throws IOException {
        if (!ALLOW_HTTP) {
            if (url.toLowerCase().startsWith("https")) {
                throw new IOException("Server did not return a trusted certificate: " + CertificateUtils.stripUrl((String)url) + "\nPlease check your SSL configuration if you are using a proxy.\n\nAlternatively, t" + "he transform certificate is blocked because of an invalid date, Subject Alternative Names (SANs) and subject Common Name (CN) that do not match the queried URL, or the certificate is blacklisted in the \"Certificate Manager\" (find under the \"Transforms\" ribbon tab).");
            }
            throw new IOException("Only HTTPS (SSL/TLS) Transform Servers are allowed, but found: " + CertificateUtils.stripUrl((String)url));
        }
    }
}

