/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.api;

import com.paterva.maltego.transform.protocol.v2api.api.TransformCategory;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInputDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TransformInfo {
    private String _helpUrl;
    private String _name;
    private String _displayName;
    private String _description;
    private String _author;
    private String _owner;
    private String _disclaimer;
    private String _locationRelevance;
    private String _version;
    private String _inputEntity;
    private String _authenticator;
    private int _maxInputs;
    private int _maxOutputs;
    private TransformCategory _category;
    private boolean _enabled = true;
    private boolean _disclaimerAccepted = false;
    private String[] _outputEntities;
    private Set<TransformInputDescriptor> _inputs;
    private List _listeners = Collections.synchronizedList(new LinkedList());

    public TransformInfo() {
    }

    public TransformInfo(TransformInfo a) {
        this();
        this.setAuthor(a.getAuthor());
        this.setCategory(a.getCategory());
        this.setDescription(a.getDescription());
        this.setDisclaimer(a.getDisclaimer());
        this.setDisplayName(a.getDisplayName());
        this.setEnabled(a.getEnabled());
        this.setInputEntityType(a.getInputEntityType());
        this.setLocationRelevance(a.getLocationRelevance());
        this.setMaxInputs(a.getMaxInputs());
        this.setMaxOutputs(a.getMaxOutputs());
        this.setName(a.getName());
        this.setOwner(a.getOwner());
        this.setVersion(a.getVersion());
        this.setHelpUrl(a.getHelpUrl());
        this.setAuthenticator(a.getAuthenticator());
        String[] types = new String[a.getOutputEntityTypes().length];
        int i = 0;
        for (String s : a.getOutputEntityTypes()) {
            types[i++] = new String(s);
        }
        this.setOutputEntityTypes(types);
        for (TransformInputDescriptor d : a.getInputs()) {
            this.getInputs().add(d.clone());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof TransformInfo) {
            return this.equals((TransformInfo)o);
        }
        return false;
    }

    public boolean equals(TransformInfo info) {
        boolean isNameSame = this.getName().equalsIgnoreCase(info.getName());
        boolean isVersionSame = this.getVersion().equalsIgnoreCase(info.getVersion());
        boolean isDisplayNameSame = this.getDisplayName().compareTo(info.getDisplayName()) == 0;
        return isNameSame && isVersionSame && isDisplayNameSame;
    }

    public boolean hasDisclaimer() {
        return !StringUtilities.isNullOrEmpty((String)this.getDisclaimer());
    }

    public int hashCode() {
        return (this.getName() + this.getVersion()).hashCode();
    }

    public String toString() {
        return this.getName() + "(" + this.getVersion() + ")";
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._listeners.remove(pcl);
    }

    protected void firePropertyChange(String propertyName, Object old, Object nue) {
        PropertyChangeListener[] pcls = this._listeners.toArray(new PropertyChangeListener[0]);
        for (int i = 0; i < pcls.length; ++i) {
            pcls[i].propertyChange(new PropertyChangeEvent(this, propertyName, old, nue));
        }
    }

    public Set<TransformInputDescriptor> getInputs() {
        if (this._inputs == null) {
            this._inputs = new HashSet<TransformInputDescriptor>(5);
        }
        return this._inputs;
    }

    public String[] getOutputEntityTypes() {
        return this._outputEntities;
    }

    public void setOutputEntityTypes(String[] value) {
        this._outputEntities = value;
    }

    public String getHelpUrl() {
        return this._helpUrl;
    }

    public void setHelpUrl(String url) {
        this._helpUrl = url;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public TransformCategory getCategory() {
        return this._category;
    }

    public void setCategory(TransformCategory category) {
        this._category = category;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean value) {
        if (value != this._enabled) {
            this._enabled = value;
            this.firePropertyChange("enabled", !value, value);
        }
        this.firePropertyChange("enabled", !value, value);
    }

    public boolean isDisclaimerAccepted() {
        return this._disclaimerAccepted;
    }

    public void setDisclaimerAccepted(boolean value) {
        if (value != this._disclaimerAccepted) {
            this._disclaimerAccepted = value;
            this.firePropertyChange("disclaimerAccepted", !value, value);
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String value) {
        this._author = value;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setOwner(String value) {
        this._owner = value;
    }

    public String getDisclaimer() {
        return this._disclaimer;
    }

    public void setDisclaimer(String value) {
        this._disclaimer = value;
    }

    public String getLocationRelevance() {
        return this._locationRelevance;
    }

    public void setLocationRelevance(String value) {
        this._locationRelevance = value;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String value) {
        this._version = value;
    }

    public String getInputEntityType() {
        return this._inputEntity;
    }

    public void setInputEntityType(String value) {
        this._inputEntity = value;
    }

    public int getMaxInputs() {
        return this._maxInputs;
    }

    public void setMaxInputs(int value) {
        this._maxInputs = value;
    }

    public int getMaxOutputs() {
        return this._maxOutputs;
    }

    public void setMaxOutputs(int value) {
        this._maxOutputs = value;
    }

    public String getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this._authenticator = authenticator;
    }

    public boolean requiresInput() {
        for (TransformInputDescriptor desc : this.getInputs()) {
            if (!desc.requiresInput()) continue;
            return true;
        }
        return false;
    }
}

