/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.transform.protocol.v2api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v2api.EntityTranslator;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalField;
import com.paterva.maltego.transform.protocol.v2api.messaging.EntityDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

class V2MatchingRule
extends MatchingRule.TypeToPropertiesMap {
    V2MatchingRule() {
    }

    public void update(Collection<EntityDescriptor> entities, EntityRegistry registry) {
        TreeSet<String> done = new TreeSet<String>();
        for (EntityDescriptor entity : entities) {
            if (done.contains(entity.getTypeName())) continue;
            this.update(entity, registry);
            done.add(entity.getTypeName());
        }
    }

    private void update(EntityDescriptor entity, EntityRegistry registry) {
        ArrayList<String> strictFields = new ArrayList<String>();
        EntityTranslator translator = EntityTranslator.instance();
        String type = EntitySpecTranslator.getV3TypeName(entity.getTypeName());
        for (AdditionalField field : entity.getFields()) {
            if (!"strict".equals(field.getMatchingRule())) continue;
            strictFields.add(translator.v3PropertyName(entity, field.getName(), field.getName(), registry));
        }
        this.update(type, strictFields, strictFields.isEmpty());
    }

    public boolean equals(Object obj) {
        return obj == null || obj instanceof V2MatchingRule;
    }
}

