/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.PersistenceMode;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.protocol.v2api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v2api.RemoteTransformAdapterV2;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInfo;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInputDescriptor;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;

public class TransformTranslator {
    private final Set<TransformSet> _sets;

    public TransformTranslator(Set<TransformSet> sets) {
        this._sets = sets;
    }

    public TransformDescriptor translate(TransformInfo info, URL serverURL) {
        TransformDescriptor descriptor = new TransformDescriptor(RemoteTransformAdapterV2.class.getName(), TransformTranslator.getV3Name(info.getName()), null, TransformTranslator.translate(info.getInputs()));
        descriptor.setAbstract(false);
        descriptor.setAuthor(info.getAuthor());
        descriptor.setDescription(info.getDescription());
        descriptor.setDisclaimer(info.getDisclaimer());
        descriptor.setDisplayName(info.getDisplayName());
        descriptor.setHelpUrl(info.getHelpUrl());
        descriptor.setLocationRelevance(info.getLocationRelevance());
        descriptor.setOwner(info.getOwner());
        descriptor.setRequireDisplayInfo(false);
        descriptor.setTemplate(false);
        descriptor.setVersion(info.getVersion());
        descriptor.setVisibility(Visibility.Public);
        descriptor.setHelpText("Click on the link above for help about this transform");
        descriptor.setAuthenticator(info.getAuthenticator());
        descriptor.setStealthLevel(null);
        String entityType = EntitySpecTranslator.getV3TypeName(info.getInputEntityType());
        descriptor.setInputConstraint((Constraint)new EntityConstraint(entityType));
        for (String s : info.getOutputEntityTypes()) {
            descriptor.getOutputEntities().add(EntitySpecTranslator.getV3TypeName(s));
        }
        descriptor.setDefaultSets(this.findSets(descriptor.getName()));
        return descriptor;
    }

    private String[] findSets(String transform) {
        ArrayList<String> sets = new ArrayList<String>();
        for (TransformSet set : this._sets) {
            if (!set.contains(transform)) continue;
            sets.add(set.getName());
        }
        return sets.toArray(new String[sets.size()]);
    }

    public static String getV2Name(String v3Name) {
        return v3Name.substring(11);
    }

    public static String getV3Name(String v2Name) {
        return "paterva.v2." + v2Name;
    }

    public static DisplayDescriptorCollection translate(Set<TransformInputDescriptor> inputs) {
        DisplayDescriptorList descriptors = new DisplayDescriptorList();
        for (TransformInputDescriptor input : inputs) {
            TransformPropertyDescriptor dd = new TransformPropertyDescriptor(input.getType(), input.getName(), input.getDisplayName());
            dd.setDescription(input.getDescription());
            dd.setDefaultValue(input.getDefaultValue());
            dd.setHidden(false);
            dd.setNullable(!input.isRequired());
            dd.setPopup(input.isPopup());
            dd.setReadonly(false);
            dd.setAbstract(false);
            dd.setPersistence(PersistenceMode.Normal);
            dd.setVisibility(Visibility.Public);
            dd.setAuth(input.isAuth());
            descriptors.add((DisplayDescriptor)dd);
        }
        return descriptors;
    }
}

