/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.transform.descriptor.CompoundConstraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.protocol.v2api.AbstractTransformAdapterV2;
import com.paterva.maltego.transform.protocol.v2api.RemoteTransformRunner;
import com.paterva.maltego.transform.protocol.v2api.TransformRunnerV2;
import com.paterva.maltego.transform.protocol.v2api.TransformTranslator;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInput;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyFactory;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.FastURL;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;

public class RemoteTransformAdapterV2
extends AbstractTransformAdapterV2 {
    @Override
    protected TransformRunnerV2 runner(TransformRunContext ctx) throws TransformRunException {
        Args.notNull((Object)ctx, (String)"ctx");
        String target = ctx.getServerUrl().orElse(null);
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        TransformDefinition transform = ctx.getTransform();
        DataSource transformInputs = ctx.getTransformInputs();
        GraphID graphID = ctx.getTargetGraphID();
        EntityFactory factory = ctx.getEntityFactory();
        EntityRegistry registry = ctx.getEntityRegistry();
        String name = TransformTranslator.getV2Name(transform.getName());
        Proxy proxy = this.getProxy(target);
        TransformInput ti = this.createInput(target, (TransformDescriptor)transform, transformInputs);
        String forcedTypeName = this.getV2HackForcedTypeName((TransformDescriptor)transform);
        return new RemoteTransformRunner(graphID, (TransformDescriptor)transform, factory, registry, proxy, name, ti, forcedTypeName);
    }

    private String getV2HackForcedTypeName(TransformDescriptor transform) {
        Args.notNull((Object)transform, (String)"transform");
        String forcedTypeName = null;
        if (transform.getInputConstraint() instanceof CompoundConstraint) {
            Object obj;
            CompoundConstraint cc = (CompoundConstraint)transform.getInputConstraint();
            Iterator itr = cc.iterator();
            if (itr.hasNext() && (obj = itr.next()) instanceof EntityConstraint) {
                EntityConstraint ec = (EntityConstraint)obj;
                forcedTypeName = ec.getTypeName();
            }
        } else if (transform.getInputConstraint() instanceof EntityConstraint) {
            EntityConstraint ec = (EntityConstraint)transform.getInputConstraint();
            forcedTypeName = ec.getTypeName();
        }
        return forcedTypeName;
    }

    private TransformInput createInput(String target, TransformDescriptor transform, DataSource transformInputs) throws TransformRunException {
        Args.notNull((Object)target, (String)"target");
        Args.notNull((Object)transform, (String)"transform");
        Args.notNull((Object)transformInputs, (String)"transformInputs");
        try {
            TransformInput input = new TransformInput();
            FastURL targetUrl = new FastURL(target);
            targetUrl.getURL();
            TransformServerInfo server = TransformServerRegistry.getDefault().get(targetUrl);
            if (server == null) {
                throw new TransformRunException("No server found for target " + target);
            }
            input.setKey(server.getAuthentication().getToken(target));
            int limit = this.getLimit(transformInputs);
            input.setSoftLimit(limit);
            input.setHardLimit(limit);
            Map<String, Object> params = input.getTransformParameters();
            for (DisplayDescriptor dd : transform.getProperties()) {
                params.put(dd.getName(), transformInputs.getValue((PropertyDescriptor)dd));
            }
            return input;
        }
        catch (MalformedURLException ex) {
            throw new TransformRunException("Invalid URL: " + target);
        }
    }

    private Proxy getProxy(String target) {
        Proxy proxy = ProxyFactory.getDefault().createProxy(target);
        return proxy;
    }

    @Override
    protected boolean applyAdvancedProperties() {
        return true;
    }
}

