/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

class NotificationTranslator {
    public TransformMessage translate(TransformResponse.Notification from) {
        TransformMessage to = new TransformMessage(new Date(), this.translate(from.getType()), from.getValue());
        return to;
    }

    private TransformMessage.Severity translate(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (s.equals("Debug")) {
            return TransformMessage.Severity.Debug;
        }
        if (s.equals("Inform")) {
            return TransformMessage.Severity.Info;
        }
        if (s.equals("PartialError")) {
            return TransformMessage.Severity.Warning;
        }
        if (s.equals("FatalError")) {
            return TransformMessage.Severity.Error;
        }
        throw new IllegalArgumentException("Invalid type " + s);
    }

    public List<TransformMessage> translate(Collection<TransformResponse.Notification> from) {
        if (from == null || from.size() == 0) {
            return new ArrayList<TransformMessage>(0);
        }
        ArrayList<TransformMessage> results = new ArrayList<TransformMessage>(from.size());
        for (TransformResponse.Notification n : from) {
            results.add(this.translate(n));
        }
        return results;
    }
}

