/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.matching.MatchingRuleFactory;
import com.paterva.maltego.matching.TypeToPropertiesMapMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.protocol.v2api.TransformRunnerV2;
import com.paterva.maltego.transform.protocol.v2api.V2EntityMerger;
import com.paterva.maltego.transform.protocol.v2api.V2MatchingRuleDescriptor;
import com.paterva.maltego.transform.protocol.v2api.api.CodedTransformRunException;
import com.paterva.maltego.transform.runner.api.AbstractTransformAdapter;
import com.paterva.maltego.transform.runner.api.TransformCallback;
import com.paterva.maltego.transform.runner.api.TransformDoneMutex;
import com.paterva.maltego.transform.runner.api.TransformMessageCacheManager;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.transform.runner.api.impl.TransformMergeSettings;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public abstract class AbstractTransformAdapterV2
extends AbstractTransformAdapter {
    private static final Logger LOG = Logger.getLogger(AbstractTransformAdapterV2.class.getName());

    protected abstract TransformRunnerV2 runner(TransformRunContext var1) throws TransformRunException;

    protected abstract boolean applyAdvancedProperties();

    protected List<Cancellable> runAsync(TransformRunContext ctx) throws Exception {
        Args.notNull((Object)ctx, (String)"ctx");
        ArrayList<Cancellable> cancellables = new ArrayList<Cancellable>();
        Map inputEntities = ctx.getInputEntities();
        TransformRunnerV2 runner = this.runner(ctx);
        for (Map.Entry entry : inputEntities.entrySet()) {
            MaltegoEntity entity = (MaltegoEntity)entry.getValue();
            cancellables.add(runner.run(entity, (ResultHandler)this.getDoneMutex()));
        }
        return cancellables;
    }

    protected TransformDoneMutex createDoneMutex(TransformRunContext ctx) {
        Args.notNull((Object)ctx, (String)"ctx");
        return new ResultHandler(ctx);
    }

    protected TypeToPropertiesMapMatchingRuleDescriptor createMatchingRule(TransformRunContext context) {
        return new V2MatchingRuleDescriptor();
    }

    private static enum LinkDirection {
        INPUT_TO_OUTPUT("input-to-output"),
        OUTPUT_TO_INPUT("output-to-input"),
        BIDIRECTIONAL("bidirectional");

        private final String _value;

        private LinkDirection(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }

        public static LinkDirection parse(String value) {
            for (LinkDirection direction : LinkDirection.values()) {
                if (!direction.getValue().equalsIgnoreCase(value)) continue;
                return direction;
            }
            return null;
        }
    }

    private class ResultHandler
    extends TransformDoneMutex
    implements TransformRunnerV2.CallbackV2 {
        private final TransformRunContext _ctx;
        private final int _total;
        private int _complete;
        private String _lastError;
        private final Map<EntityID, MaltegoEntity> _inputEntitiesAll = new HashMap<EntityID, MaltegoEntity>();

        public ResultHandler(TransformRunContext ctx) {
            this._ctx = ctx;
            this._total = this._ctx.getInputEntities().size();
            this._complete = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exception(Exception e, MaltegoEntity inputEntity) {
            Args.notNull((Object)e, (String)"e");
            Args.notNull((Object)inputEntity, (String)"inputEntity");
            ResultHandler resultHandler = this;
            synchronized (resultHandler) {
                HashMap<EntityID, MaltegoEntity> inputEntities = new HashMap<EntityID, MaltegoEntity>();
                inputEntities.put((EntityID)inputEntity.getID(), inputEntity);
                if (!AbstractTransformAdapterV2.this.isCancelled()) {
                    TransformCallback cb = this._ctx.getCallback();
                    String message = e.getMessage();
                    if (!Utilities.compareObjects((Object)message, (Object)this._lastError)) {
                        if (e instanceof CodedTransformRunException) {
                            cb.resultReceived(TransformResult.nonInterruptingError((String)message, (int)((CodedTransformRunException)((Object)e)).getCode()));
                        } else {
                            cb.resultReceived(TransformResult.nonInterruptingError((String)message));
                        }
                    }
                    this._lastError = message;
                    String msg = "Transform " + this._ctx.getTransform().getDisplayName() + " returned with an error: " + message;
                    LOG.fine(msg);
                    cb.resultReceived(TransformResult.warning((String)msg));
                }
                ++this._complete;
                this.checkFinished(inputEntities);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void success(TransformRunnerV2.RunResultV2 result) {
            Args.notNull((Object)result, (String)"result");
            ResultHandler resultHandler = this;
            synchronized (resultHandler) {
                TypeToPropertiesMapMatchingRuleDescriptor matchingRule;
                TransformDefinition transform;
                MaltegoEntity inputEntity = result.getInput();
                EntityID inputEntityID = (EntityID)inputEntity.getID();
                if (AbstractTransformAdapterV2.this.isCancelled()) {
                    this.notify();
                    return;
                }
                TransformDefinition transformDefinition = transform = this._ctx.getTransform();
                synchronized (transformDefinition) {
                    matchingRule = AbstractTransformAdapterV2.this.updateMatchingRule(this._ctx, result.getEntities());
                    this._inputEntitiesAll.put(inputEntityID, inputEntity);
                }
                HashMap<EntityID, MaltegoEntity> inputEntities = new HashMap<EntityID, MaltegoEntity>();
                inputEntities.put(inputEntityID, inputEntity);
                TransformCallback cb = this._ctx.getCallback();
                List<TransformMessage> messages = result.getMessages();
                if (messages.size() > 0) {
                    TransformMessageCacheManager msgDisplayer = TransformMessageCacheManager.getDefault();
                    msgDisplayer.handle(this._ctx, inputEntity, messages);
                    cb.resultReceived(TransformResult.messages(messages, (MaltegoEntity)inputEntity));
                }
                Map<MaltegoEntity, DataSources.Map> entitiesAndLinkProps = this.extractLinkProperties(result.getEntities());
                Map<MaltegoEntity, List<MaltegoEntity>> mergedEntities = this.getMerged(result.getEntities(), (MatchingRuleDescriptor)matchingRule);
                this.convertNonProperties(mergedEntities.keySet());
                GraphID resultGraphID = this.buildResultGraph(inputEntity.createClone(), entitiesAndLinkProps, mergedEntities);
                int entityCount = result.getEntities().size();
                String msg = "Transform " + transform.getDisplayName() + " returned with " + entityCount + " entities.";
                LOG.fine(msg);
                cb.resultReceived(TransformResult.info((String)msg, (boolean)false));
                List outputEntities = entitiesAndLinkProps.keySet().stream().map(entity -> (EntityID)entity.getID()).collect(Collectors.toList());
                cb.resultReceived(TransformResult.progress((String)msg, (int)this.getProgressPercentage(), (GraphID)resultGraphID, (int)entityCount, (boolean)false, Collections.singletonMap(inputEntityID, outputEntities)));
                ++this._complete;
                this.checkFinished(this._inputEntitiesAll);
            }
        }

        private int getProgressPercentage() {
            return Math.min(100 * this._complete / this._total, 100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFinished(Map<EntityID, MaltegoEntity> inputEntities) {
            ResultHandler resultHandler = this;
            synchronized (resultHandler) {
                if (this._complete == this._total) {
                    String msg = "Transform " + this._ctx.getTransform().getDisplayName() + " done";
                    LOG.fine(msg);
                    this._ctx.getCallback().resultReceived(TransformResult.complete((String)msg));
                    this.notify();
                }
            }
        }

        private void convertNonProperties(Iterable<MaltegoEntity> entities) {
            for (MaltegoEntity entity : entities) {
                PropertyDescriptorCollection properties = entity.getProperties();
                ArrayList<PropertyDescriptor> toRemove = new ArrayList<PropertyDescriptor>();
                for (PropertyDescriptor property : properties) {
                    Object value;
                    String name = property.getName();
                    if ("notes#".equals(name)) {
                        if (AbstractTransformAdapterV2.this.applyAdvancedProperties() && (value = entity.getValue(property)) != null) {
                            entity.setNotes(value.toString());
                            entity.setShowNotes(Boolean.valueOf(true));
                        }
                        toRemove.add(property);
                    }
                    if (!"bookmark#".equals(name)) continue;
                    if (AbstractTransformAdapterV2.this.applyAdvancedProperties()) {
                        value = entity.getValue(property);
                        Integer bookmark = null;
                        if (value instanceof Integer) {
                            bookmark = (Integer)value;
                        } else if (value instanceof String) {
                            try {
                                bookmark = Integer.decode((String)value);
                            }
                            catch (NumberFormatException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        if (bookmark != null) {
                            entity.setBookmark(bookmark);
                        }
                    }
                    toRemove.add(property);
                }
                properties.removeAll(toRemove);
            }
        }

        private Map<MaltegoEntity, DataSources.Map> extractLinkProperties(Iterable<MaltegoEntity> entities) {
            HashMap<MaltegoEntity, DataSources.Map> entitiesAndLinkProps = new HashMap<MaltegoEntity, DataSources.Map>();
            for (MaltegoEntity entity : entities) {
                DataSources.Map linkProps = new DataSources.Map();
                PropertyDescriptorCollection properties = entity.getProperties();
                ArrayList<PropertyDescriptor> toRemove = new ArrayList<PropertyDescriptor>();
                for (PropertyDescriptor property : properties) {
                    String name = property.getName();
                    String prefix = "link#";
                    if (!name.startsWith("link#") || name.length() <= "link#".length()) continue;
                    if (AbstractTransformAdapterV2.this.applyAdvancedProperties()) {
                        name = name.substring("link#".length());
                        PropertyDescriptor pd = new PropertyDescriptor(property.getType(), name, property.getDisplayName());
                        pd.setHidden(property.isHidden());
                        pd.setNullable(property.isNullable());
                        pd.setReadonly(property.isReadonly());
                        linkProps.put((Object)pd, entity.getValue(property));
                    }
                    toRemove.add(property);
                }
                properties.removeAll(toRemove);
                entitiesAndLinkProps.put(entity, linkProps);
            }
            return entitiesAndLinkProps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GraphID buildResultGraph(MaltegoEntity input, Map<MaltegoEntity, DataSources.Map> entitiesAndLinkProps, Map<MaltegoEntity, List<MaltegoEntity>> mergedEntities) {
            int newEntityCount = 0;
            GraphID graphID = null;
            GraphStore graphStore = null;
            try {
                graphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
                graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                graphStore.beginUpdate();
                if (!entitiesAndLinkProps.isEmpty()) {
                    GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)input);
                }
                for (Map.Entry<MaltegoEntity, List<MaltegoEntity>> entry : mergedEntities.entrySet()) {
                    MaltegoEntity entity = entry.getKey();
                    List<MaltegoEntity> entities = entry.getValue();
                    GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)entity);
                    if (TransformMergeSettings.isMergeLinks()) {
                        entities = Collections.singletonList(entities.get(0));
                    }
                    for (MaltegoEntity originalEntity : entities) {
                        MaltegoLink linkCopy;
                        MaltegoLink link = this._ctx.getLinkFactory().createInstance(MaltegoLinkSpec.getTransformSpec(), true);
                        LinkDirection direction = LinkDirection.INPUT_TO_OUTPUT;
                        DataSources.Map linkProps = entitiesAndLinkProps.get(originalEntity);
                        for (Map.Entry property : linkProps.entrySet()) {
                            PropertyDescriptor pd = (PropertyDescriptor)property.getKey();
                            Object propertyValue = property.getValue();
                            if ("maltego.link.direction".equalsIgnoreCase(pd.getName())) {
                                if (!(propertyValue instanceof String)) continue;
                                direction = LinkDirection.parse((String)propertyValue);
                                continue;
                            }
                            link.setValue(pd, propertyValue);
                        }
                        TransformDefinition transform = this._ctx.getTransform();
                        PropertyDescriptorCollection properties = link.getProperties();
                        link.setValue(properties.get("maltego.link.transform.name"), (Object)transform.getName());
                        link.setValue(properties.get("maltego.link.transform.display-name"), (Object)transform.getDisplayName());
                        link.setValue(properties.get("maltego.link.transform.version"), (Object)transform.getVersion());
                        link.setValue(properties.get("maltego.link.transform.run-date"), (Object)new DateTime());
                        if (LinkDirection.INPUT_TO_OUTPUT.equals((Object)direction)) {
                            GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)link.createCopy(), (LinkEntityIDs)new LinkEntityIDs((EntityID)input.getID(), (EntityID)entity.getID()));
                            continue;
                        }
                        if (LinkDirection.OUTPUT_TO_INPUT.equals((Object)direction)) {
                            linkCopy = link.createCopy();
                            linkCopy.setReversed(Boolean.valueOf(true));
                            GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)linkCopy, (LinkEntityIDs)new LinkEntityIDs((EntityID)entity.getID(), (EntityID)input.getID()));
                            continue;
                        }
                        GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)link.createCopy(), (LinkEntityIDs)new LinkEntityIDs((EntityID)input.getID(), (EntityID)entity.getID()));
                        linkCopy = link.createCopy();
                        linkCopy.setReversed(Boolean.valueOf(true));
                        GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)linkCopy, (LinkEntityIDs)new LinkEntityIDs((EntityID)entity.getID(), (EntityID)input.getID()));
                    }
                    if (++newEntityCount != AbstractTransformAdapterV2.this.getLimit()) continue;
                    break;
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (graphStore != null) {
                    graphStore.endUpdate(null);
                }
            }
            return graphID;
        }

        private int getLinkCount(List<MaltegoEntity> mergedEntities) {
            return TransformMergeSettings.isMergeLinks() ? 1 : mergedEntities.size();
        }

        private Map<MaltegoEntity, List<MaltegoEntity>> getMerged(Iterable<MaltegoEntity> entities, MatchingRuleDescriptor ruleDescriptor) {
            MatchingRule rule = MatchingRuleFactory.createFrom((MatchingRuleDescriptor)ruleDescriptor);
            HashMap<MaltegoEntity, List<MaltegoEntity>> result = new HashMap<MaltegoEntity, List<MaltegoEntity>>();
            for (MaltegoEntity entity : entities) {
                MaltegoEntity existing = this.find(result.keySet(), entity, rule);
                if (existing == null) {
                    ArrayList<MaltegoEntity> list = new ArrayList<MaltegoEntity>();
                    entity = entity.createClone();
                    list.add(entity);
                    result.put(entity, list);
                    continue;
                }
                V2EntityMerger.merge(entity, existing);
                ((List)result.get(existing)).add(entity);
            }
            return result;
        }

        private MaltegoEntity find(Iterable<MaltegoEntity> entities, MaltegoEntity entity, MatchingRule rule) {
            EntityRegistry registry = this._ctx.getEntityRegistry();
            for (MaltegoEntity e : entities) {
                int result;
                if (rule == null) {
                    rule = MatchingRule.Default;
                }
                if ((result = rule.getMatch((SpecRegistry)registry, (TypedPropertyBag)e, (TypedPropertyBag)entity)) != 1) continue;
                return e;
            }
            return null;
        }
    }
}

