/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api.inheritance;

import com.paterva.maltego.entity.api.inheritance.InheritanceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import y.algo.Cycles;
import y.algo.NodeOrders;
import y.algo.Paths;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.util.DataProviderAdapter;

public class MultiInheritanceAdapter<T> {
    private static final boolean DEBUG = false;
    private final InheritanceProvider<T> _provider;
    private T _item;
    private Map<T, List<T>> _inheritanceMap;
    private Graph _graph;
    private Map<T, Node> _itemToNodeMap;
    private Map<Node, T> _nodeToItemMap;

    public MultiInheritanceAdapter(InheritanceProvider<T> provider) {
        this._provider = provider;
    }

    public List<T> getTopologicalInheritanceList(T item) {
        T baseItem;
        List<T> baseItems = this._provider.getBaseItems(item);
        if (baseItems.isEmpty()) {
            return Arrays.asList(item);
        }
        if (baseItems.size() == 1 && (baseItem = baseItems.get(0)) != null && baseItem.equals(this._provider.getRootItem())) {
            return Arrays.asList(item, baseItem);
        }
        this._item = item;
        this.createInheritanceMap();
        this.createInheritanceGraph();
        this.removeCycles();
        return this.createTopologicalList();
    }

    private void createInheritanceMap() {
        this._inheritanceMap = new HashMap<T, List<T>>();
        T rootItem = this._provider.getRootItem();
        if (rootItem != null) {
            this._inheritanceMap.put(rootItem, this._provider.getBaseItems(rootItem));
        }
        this.createInheritanceMapRecursive(this._item);
    }

    private void createInheritanceMapRecursive(T item) {
        List<T> baseItems;
        if (!this._inheritanceMap.containsKey(item) && (baseItems = this._provider.getBaseItems(item)) != null) {
            List<T> validBaseItems = this.getValidBaseItems(baseItems);
            this._inheritanceMap.put(item, validBaseItems);
            for (T baseItem : validBaseItems) {
                this.createInheritanceMapRecursive(baseItem);
            }
        }
    }

    private List<T> getValidBaseItems(List<T> baseItems) {
        ArrayList<T> validBaseItems = new ArrayList<T>();
        for (T baseItem : baseItems) {
            if (this._provider.getBaseItems(baseItem) == null) continue;
            validBaseItems.add(baseItem);
        }
        if (validBaseItems.isEmpty() && this._provider.getRootItem() != null) {
            validBaseItems.add(this._provider.getRootItem());
        }
        return validBaseItems;
    }

    private void createInheritanceGraph() {
        this._graph = new Graph();
        this._itemToNodeMap = new HashMap<T, Node>();
        this._nodeToItemMap = new HashMap<Node, T>();
        for (T item : this._inheritanceMap.keySet()) {
            Node node = this._graph.createNode();
            this._itemToNodeMap.put(item, node);
            this._nodeToItemMap.put(node, item);
        }
        for (T item : this._inheritanceMap.keySet()) {
            List<T> baseItems = this._inheritanceMap.get(item);
            for (T baseItem : baseItems) {
                this._graph.createEdge(this._itemToNodeMap.get(item), this._itemToNodeMap.get(baseItem));
            }
        }
    }

    private void removeCycles() {
        boolean edgeRemoved;
        Node startNode = this._itemToNodeMap.get(this._item);
        Node rootNode = this._itemToNodeMap.get(this._provider.getRootItem());
        FurthestEdge furthestEdge = new FurthestEdge(this._graph, startNode);
        do {
            edgeRemoved = false;
            EdgeMap edges = this._graph.createEdgeMap();
            Cycles.findCycleEdges((Graph)this._graph, (EdgeMap)edges, (DataProvider)furthestEdge);
            Double minimumCost = null;
            Edge edgeToRemove = null;
            for (Edge edge : this._graph.getEdgeArray()) {
                if (!edges.getBool((Object)edge)) continue;
                double cost = furthestEdge.getDouble(edge);
                if (minimumCost != null && !(cost < minimumCost)) continue;
                minimumCost = cost;
                edgeToRemove = edge;
            }
            this._graph.disposeEdgeMap(edges);
            if (edgeToRemove == null) continue;
            T sourceItem = this._nodeToItemMap.get(edgeToRemove.source());
            T targetItem = this._nodeToItemMap.get(edgeToRemove.target());
            System.out.println("WARNING: Cyclic inheritance detected for " + this._item + "! " + sourceItem + " -> " + targetItem + " ignored.");
            List<T> baseItems = this._inheritanceMap.get(sourceItem);
            baseItems.remove(targetItem);
            if (baseItems.isEmpty() && this._provider.getRootItem() != null) {
                baseItems.add(this._provider.getRootItem());
                this._graph.changeEdge(edgeToRemove, edgeToRemove.source(), rootNode);
            } else {
                this._graph.removeEdge(edgeToRemove);
            }
            edgeRemoved = true;
        } while (edgeRemoved);
    }

    private List<T> createTopologicalList() {
        NodeList topological = NodeOrders.topological((Graph)this._graph);
        ArrayList<T> topologicalEntities = new ArrayList<T>();
        for (Node node : topological.toNodeArray()) {
            topologicalEntities.add(this._nodeToItemMap.get(node));
        }
        return topologicalEntities;
    }

    private static class FurthestEdge
    extends DataProviderAdapter {
        private final Graph _graph;
        private final Node _startNode;

        public FurthestEdge(Graph graph, Node startNode) {
            this._graph = graph;
            this._startNode = startNode;
        }

        public double getDouble(Object o) {
            Edge edge = (Edge)o;
            Node stopNode = edge.source();
            if (this._startNode.equals(stopNode)) {
                return 1.0;
            }
            EdgeList path = Paths.findPath((Graph)this._graph, (Node)this._startNode, (Node)stopNode, (boolean)true);
            return 1.0 / (double)path.size();
        }
    }
}

