/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.openide.util.Lookup;
import y.base.Graph;
import y.view.Graph2D;

public abstract class LinkRegistry
extends SpecRegistry<MaltegoLinkSpec> {
    private static LinkRegistry _default;

    public static synchronized LinkRegistry getDefault() {
        if (_default == null && (_default = (LinkRegistry)((Object)Lookup.getDefault().lookup(LinkRegistry.class))) == null) {
            throw new IllegalStateException("No link registry found.");
        }
        return _default;
    }

    public static synchronized LinkRegistry forGraph(Graph graph) {
        return LinkRegistry.forGraphID(GraphIDProvider.forGraph((Graph2D)((Graph2D)graph)));
    }

    public static synchronized LinkRegistry forGraphID(GraphID graphID) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = LinkRegistry.class.getName();
        return (LinkRegistry)((Object)gud.get((Object)key));
    }

    public static synchronized void associate(GraphID graphID, LinkRegistry registry) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = LinkRegistry.class.getName();
        gud.put((Object)key, (Object)registry);
    }

    public static class Composite
    extends LinkRegistry {
        private LinkRegistry[] _registries;
        private LinkRegistry _writeDelegate;

        public Composite(LinkRegistry ... registries) {
            this._registries = registries;
            this._writeDelegate = this._registries[0];
        }

        public LinkRegistry[] getRegistries() {
            return this._registries;
        }

        public void setWriteDelegate(LinkRegistry writeDelegate) {
            this._writeDelegate = writeDelegate;
        }

        public LinkRegistry getWriteDelegate() {
            return this._writeDelegate;
        }

        public void reloadEntities() {
            for (LinkRegistry reg : this._registries) {
                reg.reloadEntities();
            }
        }

        public MaltegoLinkSpec get(String typeName) {
            for (LinkRegistry registry : this._registries) {
                MaltegoLinkSpec spec = (MaltegoLinkSpec)registry.get(typeName);
                if (spec == null) continue;
                return spec;
            }
            return null;
        }

        public Collection<MaltegoLinkSpec> getAll() {
            HashSet<MaltegoLinkSpec> specs = new HashSet<MaltegoLinkSpec>();
            for (int i = this._registries.length - 1; i >= 0; --i) {
                LinkRegistry registry = this._registries[i];
                specs.addAll(registry.getAll());
            }
            return specs;
        }

        public void put(MaltegoLinkSpec spec) {
            this._writeDelegate.put((TypeSpec)spec);
        }

        public void put(MaltegoLinkSpec spec, String category) {
            this._writeDelegate.put((TypeSpec)spec, category);
        }

        public void remove(String typeName) {
            this._writeDelegate.remove(typeName);
        }

        public boolean contains(String typeName) {
            for (LinkRegistry registry : this._registries) {
                if (!registry.contains(typeName)) continue;
                return true;
            }
            return false;
        }

        public String[] allCategories() {
            HashSet<String> categories = new HashSet<String>();
            for (LinkRegistry registry : this._registries) {
                categories.addAll(Arrays.asList(registry.allCategories()));
            }
            return categories.toArray(new String[categories.size()]);
        }
    }

    public static class Memory
    extends LinkRegistry {
        private static final String DEFAULT_FOLDER = "Miscellaneous";
        private HashMap<String, MaltegoLinkSpec> _items = new HashMap();
        private HashMap<String, String> _folders = new HashMap();

        public void reloadEntities() {
        }

        public MaltegoLinkSpec get(String typeName) {
            return this._items.get(typeName);
        }

        public Collection<MaltegoLinkSpec> getAll() {
            return this._items.values();
        }

        public void put(MaltegoLinkSpec spec) {
            this.put(spec, spec.getDefaultCategory());
        }

        public void put(MaltegoLinkSpec spec, String category) {
            if (category == null) {
                category = DEFAULT_FOLDER;
            }
            this._items.put(spec.getTypeName(), spec);
            this._folders.put(spec.getTypeName(), category);
            this.fireTypeAdded((TypeSpec)spec);
        }

        public void remove(String typeName) {
            MaltegoLinkSpec spec = this.get(typeName);
            if (spec != null) {
                this._items.remove(typeName);
                this.fireTypeRemoved((TypeSpec)spec);
            }
        }

        public boolean contains(String typeName) {
            return this._items.containsKey(typeName);
        }

        public String[] allCategories() {
            return this._folders.values().toArray(new String[this._folders.size()]);
        }
    }
}

