/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.manager.nodes.TransformNode;
import com.paterva.maltego.transform.manager.sets.AddToSetAction;
import com.paterva.maltego.transform.manager.sets.DeleteTransformSetAction;
import com.paterva.maltego.transform.manager.sets.EditTransformSetAction;
import com.paterva.maltego.transform.manager.sets.RemoveFromSetAction;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class TransformSetNode
extends AbstractNode {
    private SetChildFactory _factory;

    public TransformSetNode(TransformSet set) {
        this(set, new SetChildFactory(set), new InstanceContent());
    }

    private TransformSetNode(TransformSet set, SetChildFactory factory, InstanceContent content) {
        super(Children.create((ChildFactory)factory, (boolean)false), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)set);
        this._factory = factory;
        this.setDisplayName(set.getName());
        this.setShortDescription(set.getDescription());
        this.setIconBaseWithExtension("com/paterva/maltego/transform/manager/sets/TransformSet.png");
    }

    public Action getPreferredAction() {
        SystemAction a = SystemAction.get(EditTransformSetAction.class);
        return a;
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(EditTransformSetAction.class), SystemAction.get(DeleteTransformSetAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new DescriptionProperty());
        sheet.put(set);
        return sheet;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        Node[] n;
        super.createPasteTypes(t, s);
        final Node[] nodes = n = NodeTransfer.nodes((Transferable)t, (int)7);
        if (nodes != null) {
            s.add(new PasteType(){

                public Transferable paste() throws IOException {
                    TransformSetNode.this.pasteNode(nodes);
                    return null;
                }
            });
        }
    }

    private void pasteNode(Node[] nodes) {
        for (Node node : nodes) {
            TransformDefinition transform = (TransformDefinition)node.getLookup().lookup(TransformDefinition.class);
            TransformSet toSet = (TransformSet)this.getLookup().lookup(TransformSet.class);
            TransformSet fromSet = (TransformSet)node.getLookup().lookup(TransformSet.class);
            if (fromSet != null) {
                fromSet.removeTransform(transform.getName());
            }
            if (toSet == null) continue;
            toSet.addTransform(transform.getName());
        }
    }

    private class DescriptionProperty
    extends PropertySupport.ReadWrite<String> {
        public DescriptionProperty() {
            super("description", String.class, "Description", "Description");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return ((TransformSet)TransformSetNode.this.getLookup().lookup(TransformSet.class)).getDescription();
        }

        public void setValue(String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        }
    }

    private static class SetTransformNode
    extends TransformNode {
        public SetTransformNode(TransformDefinition transform, InstanceContent content) {
            super(transform, content, false);
        }

        @Override
        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(AddToSetAction.class), SystemAction.get(RemoveFromSetAction.class)};
        }
    }

    private static class SetChildFactory
    extends ChildFactory<TransformDefinition>
    implements PropertyChangeListener {
        private TransformSet _set;

        public SetChildFactory(TransformSet set) {
            this._set = set;
            set.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)set));
        }

        protected boolean createKeys(List<TransformDefinition> toFill) {
            TransformRepositoryRegistry repositories = TransformRepositoryRegistry.getDefault();
            TransformServerRegistry servers = TransformServerRegistry.getDefault();
            for (String key : this._set.getAllTransforms()) {
                TransformDefinition def;
                if (!servers.exists(key, true) || (def = repositories.findTransform(key)) == null) continue;
                toFill.add(def);
            }
            Collections.sort(toFill, new Comparator<TransformDefinition>(){

                @Override
                public int compare(TransformDefinition o1, TransformDefinition o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            return true;
        }

        protected Node createNodeForKey(TransformDefinition key) {
            InstanceContent content = new InstanceContent();
            content.add((Object)this._set);
            return new SetTransformNode(key, content);
        }

        protected Node createWaitNode() {
            AbstractNode wait = new AbstractNode(Children.LEAF);
            wait.setDisplayName("Loading...");
            return wait;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("transforms".equals(evt.getPropertyName())) {
                this.refresh(false);
            }
        }
    }
}

