/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.sets;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryItems;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TransformSetDiscoveryProvider
extends MtzDiscoveryProvider<TransformSets> {
    private static final boolean DEBUG = false;

    public TransformSets read(DiscoveryContext ctx, MaltegoArchiveReader reader) throws IOException {
        TransformSetImporter importer = new TransformSetImporter();
        List<TransformSet> sets = importer.readSets(reader);
        this.printSets(ctx, "sets before", TransformSetRepository.getDefault().allSets());
        this.printSets(ctx, "sets read", sets);
        return new TransformSets(sets, ctx, false);
    }

    public void apply(TransformSets sets) {
        DiscoveryContext ctx = sets.getContext();
        if (!sets.isTrimmed()) {
            sets = this.getNewAndMerged(sets);
        }
        TransformSetImporter importer = new TransformSetImporter();
        List<TransformSet> newSets = sets.getTransformSets();
        this.printSets(ctx, "sets applied", newSets);
        importer.applySets(newSets);
        this.printSets(ctx, "sets after", TransformSetRepository.getDefault().allSets());
    }

    public TransformSets getNewAndMerged(TransformSets items) {
        DiscoveryContext ctx = items.getContext();
        ArrayList<TransformSet> sets = new ArrayList<TransformSet>(items.getTransformSets());
        this.removeNonHubTransforms(ctx, sets);
        this.printSets(ctx, "sets trimmed", sets);
        List<TransformSet> newSets = this.getNewAndMerged(sets);
        this.printSets(ctx, "sets new & merged", sets);
        return new TransformSets(newSets, ctx, true);
    }

    private List<TransformSet> getNewAndMerged(List<TransformSet> sets) {
        ArrayList<TransformSet> newSets = new ArrayList<TransformSet>();
        TransformSetRepository repo = TransformSetRepository.getDefault();
        for (TransformSet set : sets) {
            TransformSet oldSet = repo.get(set.getName());
            TransformSet newSet = oldSet == null ? set : this.mergeSets(set, oldSet);
            if (newSet == null) continue;
            newSets.add(newSet);
        }
        return newSets;
    }

    private void removeNonHubTransforms(DiscoveryContext ctx, List<TransformSet> sets) {
        String seedUrl = ctx.getSeedUrl();
        HubSeedRegistry hubRegistry = HubSeedRegistry.getDefault();
        HubSeedDescriptor hubSeed = hubRegistry.getHubSeed(seedUrl);
        if (hubSeed == null) {
            throw new IllegalStateException("Could not find hub item being discovered from: " + seedUrl);
        }
        Set<String> hubTransforms = this.toNamesOnly(hubRegistry.getTransforms(hubSeed));
        Iterator<TransformSet> itr = sets.iterator();
        while (itr.hasNext()) {
            TransformSet set = itr.next();
            this.retainTransforms(set, hubTransforms);
            if (!set.getAllTransforms().isEmpty()) continue;
            itr.remove();
        }
    }

    private void retainTransforms(TransformSet set, Set<String> hubTransforms) {
        HashSet setTransforms = new HashSet(set.getAllTransforms());
        for (String setTransform : setTransforms) {
            if (hubTransforms.contains(setTransform)) continue;
            set.removeTransform(setTransform);
        }
    }

    private TransformSet mergeSets(TransformSet newSet, TransformSet oldSet) {
        newSet.addAllTransforms((Collection)oldSet.getAllTransforms());
        if (newSet.getAllTransforms().size() != oldSet.getAllTransforms().size()) {
            newSet.setDescription(oldSet.getDescription());
            return newSet;
        }
        return null;
    }

    private Set<String> toNamesOnly(Set<TransformDefinition> transforms) {
        HashSet<String> names = new HashSet<String>(transforms.size());
        for (TransformDefinition transform : transforms) {
            names.add(transform.getName());
        }
        return names;
    }

    private void printSets(DiscoveryContext ctx, String title, Collection<TransformSet> sets) {
    }

    public class TransformSets
    extends MtzDiscoveryItems {
        private final List<TransformSet> _sets;
        private final boolean _trimmed;

        public TransformSets(List<TransformSet> sets, DiscoveryContext context, boolean trimmed) {
            super((MtzDiscoveryProvider)TransformSetDiscoveryProvider.this, context);
            this._sets = sets;
            this._trimmed = trimmed;
        }

        public String getDescription() {
            return "Transform Sets";
        }

        public List<TransformSet> getTransformSets() {
            return Collections.unmodifiableList(this._sets);
        }

        public boolean isTrimmed() {
            return this._trimmed;
        }

        public int size() {
            return this._sets.size();
        }
    }
}

