/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.entity;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.treelist.lazy.etable.ETableColumnModel;
import com.paterva.maltego.treelist.lazy.outline.LazyOutline;
import com.paterva.maltego.treelist.parts.PartsTable;
import com.paterva.maltego.treelist.parts.PartsTreeModel;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import com.paterva.maltego.treelist.parts.entity.EntityHoverableIconRenderer;
import com.paterva.maltego.treelist.parts.entity.EntityRowModel;
import com.paterva.maltego.treelist.parts.entity.EntitySortOrderProvider;
import com.paterva.maltego.treelist.parts.entity.EntityTreeModel;
import com.paterva.maltego.treelist.parts.entity.EntityTreelistModel;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.Exceptions;

public class EntityTable
extends PartsTable<EntityID, MaltegoEntity> {
    private static final int[] COLUMNS = new int[]{0, 1, 2, 9, 3, 4, 5, 6, 7, 8};
    private static final List<Integer> COPY_COLUMNS = Arrays.asList(3, 5, 6, 7, 4, 2, 8);

    public EntityTable(String name, boolean small) {
        super(small);
        EntityTreelistModel model = new EntityTreelistModel(name, COLUMNS);
        EntityTreeModel treeModel = new EntityTreeModel((LazyOutline)this, model);
        EntityRowModel rowModel = new EntityRowModel(model, small);
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)treeModel, (RowModel)rowModel, (boolean)true, (String)"Entity");
        this.setTreelistModel(model);
        this.setTreeModel(treeModel);
        this.setRowModel(rowModel);
        this.setSortOrderProvider(new EntitySortOrderProvider(model));
        this.setRootVisible(false);
        this.setModel((TableModel)outlineModel);
        try {
            this.initColumns();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void initColumns() throws GraphStoreException {
        ETableColumnModel etcm = (ETableColumnModel)this.getColumnModel();
        EntityHoverableIconRenderer renderer = this.getIconRenderer();
        etcm.getColumn(1).setCellRenderer(renderer);
        etcm.getColumn(2).setCellRenderer(renderer);
        etcm.getColumn(3).setCellRenderer(renderer);
        etcm.getColumn(4).setCellRenderer(renderer);
        etcm.getColumn(5).setCellRenderer(renderer);
        etcm.getColumn(6).setCellRenderer(renderer);
        LazyTreelistSettings settings = LazyTreelistSettings.getDefault();
        int count = 0;
        int iconSize = settings.getIconSize()[this.isSmall() ? 0 : 1];
        int iconWidth = settings.getIconWidth(this.isSmall(), count);
        etcm.getColumn(0).setPreferredWidth(this.getIconColumnWidth(true) * 7);
        this.configureIconColumn(0, GraphicsUtils.getSelectedIcon((int)iconSize, (boolean)true, (boolean)false), true);
        this.configureIconColumn(1, GraphicsUtils.getInspectIcon((int)iconSize, (boolean)false), true);
        this.configureIconColumn(2, null, true);
        this.configureIconColumn(3, BookmarkFactory.getDefault().getBlackIcon(iconSize), true);
        this.configureIconColumn(4, GraphicsUtils.getPinIcon((int)iconSize, (boolean)false, (boolean)false, (boolean)true), true);
        this.configureIconColumn(5, GraphicsUtils.getCollectedIcon((int)iconWidth, (int)iconSize, (int)count, (boolean)false, (boolean)true), false);
        this.configureIconColumn(6, GraphicsUtils.getLinkIcon((int)iconSize, (boolean)true), false);
        this.configureIconColumn(7, GraphicsUtils.getLinkIcon((int)iconSize, (boolean)false), false);
        this.configureIconColumn(8, GraphicsUtils.getWeightIcon((int)iconSize), false);
        if (this.isSmall()) {
            etcm.moveColumn(1, 0);
            etcm.setColumnHidden(etcm.getColumn(8), true);
            etcm.setColumnHidden(etcm.getColumn(7), true);
            etcm.setColumnHidden(etcm.getColumn(6), true);
            etcm.setColumnHidden(etcm.getColumn(3), true);
            etcm.setColumnHidden(etcm.getColumn(2), true);
        } else {
            TableColumn column = etcm.getColumn(1);
            etcm.setColumnHidden(column, true);
            etcm.moveColumn(1, 0);
            etcm.moveColumn(2, 1);
        }
    }

    protected EntityHoverableIconRenderer getIconRenderer() {
        return new EntityHoverableIconRenderer(this);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int modelIndex = this.getColumnModel().getColumn(columnIndex).getModelIndex();
        if (modelIndex == 0 || modelIndex == 1 || modelIndex == 3 || modelIndex == 7 || modelIndex == 8 || modelIndex == 9) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    @Override
    protected void doCopy() {
        StringBuilder sb = new StringBuilder();
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        boolean first = true;
        ArrayList<Integer> copyColumns = new ArrayList<Integer>();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int modelIndex = column.getModelIndex() - 1;
            if (!this.isCopyColumn(modelIndex)) continue;
            if (!first) {
                sb.append(",");
            }
            copyColumns.add(modelIndex);
            Object headerValue = column.getHeaderValue();
            sb.append(headerValue.toString());
            first = false;
        }
        sb.append("\n");
        PartsTreeModel treeModel = this.getTreeModel();
        PartsTreelistModel treelistModel = this.getTreelistModel();
        GraphID graphID = treelistModel.getGraphID();
        for (int row : this.getSelectedRows()) {
            int modelRow = this.convertRowIndexToModel(row);
            Optional entityOpt = treelistModel.getModelPart(treeModel.getPartID(modelRow), null);
            if (!entityOpt.isPresent()) continue;
            MaltegoEntity entity = (MaltegoEntity)entityOpt.get();
            first = true;
            for (Integer column : copyColumns) {
                if (!first) {
                    sb.append(",");
                }
                this.appendField(sb, graphID, entity, column);
                first = false;
            }
            sb.append("\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(sb.toString()), null);
    }

    private void appendField(StringBuilder sb, GraphID graphID, MaltegoEntity entity, Integer column) {
        EntityID entityID = (EntityID)entity.getID();
        switch (column) {
            case -1: {
                sb.append(this.replaceCommas(entity.getDisplayString()));
                break;
            }
            case 3: {
                sb.append(entity.getBookmark());
                break;
            }
            case 5: {
                boolean collected = this.isCollected(graphID, entityID);
                sb.append(collected ? "yes" : "no");
                break;
            }
            case 6: {
                int incoming = this.getLinkCount(graphID, entityID, true);
                sb.append(incoming);
                break;
            }
            case 7: {
                int outgoing = this.getLinkCount(graphID, entityID, false);
                sb.append(outgoing);
                break;
            }
            case 4: {
                boolean pinned = this.isPinned(graphID, entityID);
                sb.append(pinned ? "yes" : "no");
                break;
            }
            case 2: {
                sb.append(entity.getTypeName());
                break;
            }
            case 8: {
                sb.append(entity.getWeight());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean isCollected(GraphID graphID, EntityID entityID) {
        boolean collected = false;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            collected = !mappings.isViewEntity(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return collected;
    }

    private boolean isCopyColumn(int modelIndex) {
        return modelIndex == -1 || COPY_COLUMNS.contains(modelIndex);
    }

    private int getLinkCount(GraphID graphID, EntityID entityID, boolean incoming) {
        int links = 0;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            links = incoming ? structureReader.getIncomingLinkCount(entityID) : structureReader.getOutgoingLinkCount(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }

    private boolean isPinned(GraphID graphID, EntityID entityID) {
        boolean pinned = false;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            pinned = structureReader.getPinned(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return pinned;
    }

    private String replaceCommas(String displayString) {
        return displayString.replace(",", " ");
    }
}

