/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.entity;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.cache.EntityCache;
import com.paterva.maltego.graph.cache.PartCache;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphMods;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.sort.PartSortAndFilterInfo;
import com.paterva.maltego.graph.store.data.sort.SortField;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.treelist.parts.CachedLazyPartsProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class EntityCachedLazyPartsProvider
extends CachedLazyPartsProvider<EntityID, MaltegoEntity> {
    private static final Logger LOG = Logger.getLogger(EntityCachedLazyPartsProvider.class.getName());
    private static final SortField SORT_WEIGHT_DESC = new SortField(8, false);
    private static final SortField SORT_DISPLAY_ASC = new SortField(0, true);
    private final String _name;
    private EntityCache _cache = null;
    private GraphListener _graphListener;

    public EntityCachedLazyPartsProvider(String name) {
        this._name = name;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        try {
            GraphID graphID = this.getGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            this._graphListener = new GraphListener();
            graphStore.addPropertyChangeListener((PropertyChangeListener)this._graphListener);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void removeListeners() {
        try {
            GraphID graphID = this.getGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.removePropertyChangeListener((PropertyChangeListener)this._graphListener);
            this._graphListener = null;
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.removeListeners();
    }

    @Override
    public PartCache<EntityID, MaltegoEntity> getCache() {
        if (this._cache == null) {
            this._cache = new EntityCache(this._name, 500);
        }
        return this._cache;
    }

    @Override
    public Map<EntityID, MaltegoEntity> getParts(Collection<EntityID> partIDs) {
        Map entities = null;
        try {
            GraphDataStoreReader dataReader = this.getDataReader();
            if (dataReader != null) {
                Set existingEntities = this.getStructureReader().getExistingEntities(partIDs);
                EntityDataQuery entityQuery = new EntityDataQuery();
                entityQuery.setAllProperties(true);
                entityQuery.setAllSections(true);
                EntitiesDataQuery entitiesQuery = new EntitiesDataQuery();
                entitiesQuery.setIDs(new HashSet(existingEntities));
                entitiesQuery.setPartDataQuery((PartDataQuery)entityQuery);
                entities = dataReader.getEntities(entitiesQuery);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entities != null ? entities : Collections.EMPTY_MAP;
    }

    @Override
    public List<EntityID> getSortedFilteredIDs(Collection<EntityID> partIDs, PartSortAndFilterInfo info) {
        LOG.log(Level.FINE, "Sort & filter info: {0}", info);
        List<EntityID> sortedIDs = Collections.EMPTY_LIST;
        try {
            GraphDataStoreReader dataReader = this.getDataReader();
            if (dataReader != null) {
                LOG.log(Level.FINE, "Unfiltered parts: {0}", partIDs);
                ArrayList<EntityID> ids = new ArrayList<EntityID>(dataReader.getFilteredEntities(info.getFilterText(), partIDs));
                LOG.log(Level.FINE, "Unsorted parts: {0}", ids);
                ArrayList<SortField> fields = new ArrayList<SortField>(info.getFields());
                Collections.reverse(fields);
                sortedIDs = this.sortBySortFields(dataReader, fields, ids);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sortedIDs;
    }

    private List<EntityID> sortBySortFields(GraphDataStoreReader dataReader, List<SortField> fields, List<EntityID> ids) throws GraphStoreException {
        List sortedIDs = ids;
        if (fields.size() != 2 || !fields.get(0).equals((Object)SORT_DISPLAY_ASC) || !fields.get(1).equals((Object)SORT_WEIGHT_DESC)) {
            sortedIDs = dataReader.getSortedEntities(sortedIDs, new SortField[]{SORT_WEIGHT_DESC, SORT_DISPLAY_ASC});
        }
        for (SortField field : fields) {
            switch (field.getField()) {
                case 0: 
                case 3: 
                case 8: 
                case 9: {
                    sortedIDs = dataReader.getSortedEntities((Collection)sortedIDs, new SortField[]{field});
                    break;
                }
                case 1: {
                    Collections.sort(sortedIDs, new SelectedComparator(field.isAscending()));
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    Collections.sort(sortedIDs, new PinnedComparator(sortedIDs, field.isAscending()));
                    break;
                }
                case 5: {
                    Collections.sort(sortedIDs, new CollectedComparator(sortedIDs, field.isAscending()));
                    break;
                }
                case 6: {
                    Collections.sort(sortedIDs, new LinkComparator(sortedIDs, field.isAscending(), true));
                    break;
                }
                case 7: {
                    Collections.sort(sortedIDs, new LinkComparator(sortedIDs, field.isAscending(), false));
                    break;
                }
                default: {
                    LOG.log(Level.SEVERE, "Unknown sort field: {0}", field);
                }
            }
            LOG.log(Level.FINE, "{0} sorted: {1}", new Object[]{field, sortedIDs});
        }
        return sortedIDs;
    }

    private class LinkComparator
    implements Comparator<EntityID> {
        private final boolean _ascending;
        private Map<EntityID, Set<LinkID>> _links;

        public LinkComparator(List<EntityID> sortedIDs, boolean ascending, boolean incoming) {
            this._ascending = ascending;
            GraphStructureReader structureReader = EntityCachedLazyPartsProvider.this.getStructureReader();
            try {
                this._links = incoming ? structureReader.getIncoming(sortedIDs) : structureReader.getOutgoing(sortedIDs);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public int compare(EntityID o1, EntityID o2) {
            int o1Count = this._links.get(o1).size();
            int o2Count = this._links.get(o2).size();
            int result = o1Count - o2Count;
            if (!this._ascending) {
                result = -result;
            }
            return result;
        }
    }

    private class CollectedComparator
    implements Comparator<EntityID> {
        private final boolean _ascending;
        private Map<EntityID, Integer> _siblingCounts;

        public CollectedComparator(List<EntityID> sortedIDs, boolean ascending) {
            this._ascending = ascending;
            try {
                EntityID viewEntityID;
                GraphModelViewMappings mappings = EntityCachedLazyPartsProvider.this.getModelViewMappings();
                HashMap<EntityID, EntityID> parents = new HashMap<EntityID, EntityID>();
                for (EntityID sortedID : sortedIDs) {
                    parents.put(sortedID, mappings.getViewEntity(sortedID));
                }
                HashMap<EntityID, Integer> childCounts = new HashMap<EntityID, Integer>(parents.size());
                for (Map.Entry entry : parents.entrySet()) {
                    viewEntityID = (EntityID)entry.getValue();
                    childCounts.put(viewEntityID, mappings.getModelEntities(viewEntityID).size());
                }
                this._siblingCounts = new HashMap<EntityID, Integer>(sortedIDs.size());
                for (EntityID sortedID : sortedIDs) {
                    viewEntityID = (EntityID)parents.get(sortedID);
                    int siblings = (Integer)childCounts.get(viewEntityID);
                    this._siblingCounts.put(sortedID, siblings);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public int compare(EntityID o1, EntityID o2) {
            Integer o1Count = this._siblingCounts.get(o1);
            Integer o2Count = this._siblingCounts.get(o2);
            int result = (o1Count == null ? 0 : o1Count) - (o2Count == null ? 0 : o2Count);
            if (!this._ascending) {
                result = -result;
            }
            return result;
        }
    }

    private class PinnedComparator
    implements Comparator<EntityID> {
        private final boolean _ascending;
        private Map<EntityID, Boolean> _pinned;

        public PinnedComparator(List<EntityID> sortedIDs, boolean ascending) {
            this._ascending = ascending;
            GraphStructureReader structureReader = EntityCachedLazyPartsProvider.this.getStructureReader();
            try {
                this._pinned = structureReader.getPinned(sortedIDs);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public int compare(EntityID o1, EntityID o2) {
            Boolean o1Pinned = this._pinned.get(o1);
            Boolean o2Pinned = this._pinned.get(o2);
            int result = Boolean.compare(o1Pinned == null ? false : o1Pinned, o2Pinned == null ? false : o2Pinned);
            if (!this._ascending) {
                result = -result;
            }
            return result;
        }
    }

    private class SelectedComparator
    implements Comparator<EntityID> {
        private final boolean _ascending;
        private final GraphSelection _selection;

        public SelectedComparator(boolean ascending) {
            this._selection = GraphSelection.forGraph((GraphID)EntityCachedLazyPartsProvider.this.getGraphID());
            this._ascending = ascending;
        }

        @Override
        public int compare(EntityID o1, EntityID o2) {
            boolean o1Selected = this._selection.isSelectedInModel(o1);
            boolean o2Selected = this._selection.isSelectedInModel(o2);
            int result = Boolean.compare(o2Selected, o1Selected);
            if (!this._ascending) {
                result = -result;
            }
            return result;
        }
    }

    private class GraphListener
    implements PropertyChangeListener {
        private GraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphModified".equals(evt.getPropertyName())) {
                GraphStructureMods structureMods;
                GraphMods mods = (GraphMods)evt.getNewValue();
                GraphDataMods dataMods = mods.getDataMods();
                if (dataMods != null) {
                    Map entitiesUpdated = dataMods.getEntitiesUpdated();
                    EntityCachedLazyPartsProvider.this.getCache().remove(entitiesUpdated.keySet());
                }
                if ((structureMods = mods.getStructureMods()) != null) {
                    Set entitiesRemoved = structureMods.getEntitiesRemoved();
                    EntityCachedLazyPartsProvider.this.getCache().remove((Collection)entitiesRemoved);
                }
            }
        }
    }
}

