/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.treelist.lazy.etable.ETableColumn;
import com.paterva.maltego.treelist.lazy.etable.ETableHeader;
import com.paterva.maltego.treelist.lazy.filter.LazyOutlineFilterPanel;
import com.paterva.maltego.treelist.lazy.outline.DefaultOutlineCellRenderer;
import com.paterva.maltego.treelist.lazy.outline.LazyOutline;
import com.paterva.maltego.treelist.parts.PartsRowModel;
import com.paterva.maltego.treelist.parts.PartsTreeModel;
import com.paterva.maltego.treelist.parts.PartsTreelist;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public abstract class PartsTable<PartID extends Guid, Part extends MaltegoPart<PartID>>
extends PartsTreelist {
    private static final Logger LOG = Logger.getLogger(PartsTable.class.getName());
    private final boolean _small;
    private PartsTreelistModel<PartID, Part> _treelistModel;
    private PartsTreeModel<PartID, Part> _treeModel;
    private PartsRowModel<PartID, Part> _rowModel;
    private LazyOutlineFilterPanel _filter;
    private MouseAdapter _hoverListener;
    private AWTEventListener _globalHoverListener;
    private boolean _tableHovered = false;
    private PartID _partHovered;
    private int _columnHovered = -1;
    private int _index;

    public PartsTable(boolean small) {
        this._small = small;
        this._index = this._small ? 0 : 1;
        this.updateUI();
        if (small) {
            LazyTreelistSettings settings = LazyTreelistSettings.getDefault();
            this.setFont(this.getFont().deriveFont(settings.getTableFontSize(small)));
            boolean _globalFontSizeIncrease = false;
            this.setRowHeight(7);
            this.setRowMargin(1);
            this.setShowVerticalLines(false);
            this.setShowHorizontalLines(true);
            ETableHeader header = new ETableHeader(this.getColumnModel(), true){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.height = 8;
                    return size;
                }
            };
            header.setReorderingAllowed(false);
            header.putClientProperty((Object)"drawTableHeaderUISmall", (Object)Boolean.TRUE);
            header.setFont(header.getFont().deriveFont(settings.getTableFontSize(small)));
            this.setTableHeader((JTableHeader)header);
            DefaultOutlineCellRenderer renderer = new DefaultOutlineCellRenderer(true);
            this.setDefaultRenderer(Object.class, (TableCellRenderer)renderer);
        }
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this.tableHeader.setBackground(laf.getColor("parts-table-header-bg"));
        this.tableHeader.setForeground(laf.getColor("parts-table-header-fg"));
        this.tableHeader.setBorder(null);
        this.setBorder(null);
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.registerKeyboardAction(new CopyListener(), "Copy", copy, 0);
    }

    protected abstract void doCopy();

    public void addNotify() {
        super.addNotify();
        this._hoverListener = new HoverListener();
        this.addMouseListener(this._hoverListener);
        this.addMouseMotionListener(this._hoverListener);
        this._globalHoverListener = new GlobalHoverListener();
        Toolkit.getDefaultToolkit().addAWTEventListener(this._globalHoverListener, 16L);
    }

    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._globalHoverListener);
        this._globalHoverListener = null;
        this.removeMouseMotionListener(this._hoverListener);
        this.removeMouseListener(this._hoverListener);
        this._hoverListener = null;
        this._tableHovered = false;
        if (this._partHovered != null) {
            this._partHovered = null;
            this.onPartHovered(null, null);
        }
    }

    public void setTreelistModel(PartsTreelistModel<PartID, Part> treelistModel) {
        this._treelistModel = treelistModel;
    }

    public PartsTreelistModel<PartID, Part> getTreelistModel() {
        return this._treelistModel;
    }

    public void setTreeModel(PartsTreeModel<PartID, Part> treeModel) {
        this._treeModel = treeModel;
    }

    public PartsTreeModel<PartID, Part> getTreeModel() {
        return this._treeModel;
    }

    public void setRowModel(PartsRowModel<PartID, Part> rowModel) {
        this._rowModel = rowModel;
    }

    public PartsRowModel<PartID, Part> getRowModel() {
        return this._rowModel;
    }

    public boolean isSmall() {
        return this._small;
    }

    public JPanel getFilter() {
        if (this._filter == null) {
            int border = this.isSmall() ? 1 : 3;
            this._filter = new LazyOutlineFilterPanel((LazyOutline)this, this.isSmall());
            this._filter.setBorder((Border)new EmptyBorder(border, border, border, border));
        }
        return this._filter;
    }

    public void addListeners() {
        this._treeModel.addListeners();
    }

    public void removeListeners() {
        this._treeModel.removeListeners();
    }

    protected void configureIconColumn(int index, Icon headerIcon, boolean isIconColumn) {
        ETableColumn column = (ETableColumn)this.getColumnModel().getColumn(index + 1);
        column.setCustomIcon(headerIcon);
        column.setMinWidth(1);
        int columnWidth = this.getIconColumnWidth(isIconColumn);
        column.setMaxWidth(columnWidth * 10);
        column.setPreferredWidth(columnWidth);
        column.setHideHeaderText(true);
    }

    protected int getIconColumnWidth(boolean isIconColumn) {
        int width;
        LazyTreelistSettings settings = LazyTreelistSettings.getDefault();
        if (isIconColumn) {
            width = settings.getTableColumnWidthDefault()[this._index];
        } else {
            Font font = this.getFont();
            width = settings.getTableColumnWidth(font)[this._index];
        }
        return width;
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component c;
        if (this.isSmall() && editor instanceof DefaultCellEditor && (c = ((DefaultCellEditor)editor).getComponent()) instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.putProperty("i18n", Boolean.TRUE);
        }
        return super.prepareEditor(editor, row, column);
    }

    public String getUIClassID() {
        return this.isSmall() ? "SmallTableUI" : super.getUIClassID();
    }

    protected void paintComponent(Graphics g) {
        try {
            GraphID graphID = this.getTreelistModel().getGraphID();
            if (graphID != null && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                super.paintComponent(g);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateTableHovered(MouseEvent m) {
        if (m.getID() == 504 || m.getID() == 505 || m.getID() == 500) {
            Component component = m.getComponent();
            if (SwingUtilities.isDescendingFrom(component, (Component)((Object)this))) {
                Point p = m.getLocationOnScreen();
                Rectangle bounds = this.getBounds();
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, (Component)((Object)this));
                bounds.setLocation(location);
                this.setHovered(m, bounds.contains(p));
            } else {
                this.setHovered(m, false);
            }
        }
    }

    protected boolean isTableHovered() {
        return this._tableHovered;
    }

    private void setHovered(MouseEvent m, boolean hovered) {
        if (hovered != this._tableHovered) {
            this._tableHovered = hovered;
            LOG.log(Level.FINE, "Hovered: {0}", this._tableHovered);
            this.onTableHoveredChanged(m);
        }
    }

    protected void onTableHoveredChanged(MouseEvent m) {
        this.updatePartHovered(m);
    }

    private void updatePartHovered(MouseEvent e) {
        boolean repaint = false;
        Point point = e.getPoint();
        int row = this.convertRowIndexToModel(this.rowAtPoint(point));
        int oldColumn = this._columnHovered;
        int viewColumn = this.columnAtPoint(point);
        int n = this._columnHovered = viewColumn < 0 ? viewColumn : this.convertColumnIndexToModel(viewColumn);
        if (oldColumn != this._columnHovered) {
            repaint = true;
        }
        PartID id = null;
        if (row >= 0 && this._tableHovered) {
            id = this.getRowModel().getModel().getModelPartID(row);
        }
        if (!Utilities.compareObjects(this._partHovered, id)) {
            this._partHovered = id;
            this.onPartHovered(this.getRowModel().getModel().getGraphID(), id);
            repaint = true;
        }
        if (repaint) {
            this.repaint();
        }
    }

    protected void onPartHovered(GraphID graphID, PartID id) {
    }

    public boolean isHovered(PartID partId, int column) {
        return this._columnHovered == column && partId != null && partId.equals(this._partHovered);
    }

    private class CopyListener
    implements ActionListener {
        private CopyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartsTable.this.doCopy();
        }
    }

    private class GlobalHoverListener
    implements AWTEventListener {
        private GlobalHoverListener() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent m = (MouseEvent)e;
                PartsTable.this.updateTableHovered(m);
            }
        }
    }

    private class HoverListener
    extends MouseAdapter {
        private HoverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PartsTable.this.updatePartHovered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PartsTable.this.updatePartHovered(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PartsTable.this.updatePartHovered(e);
        }
    }
}

