/*
 * Decompiled with CFR 0.152.
 */
package y.view.tabular;

import java.awt.Color;
import java.awt.Stroke;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.w3c.dom.Element;
import y.base.Node;
import y.io.BadVersionException;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.input.DeserializationEvent;
import y.io.graphml.input.DeserializationHandler;
import y.io.graphml.output.SerializationEvent;
import y.io.graphml.output.SerializationHandler;
import y.io.graphml.output.SerializationNotSupportedException;
import y.io.graphml.output.XmlWriter;
import y.view.Graph2D;
import y.view.LineType;
import y.view.NodeRealizer;
import y.view.tabular.TableGroupNodeRealizer;

public interface TableStyle {
    public Stroke getBorderLineType(NodeRealizer var1);

    public Color getBorderLineColor(NodeRealizer var1);

    public Color getBorderFillColor(NodeRealizer var1);

    public Stroke getLineType(NodeRealizer var1);

    public Color getLineColor(NodeRealizer var1);

    public Color getFillColor(NodeRealizer var1);

    public static class SimpleStyleDeserializer
    implements DeserializationHandler {
        public void onHandleDeserialization(DeserializationEvent deserializationEvent) {
            org.w3c.dom.Node node = deserializationEvent.getXmlNode();
            if ("SimpleStyle".equals(node.getLocalName()) && "http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI()) && node.getNodeType() == 1) {
                Element element = (Element)node;
                LineType lineType = SimpleStyleDeserializer.b(element, "borderLine");
                Color color = null;
                String string = element.getAttribute("borderLineColor");
                if (!"".equals(string)) {
                    color = GraphicsSerializationToolkit.parseColor(string);
                }
                Color color2 = null;
                String string2 = element.getAttribute("borderFillColor");
                if (!"".equals(string2)) {
                    color2 = GraphicsSerializationToolkit.parseColor(string2);
                }
                LineType lineType2 = SimpleStyleDeserializer.b(element, "line");
                Color color3 = null;
                String string3 = element.getAttribute("lineColor");
                if (!"".equals(string3)) {
                    color3 = GraphicsSerializationToolkit.parseColor(string3);
                }
                Color color4 = null;
                String string4 = element.getAttribute("fillColor");
                if (!"".equals(string4)) {
                    color4 = GraphicsSerializationToolkit.parseColor(string4);
                }
                deserializationEvent.setResult(new SimpleStyle(lineType, color, color2, lineType2, color3, color4));
            }
        }

        private static LineType b(Element element, String string) {
            boolean bl = TableGroupNodeRealizer.z;
            String string2 = element.getAttribute(string + "Type");
            String string3 = element.getAttribute(string + "Width");
            if (!"".equals(string2) && !"".equals(string3)) {
                float f2 = Float.parseFloat(string3);
                byte by = SimpleStyleDeserializer.n(string2);
                if (127 == by) {
                    int n2 = 2;
                    String string4 = element.getAttribute(string + "Cap");
                    if (!"".equals(string4)) {
                        n2 = Integer.parseInt(string4);
                    }
                    int n3 = 1;
                    String string5 = element.getAttribute(string + "Join");
                    if (!"".equals(string5)) {
                        n3 = Integer.parseInt(string5);
                    }
                    float f3 = 1.0f;
                    String string6 = element.getAttribute(string + "MiterLimit");
                    if (!"".equals(string6)) {
                        f3 = Float.parseFloat(string6);
                    }
                    float f4 = 0.0f;
                    String string7 = element.getAttribute(string + "DashPhase");
                    if (!"".equals(string7)) {
                        f4 = Float.parseFloat(string7);
                    }
                    float[] fArray = null;
                    String string8 = element.getAttribute(string + "Dash");
                    if (!"".equals(string8)) {
                        String[] stringArray = string8.split(",");
                        fArray = new float[stringArray.length];
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            fArray[i2] = Float.parseFloat(stringArray[i2]);
                            if (!bl) continue;
                        }
                    }
                    return LineType.createLineType(f2, n2, n3, f3, fArray, f4);
                }
                return LineType.createLineType(Math.round(f2), by);
            }
            return null;
        }

        private static byte n(String string) {
            if ("line".equals(string)) {
                return 0;
            }
            if ("dashed".equals(string)) {
                return 1;
            }
            if ("dotted".equals(string)) {
                return 2;
            }
            if ("dashed_dotted".equals(string)) {
                return 3;
            }
            if ("custom".equals(string)) {
                return 127;
            }
            return 0;
        }
    }

    public static class SimpleStyleSerializer
    implements SerializationHandler {
        private static final String tc = "SimpleStyle";

        public void onHandleSerialization(SerializationEvent serializationEvent) throws SerializationNotSupportedException {
            Object object = serializationEvent.getItem();
            if (object instanceof SimpleStyle) {
                String string;
                String string2;
                LineType lineType;
                String string3;
                String string4;
                SimpleStyle simpleStyle = (SimpleStyle)object;
                XmlWriter xmlWriter = serializationEvent.getWriter();
                Node node = (Node)serializationEvent.getContext().getCurrentObject();
                Graph2D graph2D = (Graph2D)serializationEvent.getContext().getGraph();
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                xmlWriter.writeStartElement(tc, "http://www.yworks.com/xml/graphml");
                LineType lineType2 = (LineType)simpleStyle.getBorderLineType(nodeRealizer);
                if (lineType2 != null) {
                    SimpleStyleSerializer.b(xmlWriter, lineType2, "borderLine");
                }
                if ((string4 = GraphicsSerializationToolkit.valueOf(simpleStyle.getBorderLineColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("borderLineColor", string4);
                }
                if ((string3 = GraphicsSerializationToolkit.valueOf(simpleStyle.getBorderFillColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("borderFillColor", string3);
                }
                if ((lineType = (LineType)simpleStyle.getLineType(nodeRealizer)) != null) {
                    SimpleStyleSerializer.b(xmlWriter, lineType, "line");
                }
                if ((string2 = GraphicsSerializationToolkit.valueOf(simpleStyle.getLineColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("lineColor", string2);
                }
                if ((string = GraphicsSerializationToolkit.valueOf(simpleStyle.getFillColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("fillColor", string);
                }
                xmlWriter.writeEndElement();
                serializationEvent.setHandled(true);
            }
        }

        private static void b(XmlWriter xmlWriter, LineType lineType, String string) {
            block4: {
                boolean bl = TableGroupNodeRealizer.z;
                byte by = lineType.getLineStyle();
                xmlWriter.writeAttribute(string + "Type", SimpleStyleSerializer.l(by));
                xmlWriter.writeAttribute(string + "Width", Float.toString(lineType.getLineWidth()));
                if (by == 127) {
                    xmlWriter.writeAttribute(string + "Cap", lineType.getEndCap());
                    xmlWriter.writeAttribute(string + "Join", lineType.getLineJoin());
                    xmlWriter.writeAttribute(string + "MiterLimit", lineType.getMiterLimit());
                    xmlWriter.writeAttribute(string + "DashPhase", lineType.getDashPhase());
                    float[] fArray = lineType.getDashArray();
                    if (fArray != null && fArray.length > 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        String string2 = "";
                        for (int i2 = 0; i2 < fArray.length; ++i2) {
                            stringBuffer.append(string2).append(fArray[i2]);
                            string2 = ", ";
                            if (!bl) {
                                if (!bl) continue;
                            }
                            break block4;
                        }
                        xmlWriter.writeAttribute(string + "Dash", stringBuffer.toString());
                    }
                }
            }
        }

        private static String l(byte by) {
            switch (by) {
                case 0: {
                    return "line";
                }
                case 1: {
                    return "dashed";
                }
                case 2: {
                    return "dotted";
                }
                case 3: {
                    return "dashed_dotted";
                }
                case 127: {
                    return "custom";
                }
            }
            return "line";
        }
    }

    public static class SimpleStyle
    implements Externalizable,
    TableStyle {
        private LineType h;
        private Color c;
        private Color d;
        private LineType f;
        private Color e;
        private Color g;

        public SimpleStyle() {
            this(null, null, null, null, null, null);
        }

        public SimpleStyle(LineType lineType, Color color, Color color2) {
            this(null, null, null, lineType, color, color2);
        }

        public SimpleStyle(LineType lineType, Color color, Color color2, LineType lineType2, Color color3, Color color4) {
            this.h = lineType;
            this.c = color;
            this.d = color2;
            this.f = lineType2;
            this.e = color3;
            this.g = color4;
        }

        public Stroke getBorderLineType(NodeRealizer nodeRealizer) {
            return this.h;
        }

        public Color getBorderLineColor(NodeRealizer nodeRealizer) {
            return this.c;
        }

        public Color getBorderFillColor(NodeRealizer nodeRealizer) {
            return this.d;
        }

        public Stroke getLineType(NodeRealizer nodeRealizer) {
            return this.f;
        }

        public Color getLineColor(NodeRealizer nodeRealizer) {
            return this.e;
        }

        public Color getFillColor(NodeRealizer nodeRealizer) {
            return this.g;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            switch (objectInput.readByte()) {
                case 0: {
                    this.h = LineType.createLineType(objectInput);
                    this.c = (Color)objectInput.readObject();
                    this.d = (Color)objectInput.readObject();
                    this.f = LineType.createLineType(objectInput);
                    this.e = (Color)objectInput.readObject();
                    this.g = (Color)objectInput.readObject();
                    if (!TableGroupNodeRealizer.z) break;
                }
                default: {
                    throw new BadVersionException();
                }
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(0);
            LineType.serializeLineType(objectOutput, this.h);
            objectOutput.writeObject(this.c);
            objectOutput.writeObject(this.d);
            LineType.serializeLineType(objectOutput, this.f);
            objectOutput.writeObject(this.e);
            objectOutput.writeObject(this.g);
        }
    }
}

