/*
 * Decompiled with CFR 0.152.
 */
package y.view.hierarchy;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import y.base.Graph;
import y.base.Node;
import y.geom.YInsets;
import y.geom.YRectangle;
import y.view.AbstractMouseInputEditor;
import y.view.DefaultGraph2DRenderer;
import y.view.GenericNodeRealizer;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.Graph2DViewActions;
import y.view.HitInfo;
import y.view.Mouse2DEvent;
import y.view.MouseInputEditor;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.ShapeNodePainter;
import y.view.YLabel;
import y.view.YRenderingHints;
import y.view.hierarchy.GenericGroupNodeRealizer;
import y.view.hierarchy.GroupFeature;
import y.view.hierarchy.GroupNodeRealizer;
import y.view.hierarchy.HierarchyManager;

public class GroupNodePainter
implements GenericNodeRealizer.Painter,
GenericNodeRealizer.GenericMouseInputEditorProvider,
GenericNodeRealizer.Initializer,
GenericNodeRealizer.ContainsTest {
    public static final String GROUP_STATE_STYLE_ID = "y.view.hierarchy.GroupNodePainter.GROUP_STATE_STYLE";
    private static final NodeLabel lb = new GenericGroupNodeRealizer().getLabel();
    private boolean hb;
    private NodeLabel ib;
    private boolean gb = true;
    private Icon fb = GroupNodeRealizer.defaultClosedGroupIcon;
    private Icon jb = GroupNodeRealizer.defaultOpenGroupIcon;
    private final GenericNodeRealizer.Painter kb;

    public GroupNodePainter() {
        this(new ShapeNodePainter());
    }

    public GroupNodePainter(GenericNodeRealizer.Painter painter) {
        this.kb = painter;
    }

    public GenericNodeRealizer.Painter getPainterDelegate() {
        return this.kb;
    }

    public void paint(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        this.kb.paint(nodeRealizer, graphics2D);
        if (nodeRealizer instanceof GroupFeature && ((GroupFeature)((Object)nodeRealizer)).isGroupClosed() && this.hb) {
            this.paintInnerGraph(nodeRealizer, graphics2D);
        }
        this.paintGroupState(nodeRealizer, graphics2D, false);
    }

    public void paintSloppy(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        this.kb.paintSloppy(nodeRealizer, graphics2D);
        this.paintGroupState(nodeRealizer, graphics2D, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintGroupState(NodeRealizer nodeRealizer, Graphics2D graphics2D, boolean bl) {
        block7: {
            GroupNodePainter groupNodePainter = this;
            synchronized (groupNodePainter) {
                float f2;
                block8: {
                    if (YRenderingHints.VALUE_GROUP_STATE_PAINTING_OFF.equals(graphics2D.getRenderingHint(YRenderingHints.KEY_GROUP_STATE_PAINTING))) break block7;
                    f2 = this.getGroupStateOpacity(nodeRealizer);
                    if (!(f2 >= 1.0f)) break block8;
                    this.getStateLabel(nodeRealizer).paint(graphics2D);
                    if (HierarchyManager.z == 0) break block7;
                }
                if (f2 > 0.0f) {
                    NodeLabel nodeLabel = this.getStateLabel(nodeRealizer);
                    YRectangle yRectangle = nodeLabel.getBox();
                    int n2 = (int)Math.ceil(yRectangle.x + yRectangle.width) - (int)Math.floor(yRectangle.x);
                    int n3 = (int)Math.ceil(yRectangle.y + yRectangle.height) - (int)Math.floor(yRectangle.y);
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                    Graphics2D graphics2D2 = bufferedImage.createGraphics();
                    graphics2D2.translate(-yRectangle.x, -yRectangle.y);
                    nodeLabel.paint(graphics2D2);
                    graphics2D2.dispose();
                    Composite composite = graphics2D.getComposite();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(yRectangle.x, yRectangle.y);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.setTransform(affineTransform);
                    graphics2D.setComposite(composite);
                }
            }
        }
    }

    protected float getGroupStateOpacity(NodeRealizer nodeRealizer) {
        Object object;
        if (nodeRealizer instanceof GenericNodeRealizer && (object = ((GenericNodeRealizer)nodeRealizer).getStyleProperty(GROUP_STATE_STYLE_ID)) instanceof GroupStateStyle) {
            return ((GroupStateStyle)object).getOpacity();
        }
        return 1.0f;
    }

    protected void paintInnerGraph(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        Object object;
        block18: {
            DefaultGraph2DRenderer defaultGraph2DRenderer;
            Double d2;
            double d3;
            Graph2D graph2D;
            block17: {
                int n2 = HierarchyManager.z;
                Node node = nodeRealizer.getNode();
                HierarchyManager hierarchyManager = this.getHierarchyManager(node.getGraph());
                if (hierarchyManager == null) {
                    return;
                }
                if (!hierarchyManager.isFolderNode(node)) {
                    return;
                }
                graph2D = (Graph2D)hierarchyManager.getInnerGraph(node);
                YInsets yInsets = this.getInnerGraphInsets(nodeRealizer);
                double d4 = nodeRealizer.getHeight() - yInsets.top - yInsets.bottom;
                double d5 = nodeRealizer.getWidth() - yInsets.left - yInsets.right;
                double d6 = nodeRealizer.getX() + yInsets.left + 0.5 * d5;
                double d7 = nodeRealizer.getY() + yInsets.top + 0.5 * d4;
                if (nodeRealizer.labelCount() > 0 && ((YLabel)(object = nodeRealizer.getLabel())).isVisible()) {
                    switch (((YLabel)object).getModel()) {
                        case 1: {
                            switch (((NodeLabel)object).getPosition()) {
                                case 102: 
                                case 117: 
                                case 118: {
                                    d4 -= ((YLabel)object).getHeight();
                                    d7 += ((YLabel)object).getHeight() / 2.0;
                                    if (n2 == 0) break;
                                }
                                case 101: 
                                case 119: 
                                case 120: {
                                    d4 -= ((YLabel)object).getHeight();
                                    d7 -= ((YLabel)object).getHeight() / 2.0;
                                    if (n2 == 0) break;
                                }
                                case 115: {
                                    d5 -= ((YLabel)object).getWidth();
                                    d6 += ((YLabel)object).getWidth() / 2.0;
                                    if (n2 == 0) break;
                                }
                                case 116: {
                                    d5 -= ((YLabel)object).getWidth();
                                    d6 -= ((YLabel)object).getWidth() / 2.0;
                                    if (n2 == 0) break;
                                }
                            }
                            break;
                        }
                    }
                }
                if (d5 <= 5.0 || d4 <= 5.0) {
                    return;
                }
                object = graphics2D.getTransform();
                graphics2D.translate(d6, d7);
                Rectangle rectangle = graph2D.getBoundingBox();
                double d8 = d5 / rectangle.getWidth();
                double d9 = d4 / rectangle.getHeight();
                double d10 = Math.min(d8, d9);
                graphics2D.scale(d10, d10);
                graphics2D.translate(-rectangle.getCenterX(), -rectangle.getCenterY());
                d3 = d10 * ((AffineTransform)object).getScaleX();
                d2 = (Double)graphics2D.getRenderingHint(YRenderingHints.PAINT_DETAIL_THRESHOLD_KEY);
                defaultGraph2DRenderer = new DefaultGraph2DRenderer();
                if (d2 != null && !(d3 > d2)) break block17;
                defaultGraph2DRenderer.paint(graphics2D, graph2D);
                if (n2 == 0) break block18;
            }
            if (4.0 * d3 > d2) {
                defaultGraph2DRenderer.paintSloppy(graphics2D, graph2D);
            }
        }
        graphics2D.setTransform((AffineTransform)object);
    }

    protected YInsets getInnerGraphInsets(NodeRealizer nodeRealizer) {
        if (nodeRealizer instanceof GroupFeature) {
            return ((GroupFeature)((Object)nodeRealizer)).getMinimalInsets();
        }
        return new YInsets(15.0, 15.0, 15.0, 15.0);
    }

    public Icon getClosedGroupIcon() {
        return this.fb;
    }

    public void setClosedGroupIcon(Icon icon) {
        this.fb = icon;
    }

    public Icon getOpenGroupIcon() {
        return this.jb;
    }

    public void setOpenGroupIcon(Icon icon) {
        this.jb = icon;
    }

    public void setGroupDepthFillColorEnabled(boolean bl) {
        this.gb = bl;
    }

    public boolean isGroupDepthFillColorEnabled() {
        return this.gb;
    }

    protected NodeLabel getStateLabel(NodeRealizer nodeRealizer) {
        block7: {
            block5: {
                int n2;
                block6: {
                    n2 = HierarchyManager.z;
                    if (this.ib == null) {
                        this.ib = new NodeLabel();
                        this.ib.setPosition((byte)117);
                        this.ib.setDistance(1.0);
                    }
                    this.ib.bindRealizer(null);
                    if (!(nodeRealizer instanceof GroupFeature)) break block5;
                    if (!((GroupFeature)((Object)nodeRealizer)).isGroupClosed()) break block6;
                    if (this.ib.getIcon() == this.fb) break block7;
                    this.ib.setIcon(this.fb);
                    if (n2 == 0) break block7;
                }
                if (this.ib.getIcon() == this.jb) break block7;
                this.ib.setIcon(this.jb);
                if (n2 == 0) break block7;
            }
            if (this.ib.getIcon() != null) {
                this.ib.setIcon(null);
            }
        }
        this.ib.bindRealizer(nodeRealizer);
        return this.ib;
    }

    protected HierarchyManager getHierarchyManager(Graph graph) {
        return HierarchyManager.getInstance(graph);
    }

    public boolean isInnerGraphDisplayEnabled() {
        return this.hb;
    }

    public void setInnerGraphDisplayEnabled(boolean bl) {
        this.hb = bl;
    }

    public MouseInputEditor findMouseInputEditor(NodeRealizer nodeRealizer, Graph2DView graph2DView, double d2, double d3, HitInfo hitInfo) {
        if (nodeRealizer instanceof GenericGroupNodeRealizer) {
            if (this.getStateLabel(nodeRealizer).contains(d2, d3)) {
                return new GroupStateEditor(nodeRealizer, graph2DView){

                    protected boolean shouldChangeState(NodeRealizer nodeRealizer, double d2, double d3) {
                        return GroupNodePainter.this.getStateLabel(nodeRealizer).contains(d2, d3);
                    }
                };
            }
            return null;
        }
        return null;
    }

    public void initialize(NodeRealizer nodeRealizer) {
        GenericGroupNodeRealizer genericGroupNodeRealizer;
        NodeLabel nodeLabel;
        if (nodeRealizer instanceof GenericGroupNodeRealizer && (nodeLabel = (genericGroupNodeRealizer = (GenericGroupNodeRealizer)nodeRealizer).getLabel()) != null && this.b(nodeLabel)) {
            nodeLabel.setPosition((byte)102);
            nodeLabel.setFontSize(16);
            nodeLabel.setBackgroundColor(Color.darkGray);
            nodeLabel.setTextColor(Color.white);
            nodeLabel.setAlignment((byte)2);
            nodeLabel.setAutoSizePolicy((byte)1);
            nodeLabel.setDistance(0.0);
        }
    }

    private boolean b(NodeLabel nodeLabel) {
        boolean bl = lb.getAlignment() == nodeLabel.getAlignment();
        bl &= lb.getAutoSizePolicy() == nodeLabel.getAutoSizePolicy();
        bl &= GroupNodePainter.b(lb.getBackgroundColor(), nodeLabel.getBackgroundColor(), false);
        bl &= GroupNodePainter.b(lb.getBox(), nodeLabel.getBox(), false);
        bl &= GroupNodePainter.b(lb.getConfiguration(), nodeLabel.getConfiguration(), false);
        bl &= lb.getContentHeight() == nodeLabel.getContentHeight();
        bl &= lb.getContentWidth() == nodeLabel.getContentWidth();
        bl &= lb.getDistance() == nodeLabel.getDistance();
        bl &= GroupNodePainter.b(lb.getFont(), nodeLabel.getFont(), false);
        bl &= lb.getHeight() == nodeLabel.getHeight();
        bl &= lb.getHorizontalTextPosition() == nodeLabel.getHorizontalTextPosition();
        bl &= GroupNodePainter.b(lb.getIcon(), nodeLabel.getIcon(), false);
        bl &= GroupNodePainter.b(lb.getIconBox(), nodeLabel.getIconBox(), false);
        bl &= lb.getIconTextGap() == nodeLabel.getIconTextGap();
        bl &= GroupNodePainter.b(lb.getInsets(), nodeLabel.getInsets(), false);
        bl &= GroupNodePainter.b(lb.getLabelModel(), nodeLabel.getLabelModel(), true);
        bl &= GroupNodePainter.b(lb.getLineColor(), nodeLabel.getLineColor(), false);
        bl &= lb.getModel() == nodeLabel.getModel();
        bl &= GroupNodePainter.b(lb.getModelParameter(), nodeLabel.getModelParameter(), true);
        bl &= GroupNodePainter.b(lb.getOffset(), nodeLabel.getOffset(), false);
        bl &= lb.getPosition() == nodeLabel.getPosition();
        bl &= lb.getRotationAngle() == nodeLabel.getRotationAngle();
        bl &= GroupNodePainter.b(lb.getText(), nodeLabel.getText(), false);
        bl &= GroupNodePainter.b(lb.getTextColor(), nodeLabel.getTextColor(), false);
        bl &= GroupNodePainter.b(lb.getTextBox(), nodeLabel.getTextBox(), false);
        bl &= GroupNodePainter.b(lb.getUserData(), nodeLabel.getUserData(), true);
        bl &= lb.getVerticalTextPosition() == nodeLabel.getVerticalTextPosition();
        return bl &= lb.getWidth() == nodeLabel.getWidth();
    }

    private static boolean b(Object clazz, Object clazz2, boolean bl) {
        if (bl) {
            if (clazz != null) {
                clazz = clazz.getClass();
            }
            if (clazz2 != null) {
                clazz2 = clazz2.getClass();
            }
        }
        return clazz == clazz2 || clazz != null && clazz.equals(clazz2);
    }

    public boolean contains(NodeRealizer nodeRealizer, double d2, double d3) {
        if (this.kb instanceof GenericNodeRealizer.ContainsTest ? ((GenericNodeRealizer.ContainsTest)((Object)this.kb)).contains(nodeRealizer, d2, d3) : d2 >= nodeRealizer.getX() && d2 <= nodeRealizer.getX() + nodeRealizer.getWidth() && d3 >= nodeRealizer.getY() && d3 <= nodeRealizer.getY() + nodeRealizer.getHeight()) {
            return true;
        }
        return nodeRealizer.labelCount() > 0 && nodeRealizer.getLabel().contains(d2, d3);
    }

    public static abstract class GroupStateEditor
    extends AbstractMouseInputEditor {
        private final NodeRealizer i;
        private final Graph2DView h;

        protected GroupStateEditor(NodeRealizer nodeRealizer, Graph2DView graph2DView) {
            this.i = nodeRealizer;
            this.h = graph2DView;
        }

        public boolean startsEditing(Mouse2DEvent mouse2DEvent) {
            return this.shouldChangeState(this.i, mouse2DEvent.getX(), mouse2DEvent.getY());
        }

        public void mouse2DEventHappened(Mouse2DEvent mouse2DEvent) {
            block7: {
                boolean bl;
                block9: {
                    HierarchyManager hierarchyManager;
                    Node node;
                    block8: {
                        if (!this.shouldChangeState(this.i, mouse2DEvent.getX(), mouse2DEvent.getY())) {
                            this.stopEditing();
                            return;
                        }
                        if (mouse2DEvent.getId() != 500) break block7;
                        node = this.i.getNode();
                        if (node == null || node.getGraph() == null) {
                            return;
                        }
                        hierarchyManager = HierarchyManager.getInstance(this.h.getGraph2D());
                        if (hierarchyManager == null || !hierarchyManager.contains(node.getGraph())) break block7;
                        bl = false;
                        if (!hierarchyManager.isFolderNode(node)) break block8;
                        this.openFolder(node, hierarchyManager);
                        bl = true;
                        if (HierarchyManager.z == 0) break block9;
                    }
                    if (hierarchyManager.isGroupNode(node)) {
                        this.closeGroup(node, hierarchyManager);
                        bl = true;
                    }
                }
                if (bl) {
                    this.stopEditing();
                }
            }
        }

        protected abstract boolean shouldChangeState(NodeRealizer var1, double var2, double var4);

        protected void openFolder(Node node, HierarchyManager hierarchyManager) {
            GroupStateEditor.b(node, Graph2DViewActions.OPEN_FOLDERS, this.h);
        }

        protected void closeGroup(Node node, HierarchyManager hierarchyManager) {
            GroupStateEditor.b(node, Graph2DViewActions.CLOSE_GROUPS, this.h);
        }

        private static void b(Node node, Object object, Graph2DView graph2DView) {
            Action action = GroupStateEditor.b(object, graph2DView);
            if (action != null) {
                if (node != null) {
                    Graph2D graph2D = graph2DView.getGraph2D();
                    graph2D.unselectAll();
                    graph2D.setSelected(node, true);
                }
                action.actionPerformed(new ActionEvent(graph2DView, 1001, ""));
            }
        }

        private static Action b(Object object, Graph2DView graph2DView) {
            Action action;
            ActionMap actionMap = graph2DView.getCanvasComponent().getActionMap();
            if (actionMap != null && (action = actionMap.get(object)) != null) {
                return action;
            }
            return new Graph2DViewActions(graph2DView).createActionMap().get(object);
        }
    }

    public static final class GroupStateStyle {
        private float b;

        public float getOpacity() {
            return this.b;
        }

        public void setOpacity(float f2) {
            block3: {
                block4: {
                    int n2;
                    block2: {
                        n2 = HierarchyManager.z;
                        if (!(f2 < 0.0f)) break block2;
                        this.b = 0.0f;
                        if (n2 == 0) break block3;
                    }
                    if (!(f2 > 1.0f)) break block4;
                    this.b = 1.0f;
                    if (n2 == 0) break block3;
                }
                this.b = f2;
            }
        }
    }
}

